/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class FilterGenotypeTableBuilder2 {
    private final GenotypeTable myBaseGenotypeTable;
    private double myMinFreqForSite = 0.0;
    private double myMaxFreqForSite = 1.0;
    private int myMinCountForSite = 0;
    private int myMaxCountForSite = Integer.MAX_VALUE;
    private double myMinHeterozygousForSite = 0.0;
    private double myMaxHeterozygousForSite = 1.0;
    private int[] mySitesToKeep = null;
    private List<String> mySiteNamesToKeep = null;
    private List<String> mySiteNamesToRemove = null;
    private TaxaListBuilder myTaxaToKeep = new TaxaListBuilder();
    private TaxaListBuilder myTaxaToRemove = new TaxaListBuilder();
    private double myMinHeterozygousForTaxon = 0.0;
    private double myMaxHeterozygousForTaxon = 1.0;
    private double myMinNotMissingForTaxon = 0.0;
    private double myMaxNotMissingForTaxon = 1.0;

    private FilterGenotypeTableBuilder2(GenotypeTable baseGenotypeTable) {
        this.myBaseGenotypeTable = baseGenotypeTable;
    }

    public static FilterGenotypeTableBuilder2 getInstance(GenotypeTable baseGenotypeTable) {
        return new FilterGenotypeTableBuilder2(baseGenotypeTable);
    }

    public FilterGenotypeTableBuilder2 minorAlleleFreqForSite(double minFreq, double maxFreq) {
        if (minFreq < 0.0 || minFreq > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: minorAlleleFreqForSite: Min Value must be between 0.0 and 1.0: " + minFreq);
        }
        if (maxFreq < 0.0 || maxFreq > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: minorAlleleFreqForSite: Max Value must be between 0.0 and 1.0: " + maxFreq);
        }
        this.myMinFreqForSite = minFreq;
        this.myMaxFreqForSite = maxFreq;
        return this;
    }

    public FilterGenotypeTableBuilder2 minCountForSite(int count) {
        this.myMinCountForSite = count;
        return this;
    }

    public void sitesToKeep(int[] sitesToKeep) {
        this.mySitesToKeep = sitesToKeep;
    }

    public void siteNamesToKeep(List<String> sitesToKeep) {
        this.mySiteNamesToKeep = sitesToKeep;
    }

    public void siteNamesToRemove(List<String> sitesToRemove) {
        this.mySiteNamesToRemove = sitesToRemove;
    }

    public FilterGenotypeTableBuilder2 taxaToKeep(TaxaList taxaToKeep) {
        this.myTaxaToKeep.addAll(taxaToKeep);
        return this;
    }

    public FilterGenotypeTableBuilder2 taxaToRemove(TaxaList taxaToRemove) {
        this.myTaxaToRemove.addAll(taxaToRemove);
        return this;
    }

    public FilterGenotypeTableBuilder2 minNotMissingForTaxon(int minNotMissing) {
        if ((double)minNotMissing < 0.0 || (double)minNotMissing > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMinNotMissingForTaxon: Value must be between 0.0 and 1.0: " + minNotMissing);
        }
        this.myMinNotMissingForTaxon = minNotMissing;
        return this;
    }

    public FilterGenotypeTableBuilder2 minHeterozygousForTaxon(double minHeterozygous) {
        if (minHeterozygous < 0.0 || minHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMinHeterozygousForTaxon: Value must be between 0.0 and 1.0: " + minHeterozygous);
        }
        this.myMinHeterozygousForTaxon = minHeterozygous;
        return this;
    }

    public FilterGenotypeTableBuilder2 maxHeterozygousForTaxon(double maxHeterozygous) {
        if (maxHeterozygous < 0.0 || maxHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMaxHeterozygousForTaxon: Value must be between 0.0 and 1.0: " + maxHeterozygous);
        }
        this.myMaxHeterozygousForTaxon = maxHeterozygous;
        return this;
    }

    public FilterGenotypeTableBuilder2 minHeterozygousForSite(double maxHeterozygous) {
        if (maxHeterozygous < 0.0 || maxHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMaxHeterozygousForTaxon: Value must be between 0.0 and 1.0: " + maxHeterozygous);
        }
        this.myMinHeterozygousForSite = maxHeterozygous;
        return this;
    }

    public FilterGenotypeTableBuilder2 maxHeterozygousForSite(double maxHeterozygous) {
        if (maxHeterozygous < 0.0 || maxHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMaxHeterozygousForTaxon: Value must be between 0.0 and 1.0: " + maxHeterozygous);
        }
        this.myMaxHeterozygousForSite = maxHeterozygous;
        return this;
    }

    public GenotypeTable build() {
        this.correctNullValues();
        TaxaList taxaToKeep = this.getTaxaListToKeep();
        PositionList sitesToKeep = this.getPositionListToKeep();
        GenotypeTable result = this.myBaseGenotypeTable;
        if (taxaToKeep.size() != result.numberOfTaxa()) {
            result = FilterGenotypeTable.getInstance(result, taxaToKeep);
        }
        if (sitesToKeep.size() != result.numberOfSites()) {
            result = FilterGenotypeTable.getInstance(result, sitesToKeep);
        }
        return result;
    }

    private TaxaList getTaxaListToKeep() {
        TaxaList badTaxaNames;
        TaxaList goodTaxaNames = this.myTaxaToKeep.build();
        TaxaList taxaConflicts = FilterGenotypeTableBuilder2.taxaListsOverlap(goodTaxaNames, badTaxaNames = this.myTaxaToRemove.build());
        if (taxaConflicts.size() > 0) {
            StringBuilder intersects = new StringBuilder();
            for (Taxon t : taxaConflicts) {
                intersects.append(t.getName() + "\n");
            }
            throw new IllegalStateException("FilterGenotypeTableBuilder: build: Taxa list to keep and to remove contain the same taxa:\n" + intersects.toString());
        }
        TaxaListBuilder badTaxaBuilder = new TaxaListBuilder();
        for (int t = 0; t < this.myBaseGenotypeTable.numberOfTaxa(); ++t) {
            Taxon currentTaxon = (Taxon)this.myBaseGenotypeTable.taxa().get(t);
            int totalSitesNotMissing = this.myBaseGenotypeTable.totalNonMissingForTaxon(t);
            double percentNotMissing = (double)totalSitesNotMissing / (double)this.myBaseGenotypeTable.numberOfSites();
            if (this.valueOutsideOfRange(percentNotMissing, this.myMinNotMissingForTaxon, this.myMaxNotMissingForTaxon)) {
                badTaxaBuilder.add(currentTaxon);
                continue;
            }
            int numHeterozygous = this.myBaseGenotypeTable.heterozygousCountForTaxon(t);
            double percentHets = (double)numHeterozygous / (double)totalSitesNotMissing;
            if (!(percentHets < this.myMinHeterozygousForTaxon) && !(percentHets > this.myMaxHeterozygousForTaxon)) continue;
            badTaxaBuilder.add(currentTaxon);
        }
        badTaxaBuilder.addAll(badTaxaNames);
        TaxaList badTaxa = badTaxaBuilder.build();
        TaxaListBuilder goodTaxaBuilder = new TaxaListBuilder();
        for (Taxon t : this.myBaseGenotypeTable.taxa()) {
            if (!goodTaxaNames.contains(t) && badTaxa.contains(t)) continue;
            goodTaxaBuilder.add(t);
        }
        return goodTaxaBuilder.build();
    }

    private void correctNullValues() {
        if (this.mySitesToKeep == null) {
            this.mySitesToKeep = new int[0];
        }
        if (this.mySiteNamesToKeep == null) {
            this.mySiteNamesToKeep = new ArrayList<String>();
        }
        if (this.mySiteNamesToRemove == null) {
            this.mySiteNamesToRemove = new ArrayList<String>();
        }
    }

    private PositionList getPositionListToKeep() {
        PositionList goodPositionsFromNames = FilterGenotypeTableBuilder2.getPositionsFromSiteNames(this.mySiteNamesToKeep, this.myBaseGenotypeTable);
        PositionList goodPositionsFromIndex = FilterGenotypeTableBuilder2.getPositionsFromSiteIndex(this.mySitesToKeep, this.myBaseGenotypeTable);
        PositionList goodPositions = new PositionListBuilder().addAll(goodPositionsFromNames).addAll(goodPositionsFromIndex).build();
        PositionList badPositionsList = FilterGenotypeTableBuilder2.getPositionsFromSiteNames(this.mySiteNamesToRemove, this.myBaseGenotypeTable);
        PositionList siteConflicts = FilterGenotypeTableBuilder2.positionListsOverlap(goodPositionsFromNames, badPositionsList);
        if (siteConflicts.size() > 0) {
            StringBuilder intersects = new StringBuilder();
            for (Position p : siteConflicts) {
                intersects.append(p.getSNPID() + "\n");
            }
            throw new IllegalStateException("FilterGenotypeTableBuilder: build: Some sites manually specified both to keep and to remove:\n" + intersects.toString());
        }
        PositionListBuilder badSiteBuilder = new PositionListBuilder();
        for (int s = 0; s < this.myBaseGenotypeTable.numberOfSites(); ++s) {
            Position currentSite = (Position)this.myBaseGenotypeTable.positions().get(s);
            double maf = this.myBaseGenotypeTable.minorAlleleFrequency(s);
            if (this.valueOutsideOfRange(maf, this.myMinFreqForSite, this.myMaxFreqForSite)) {
                badSiteBuilder.add(currentSite);
                continue;
            }
            int notMissing = this.myBaseGenotypeTable.totalNonMissingForSite(s);
            if (this.valueOutsideOfRange(notMissing, this.myMinCountForSite, this.myMaxCountForSite)) {
                badSiteBuilder.add(currentSite);
                continue;
            }
            double hetCount = (double)this.myBaseGenotypeTable.heterozygousCount(s) / (double)this.myBaseGenotypeTable.numberOfTaxa();
            if (!this.valueOutsideOfRange(hetCount, this.myMinHeterozygousForSite, this.myMaxHeterozygousForSite)) continue;
            badSiteBuilder.add(currentSite);
        }
        badSiteBuilder.addAll(badPositionsList);
        PositionList badPositions = badSiteBuilder.build();
        PositionListBuilder goodSiteBuilder = new PositionListBuilder();
        for (Position p : this.myBaseGenotypeTable.positions()) {
            if (!goodPositionsFromNames.contains(p) && badPositions.contains(p)) continue;
            goodSiteBuilder.add(p);
        }
        return goodSiteBuilder.build();
    }

    private boolean valueOutsideOfRange(double val, double min, double max) {
        return val < min || val > max;
    }

    public static TaxaList taxaListsOverlap(TaxaList a, TaxaList b) {
        TaxaListBuilder intersection = new TaxaListBuilder();
        for (Taxon t : a) {
            if (!b.contains(t)) continue;
            intersection.add(t);
        }
        return intersection.build();
    }

    private static PositionList getPositionsFromSiteNames(List<String> names, GenotypeTable genos) {
        PositionListBuilder posBuilder = new PositionListBuilder();
        for (int s = 0; s < genos.numberOfSites(); ++s) {
            if (!names.contains(genos.siteName(s))) continue;
            posBuilder.add((Position)genos.positions().get(s));
        }
        return posBuilder.build();
    }

    private static PositionList getPositionsFromSiteIndex(int[] indices, GenotypeTable genos) {
        PositionListBuilder posBuilder = new PositionListBuilder();
        for (int i : indices) {
            posBuilder.add((Position)genos.positions().get(i));
        }
        return posBuilder.build();
    }

    private static PositionList positionListsOverlap(PositionList a, PositionList b) {
        PositionListBuilder intersection = new PositionListBuilder();
        for (Position p : a) {
            if (!b.contains(p)) continue;
            intersection.add(p);
        }
        return intersection.build();
    }
}

