/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.Set;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.Dosage;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.GeneralAnnotationStorage;

public interface GenotypeTable {
    public static final byte RARE_ALLELE = 14;
    public static final byte RARE_DIPLOID_ALLELE = -18;
    public static final String RARE_ALLELE_STR = "Z";
    public static final byte UNKNOWN_ALLELE = 15;
    public static final byte UNKNOWN_DIPLOID_ALLELE = -1;
    public static final String UNKNOWN_ALLELE_STR = "N";
    public static final String UNKNOWN_DIPLOID_ALLELE_STR = "N:N";
    public static final char UNKNOWN_ALLELE_CHAR = 'N';
    public static final String ANNOTATION_DATA_SET_NAME = "dataSetName";
    public static final String ANNOTATION_DATA_SET_DESCRIPTION = "dataSetDescription";
    public static final String[] GENOTYPE_TABLE_ANNOTATIONS = new String[]{"dataSetName", "dataSetDescription"};

    public GenotypeCallTable genotypeMatrix();

    public byte genotype(int var1, int var2);

    public byte[] genotypeArray(int var1, int var2);

    public byte genotype(int var1, Chromosome var2, int var3);

    public byte[] genotypeRange(int var1, int var2, int var3);

    public byte[] genotypeAllSites(int var1);

    public byte[] genotypeAllTaxa(int var1);

    public BitSet allelePresenceForAllSites(int var1, WHICH_ALLELE var2);

    public long[] allelePresenceForSitesBlock(int var1, WHICH_ALLELE var2, int var3, int var4);

    public BitSet haplotypeAllelePresenceForAllSites(int var1, boolean var2, WHICH_ALLELE var3);

    public BitSet haplotypeAllelePresenceForAllTaxa(int var1, boolean var2, WHICH_ALLELE var3);

    public long[] haplotypeAllelePresenceForSitesBlock(int var1, boolean var2, WHICH_ALLELE var3, int var4, int var5);

    public String genotypeAsString(int var1, int var2);

    public String genotypeAsStringRange(int var1, int var2, int var3);

    public String genotypeAsStringRow(int var1);

    public String[] genotypeAsStringArray(int var1, int var2);

    public byte referenceAllele(int var1);

    public byte[] referenceAlleles(int var1, int var2);

    public byte[] referenceAlleleForAllSites();

    public boolean hasReference();

    public boolean isHeterozygous(int var1, int var2);

    public int heterozygousCount(int var1);

    public String siteName(int var1);

    public int numberOfSites();

    public int chromosomeSiteCount(Chromosome var1);

    public int[] firstLastSiteOfChromosome(Chromosome var1);

    public int numberOfTaxa();

    public PositionList positions();

    public int chromosomalPosition(int var1);

    public int siteOfPhysicalPosition(int var1, Chromosome var2);

    public int siteOfPhysicalPosition(int var1, Chromosome var2, String var3);

    public int[] physicalPositions();

    public String chromosomeName(int var1);

    public Chromosome chromosome(int var1);

    public Chromosome chromosome(String var1);

    public Chromosome[] chromosomes();

    public int numChromosomes();

    public int[] chromosomesOffsets();

    public boolean hasDepth();

    public boolean hasAlleleProbabilities();

    public boolean hasReferenceProbablity();

    public boolean hasDosage();

    public Set<SiteScore.SITE_SCORE_TYPE> siteScoreTypes();

    public AlleleProbability alleleProbability();

    public float alleleProbability(int var1, int var2, SiteScore.SITE_SCORE_TYPE var3);

    public Dosage dosage();

    public byte dosage(int var1, int var2);

    public int indelSize(int var1);

    public boolean isIndel(int var1);

    public boolean isAllPolymorphic();

    public boolean isPolymorphic(int var1);

    public byte majorAllele(int var1);

    public String majorAlleleAsString(int var1);

    public byte minorAllele(int var1);

    public String minorAlleleAsString(int var1);

    public byte[] minorAlleles(int var1);

    public byte[] alleles(int var1);

    public double minorAlleleFrequency(int var1);

    public double majorAlleleFrequency(int var1);

    public TaxaList taxa();

    public String taxaName(int var1);

    public String genomeVersion();

    public boolean isPositiveStrand(int var1);

    public GenotypeTable[] compositeAlignments();

    public int[][] allelesSortedByFrequency(int var1);

    public Object[][] genosSortedByFrequency(int var1);

    public boolean isPhased();

    public boolean retainsRareAlleles();

    public String[][] alleleDefinitions();

    public String[] alleleDefinitions(int var1);

    public String genotypeAsString(int var1, byte var2);

    public String diploidAsString(int var1, byte var2);

    public int maxNumAlleles();

    public int totalGametesNonMissingForSite(int var1);

    public int totalNonMissingForSite(int var1);

    public int minorAlleleCount(int var1);

    public int majorAlleleCount(int var1);

    public Object[][] genoCounts();

    public Object[][] majorMinorCounts();

    public int totalGametesNonMissingForTaxon(int var1);

    public int heterozygousCountForTaxon(int var1);

    public int totalNonMissingForTaxon(int var1);

    public AlleleDepth depth();

    public int[] depthForAlleles(int var1, int var2);

    public byte[] allelesBySortType(ALLELE_SORT_TYPE var1, int var2);

    public BitSet allelePresenceForAllTaxa(int var1, WHICH_ALLELE var2);

    public BitStorage bitStorage(WHICH_ALLELE var1);

    public GeneralAnnotationStorage annotations();

    public static enum ALLELE_SORT_TYPE {
        Frequency,
        Depth,
        Global_Frequency,
        Reference;

    }
}

