/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.dna.snp.io.BuilderFromPLINK;
import net.maizegenetics.dna.snp.io.BuilderFromVCF;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ImportUtils {
    private static final Logger myLogger = Logger.getLogger(ImportUtils.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    public static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;

    private ImportUtils() {
    }

    public static GenotypeTable readGuessFormat(String fileName) {
        try {
            if (fileName.endsWith(".h5")) {
                return GenotypeTableBuilder.getInstance(fileName);
            }
            if (fileName.endsWith("hmp.txt.gz") || fileName.endsWith("hmp.txt")) {
                return ImportUtils.readFromHapmap(fileName, null);
            }
            if (fileName.endsWith(".vcf") || fileName.endsWith(".vcf.gz")) {
                return ImportUtils.readFromVCF(fileName, null);
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error reading:" + fileName);
            e.printStackTrace();
            return null;
        }
    }

    public static GenotypeTable readFromVCF(String filename, ProgressListener listener, boolean ignoreDepth) {
        if (ignoreDepth) {
            return BuilderFromVCF.getBuilder(filename).keepDepth().build();
        }
        return BuilderFromVCF.getBuilder(filename).build();
    }

    public static GenotypeTable readFromVCF(String filename, ProgressListener listener) {
        return ImportUtils.readFromVCF(filename, listener, true);
    }

    public static GenotypeTable readFromHapmap(String filename) {
        return ImportUtils.readFromHapmap(filename, null);
    }

    public static GenotypeTable readFromHapmap(String filename, ProgressListener listener) {
        return BuilderFromHapMap.getBuilder(filename, listener).build();
    }

    public static GenotypeTable readFromPLink(String pedFilename, String mapFilename, ProgressListener listener) {
        return BuilderFromPLINK.getBuilder(pedFilename, mapFilename, listener).build();
    }

    public static GenotypeTable readFasta(String filename) throws FileNotFoundException, IOException {
        BufferedReader reader = Utils.getBufferedReader(filename);
        ArrayList<String> taxa = new ArrayList<String>();
        ArrayList<String> sequences = new ArrayList<String>();
        String line = reader.readLine();
        boolean sequence = false;
        int sequenceLength = -1;
        int count = 1;
        while (line != null) {
            if ((line = line.trim()).startsWith(";")) {
                line = reader.readLine();
                continue;
            }
            if (line.startsWith(">")) {
                StringTokenizer tokens = new StringTokenizer(line);
                String taxaName = tokens.nextToken();
                taxaName = taxaName.length() == 1 ? tokens.nextToken() : taxaName.substring(1).trim();
                taxa.add(taxaName);
                sequence = true;
                line = reader.readLine();
                continue;
            }
            if (sequence) {
                StringBuilder builder = new StringBuilder();
                while (line != null && !line.startsWith(">") && !line.startsWith(";")) {
                    line = line.trim().toUpperCase();
                    builder.append(line);
                    line = reader.readLine();
                }
                String temp = builder.toString();
                if (sequenceLength == -1) {
                    sequenceLength = temp.length();
                } else if (sequenceLength != temp.length()) {
                    throw new IllegalStateException("ImportUtils: readFasta: Sequence: " + count + " Differs in Length.");
                }
                sequences.add(temp);
                sequence = false;
                ++count;
                continue;
            }
            myLogger.error((Object)("readFasta: file: " + filename + " invalid format."));
            throw new IllegalArgumentException("Import: readFasta: invalid format.");
        }
        String[] taxaNames = new String[taxa.size()];
        taxa.toArray(taxaNames);
        TaxaList taxaList = new TaxaListBuilder().addAll(taxaNames).build();
        String[] sequenceArray = new String[sequences.size()];
        sequences.toArray(sequenceArray);
        GenotypeCallTable genotype = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(sequences.size(), sequenceLength).setBases(sequenceArray).build();
        return GenotypeTableBuilder.getInstance(genotype, PositionListBuilder.getInstance(sequenceLength), taxaList);
    }
}

