/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.byte2d;

import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.score.SiteScore;

public abstract class AbstractByte2D
implements Byte2D {
    private final SiteScore.SITE_SCORE_TYPE myScoreType;
    private final int myNumTaxa;
    private final int myNumSites;

    public AbstractByte2D(SiteScore.SITE_SCORE_TYPE scoreType, int numTaxa, int numSites) {
        this.myScoreType = scoreType;
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
    }

    @Override
    public byte[] valuesForAllSites(int taxon) {
        byte[] result = new byte[this.myNumSites];
        for (int site = 0; site < this.myNumSites; ++site) {
            result[site] = this.valueForAllele(taxon, site);
        }
        return result;
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }

    @Override
    public SiteScore.SITE_SCORE_TYPE siteScoreType() {
        return this.myScoreType;
    }
}

