/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.byte2d;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.byte2d.FilterByte2D;
import net.maizegenetics.dna.snp.byte2d.HDF5Byte2D;
import net.maizegenetics.dna.snp.byte2d.MemoryByte2D;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;

public class Byte2DBuilder {
    private SuperByteMatrix myValues = null;
    private final boolean myIsHDF5;
    private IHDF5Writer myHDF5Writer = null;
    private final int myNumSites;
    private int myNumTaxa = 0;
    private final SiteScore.SITE_SCORE_TYPE mySiteScoreType;
    private final TaxaList myTaxaList;

    private Byte2DBuilder(IHDF5Writer writer, int numSites, SiteScore.SITE_SCORE_TYPE siteScoreType, TaxaList taxaList) {
        this.myIsHDF5 = true;
        this.myHDF5Writer = writer;
        this.myNumSites = numSites;
        this.mySiteScoreType = siteScoreType;
        this.myTaxaList = taxaList;
    }

    private Byte2DBuilder(int numTaxa, int numSites, SiteScore.SITE_SCORE_TYPE siteScoreType, TaxaList taxaList) {
        this.myIsHDF5 = false;
        this.myHDF5Writer = null;
        this.myNumSites = numSites;
        this.myNumTaxa = numTaxa;
        this.mySiteScoreType = siteScoreType;
        this.myValues = SuperByteMatrixBuilder.getInstance(this.myNumTaxa, this.myNumSites);
        this.myTaxaList = taxaList;
    }

    public static Byte2DBuilder getInstance(int numTaxa, int numSites, SiteScore.SITE_SCORE_TYPE siteScoreType, TaxaList taxaList) {
        return new Byte2DBuilder(numTaxa, numSites, siteScoreType, taxaList);
    }

    public static Byte2DBuilder getInstance(IHDF5Writer writer, int numSites, SiteScore.SITE_SCORE_TYPE siteScoreType, TaxaList taxaList) {
        return new Byte2DBuilder(writer, numSites, siteScoreType, taxaList);
    }

    public static FilterByte2D getFilteredInstance(Byte2D base, FilterGenotypeTable filterGenotypeTable) {
        return new FilterByte2D(base, filterGenotypeTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Byte2DBuilder addTaxon(int taxon, byte[] values) {
        if (values.length != this.myNumSites) {
            throw new IllegalStateException("Byte2DBuilder: addTaxon: Number of sites: " + values.length + " should be: " + this.myNumSites);
        }
        if (this.myIsHDF5) {
            IHDF5Writer iHDF5Writer = this.myHDF5Writer;
            synchronized (iHDF5Writer) {
                HDF5Utils.writeHDF5GenotypeSiteScores(this.myHDF5Writer, ((Taxon)this.myTaxaList.get(taxon)).getName(), this.mySiteScoreType.toString(), values);
            }
            ++this.myNumTaxa;
        } else {
            for (int s = 0; s < this.myNumSites; ++s) {
                this.myValues.set(taxon, s, values[s]);
            }
        }
        return this;
    }

    public Byte2D build() {
        if (this.myIsHDF5) {
            IHDF5Writer reader = this.myHDF5Writer;
            this.myHDF5Writer = null;
            return new HDF5Byte2D((IHDF5Reader)reader, this.mySiteScoreType);
        }
        SuperByteMatrix temp = this.myValues;
        this.myValues = null;
        return new MemoryByte2D(this.mySiteScoreType, temp);
    }
}

