/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;

public class AlleleFreqCache {
    private static final int SHIFT_AMOUNT = 10;
    private static final int NUM_SITES_TO_CACHE = 1024;
    public static final int SITE_BLOCK_MASK = -1024;
    private static final int MAX_CACHE_SIZE = 150;
    private final GenotypeCallTable myGenotype;
    private final int myMaxNumAlleles;
    private final Map<Integer, int[][][]> myCachedInternal = new LinkedHashMap<Integer, int[][][]>(225){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 150;
        }
    };
    private final Map<Integer, int[][][]> myCachedAlleleFreqs = Collections.synchronizedMap(this.myCachedInternal);
    private final int myMaxNumThreads = Runtime.getRuntime().availableProcessors();
    private int myNumRunningThreads = 0;

    public AlleleFreqCache(GenotypeCallTable genotype, int maxNumAlleles) {
        this.myGenotype = genotype;
        this.myMaxNumAlleles = maxNumAlleles;
    }

    private static int getStartSite(int site) {
        return site & 0xFFFFFC00;
    }

    private int[][] getCachedAlleleFreq(int site) {
        int startSite = AlleleFreqCache.getStartSite(site);
        int[][][] result = this.myCachedAlleleFreqs.get(startSite);
        if (result == null) {
            if (this.myNumRunningThreads < this.myMaxNumThreads) {
                new Thread(new LookAheadSiteStats(startSite + 10240)).start();
            }
            result = this.calculateAlleleFreq(startSite);
        }
        if (site == startSite && this.myNumRunningThreads < this.myMaxNumThreads) {
            new Thread(new LookAheadSiteStats(startSite + 20480)).start();
        }
        return result[site - startSite];
    }

    public int[][] getAllelesSortedByFrequency(int site) {
        return this.getCachedAlleleFreq(site);
    }

    private int[][][] calculateAlleleFreq(int site) {
        int s;
        int startSite = AlleleFreqCache.getStartSite(site);
        int numSites = Math.min(1024, this.myGenotype.numberOfSites() - startSite);
        int numTaxa = this.myGenotype.numberOfTaxa();
        int[][] alleleFreq = new int[numSites][this.myMaxNumAlleles];
        for (int taxon = 0; taxon < numTaxa; ++taxon) {
            for (s = 0; s < numSites; ++s) {
                byte[] b = this.myGenotype.genotypeArray(taxon, s + startSite);
                if (b[0] < this.myMaxNumAlleles) {
                    int[] nArray = alleleFreq[s];
                    byte by = b[0];
                    nArray[by] = nArray[by] + 1;
                }
                if (b[1] >= this.myMaxNumAlleles) continue;
                int[] nArray = alleleFreq[s];
                byte by = b[1];
                nArray[by] = nArray[by] + 1;
            }
        }
        for (int s2 = 0; s2 < numSites; ++s2) {
            for (int i = 0; i < this.myMaxNumAlleles; i = (int)((byte)(i + 1))) {
                alleleFreq[s2][i] = alleleFreq[s2][i] << 4 | this.myMaxNumAlleles - 1 - i;
            }
        }
        int[][][] alleleCounts = new int[numSites][][];
        for (s = 0; s < numSites; ++s) {
            int numAlleles = this.sort(alleleFreq[s]);
            alleleCounts[s] = new int[2][numAlleles];
            for (int i = 0; i < numAlleles; ++i) {
                alleleCounts[s][0][i] = (byte)(5 - (0xF & alleleFreq[s][i]));
                alleleCounts[s][1][i] = alleleFreq[s][i] >>> 4;
            }
        }
        this.myCachedAlleleFreqs.put(startSite, alleleCounts);
        return alleleCounts;
    }

    private int sort(int[] data) {
        int countNotZero = 0;
        for (int j = 0; j < this.myMaxNumAlleles - 1; ++j) {
            int imax = j;
            for (int i = j + 1; i < this.myMaxNumAlleles; ++i) {
                if (data[i] <= data[imax]) continue;
                imax = i;
            }
            if (data[imax] > 15) {
                int temp = data[j];
                data[j] = data[imax];
                data[imax] = temp;
                ++countNotZero;
                continue;
            }
            return countNotZero;
        }
        if (data[5] > 15) {
            ++countNotZero;
        }
        return countNotZero;
    }

    private class LookAheadSiteStats
    implements Runnable {
        private final int myStartSite;

        public LookAheadSiteStats(int site) {
            AlleleFreqCache.this.myNumRunningThreads++;
            this.myStartSite = AlleleFreqCache.getStartSite(site);
        }

        @Override
        public void run() {
            try {
                if (this.myStartSite >= AlleleFreqCache.this.myGenotype.numberOfSites()) {
                    return;
                }
                if (AlleleFreqCache.this.myCachedAlleleFreqs.get(this.myStartSite) == null) {
                    AlleleFreqCache.this.calculateAlleleFreq(this.myStartSite);
                }
            }
            finally {
                AlleleFreqCache.this.myNumRunningThreads--;
            }
        }
    }
}

