/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import net.maizegenetics.dna.snp.depth.AlleleDepthUtil;
import net.maizegenetics.dna.snp.genotypecall.GenotypeMergeRule;
import org.apache.commons.math.distribution.BinomialDistributionImpl;

public class BasicGenotypeMergeRule
implements GenotypeMergeRule {
    private final double errorRate;
    private final int maxCountAtGeno = 500;
    private final int[] likelihoodRatioThreshAlleleCnt;

    private void setLikelihoodThresh() {
        for (int trials = 0; trials < 2; ++trials) {
            this.likelihoodRatioThreshAlleleCnt[trials] = 1;
        }
        int lastThresh = 1;
        for (int trials = 2; trials < this.likelihoodRatioThreshAlleleCnt.length; ++trials) {
            BinomialDistributionImpl binomHet = new BinomialDistributionImpl(trials, 0.5);
            BinomialDistributionImpl binomErr = new BinomialDistributionImpl(trials, this.errorRate);
            try {
                double LikeRatio = binomHet.cumulativeProbability(lastThresh) / (1.0 - binomErr.cumulativeProbability(lastThresh) + binomErr.probability(lastThresh));
                while (LikeRatio <= 1.0) {
                    LikeRatio = binomHet.cumulativeProbability(++lastThresh) / (1.0 - binomErr.cumulativeProbability(lastThresh) + binomErr.probability(lastThresh));
                }
                this.likelihoodRatioThreshAlleleCnt[trials] = lastThresh;
                continue;
            }
            catch (Exception e) {
                System.err.println("Error in the TagsAtLocus.BinomialDistributionImpl");
            }
        }
        System.out.println("\n");
    }

    public BasicGenotypeMergeRule(double errorRate) {
        this.errorRate = errorRate;
        this.likelihoodRatioThreshAlleleCnt = new int[500];
        this.setLikelihoodThresh();
    }

    @Override
    public boolean isMergePossible() {
        return true;
    }

    @Override
    public byte mergeCalls(byte geno1, byte geno2) {
        if (geno1 == geno2) {
            return geno1;
        }
        if (geno1 == -1) {
            return geno2;
        }
        if (geno2 == -1) {
            return geno1;
        }
        return -1;
    }

    @Override
    public byte[] mergeWithDepth(byte[] geno1depths, byte[] geno2depths) {
        if (geno1depths.length != geno2depths.length) {
            throw new IllegalStateException("Depth arrays must be same length");
        }
        byte[] result = new byte[geno1depths.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.addByteDepths(geno1depths[i], geno2depths[i]);
        }
        return result;
    }

    @Override
    public byte callBasedOnDepth(byte[] genoDepths) {
        return this.resolveHetGeno(AlleleDepthUtil.depthByteToInt(genoDepths));
    }

    private byte resolveHetGeno(int[] depths) {
        int max = 0;
        int maxAllele = 15;
        int nextMax = 0;
        int nextMaxAllele = 15;
        for (int a = 0; a < depths.length; ++a) {
            if (depths[a] > max) {
                nextMax = max;
                nextMaxAllele = maxAllele;
                max = depths[a];
                maxAllele = (byte)a;
                continue;
            }
            if (depths[a] <= nextMax) continue;
            nextMax = depths[a];
            nextMaxAllele = (byte)a;
        }
        int totCount = max + nextMax;
        if (totCount < 500) {
            if (nextMax < this.likelihoodRatioThreshAlleleCnt[totCount]) {
                return (byte)(maxAllele << 4 | maxAllele);
            }
            return (byte)(maxAllele << 4 | nextMaxAllele);
        }
        if ((double)(nextMax / totCount) < 0.1) {
            return (byte)(maxAllele << 4 | maxAllele);
        }
        return (byte)(maxAllele << 4 | nextMaxAllele);
    }
}

