/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.byte2d.Byte2DBuilder;
import net.maizegenetics.dna.snp.byte2d.FilterByte2D;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;

public class AlleleDepthBuilder {
    private final Map<SiteScore.SITE_SCORE_TYPE, Byte2DBuilder> myBuilders = new LinkedHashMap<SiteScore.SITE_SCORE_TYPE, Byte2DBuilder>();
    private final int myNumSites;
    private static final SiteScore.SITE_SCORE_TYPE[] ALLELE_DEPTH_TYPES = new SiteScore.SITE_SCORE_TYPE[]{SiteScore.SITE_SCORE_TYPE.DepthA, SiteScore.SITE_SCORE_TYPE.DepthC, SiteScore.SITE_SCORE_TYPE.DepthG, SiteScore.SITE_SCORE_TYPE.DepthT, SiteScore.SITE_SCORE_TYPE.DepthGap, SiteScore.SITE_SCORE_TYPE.DepthInsertion};

    private AlleleDepthBuilder(int numTaxa, int numSites, TaxaList taxaList) {
        for (int i = 0; i < ALLELE_DEPTH_TYPES.length; ++i) {
            this.myBuilders.put(ALLELE_DEPTH_TYPES[i], Byte2DBuilder.getInstance(numTaxa, numSites, ALLELE_DEPTH_TYPES[i], taxaList));
        }
        this.myNumSites = numSites;
    }

    private AlleleDepthBuilder(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        for (int i = 0; i < ALLELE_DEPTH_TYPES.length; ++i) {
            this.myBuilders.put(ALLELE_DEPTH_TYPES[i], Byte2DBuilder.getInstance(writer, numSites, ALLELE_DEPTH_TYPES[i], taxaList));
        }
        this.myNumSites = numSites;
    }

    public static AlleleDepthBuilder getInstance(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        return new AlleleDepthBuilder(writer, numTaxa, numSites, taxaList);
    }

    public static AlleleDepthBuilder getAlleleDepthInstance(int numTaxa, int numSites, TaxaList taxaList) {
        return new AlleleDepthBuilder(numTaxa, numSites, taxaList);
    }

    public static AlleleDepth getFilteredInstance(AlleleDepth base, FilterGenotypeTable filterGenotypeTable) {
        Collection<Byte2D> storage = base.byteStorage();
        Byte2D[] resultStorage = new FilterByte2D[storage.size()];
        int count = 0;
        for (Byte2D current : storage) {
            resultStorage[count] = Byte2DBuilder.getFilteredInstance(current, filterGenotypeTable);
        }
        return new AlleleDepth(resultStorage);
    }

    public AlleleDepthBuilder addTaxon(int taxon, int[] values, SiteScore.SITE_SCORE_TYPE type) {
        if (this.myNumSites != values.length) {
            throw new IllegalArgumentException("AlleleDepthBuilder: addTaxon: number of values: " + values.length + " doesn't equal number of sites: " + this.myNumSites);
        }
        byte[] result = AlleleDepthUtil.depthIntToByte(values);
        this.myBuilders.get((Object)type).addTaxon(taxon, result);
        return this;
    }

    public AlleleDepth build() {
        Byte2D[] input = new Byte2D[this.myBuilders.size()];
        int count = 0;
        for (Byte2DBuilder builder : this.myBuilders.values()) {
            input[count++] = builder.build();
        }
        this.myBuilders.clear();
        return new AlleleDepth(input);
    }
}

