/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Arrays;

public class AlleleDepthUtil {
    private static final double LOG_BASE = 1.0746;
    private static final double R_LOG_CONV = 1.0 / Math.log(1.0746);
    private static final double LOG_CONV = 1.0 / R_LOG_CONV;
    private static final int[] BYTE_TO_INT = new int[256];
    private static final int MAX_ACC_DEPTH = 182;
    private static final int MIN_ACC_BYTE = -55;
    private static final int OFFSET = 126;
    private static final double ADJ = 0.5;

    private AlleleDepthUtil() {
    }

    public static byte addByteDepths(byte depth1, byte depth2) {
        return AlleleDepthUtil.depthIntToByte(AlleleDepthUtil.depthByteToInt(depth1) + AlleleDepthUtil.depthByteToInt(depth2));
    }

    public static byte depthIntToByte(int depth) {
        int itd;
        if (depth <= 127) {
            itd = depth;
        } else if (depth <= 182) {
            itd = 127 - depth;
        } else {
            itd = (int)(-R_LOG_CONV * Math.log(depth - 126));
            if (itd < -128) {
                itd = -128;
            }
        }
        byte bdepth = (byte)itd;
        return bdepth;
    }

    public static byte[] depthIntToByte(int[] depth) {
        byte[] result = new byte[depth.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.depthIntToByte(depth[i]);
        }
        return result;
    }

    public static byte[][] depthIntToByte(int[][] depth) {
        byte[][] result = new byte[depth.length][depth[0].length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.depthIntToByte(depth[i]);
        }
        return result;
    }

    public static int depthByteToInt(byte depth) {
        return BYTE_TO_INT[depth & 0xFF];
    }

    public static int[] depthByteToInt(byte[] depth) {
        int[] result = new int[depth.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.depthByteToInt(depth[i]);
        }
        return result;
    }

    private static int decode(byte bdepth) {
        int depth = bdepth >= 0 ? bdepth : (bdepth >= -55 ? 127 - bdepth : 126 + (int)Math.exp(-LOG_CONV * ((double)bdepth - 0.5)));
        return depth;
    }

    static {
        Arrays.fill(BYTE_TO_INT, -1);
        for (int i = 0; i < 256; ++i) {
            AlleleDepthUtil.BYTE_TO_INT[i] = AlleleDepthUtil.decode((byte)i);
        }
    }
}

