/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.byte2d.Byte2DBuilder;
import net.maizegenetics.dna.snp.byte2d.FilterByte2D;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.dna.snp.score.SiteScoreUtil;
import net.maizegenetics.taxa.TaxaList;

public class AlleleProbabilityBuilder {
    private final Map<SiteScore.SITE_SCORE_TYPE, Byte2DBuilder> myBuilders = new LinkedHashMap<SiteScore.SITE_SCORE_TYPE, Byte2DBuilder>();
    private final int myNumSites;
    private static final SiteScore.SITE_SCORE_TYPE[] ALLELE_PROBABILITY_TYPES = new SiteScore.SITE_SCORE_TYPE[]{SiteScore.SITE_SCORE_TYPE.ProbA, SiteScore.SITE_SCORE_TYPE.ProbC, SiteScore.SITE_SCORE_TYPE.ProbG, SiteScore.SITE_SCORE_TYPE.ProbT, SiteScore.SITE_SCORE_TYPE.ProbGap, SiteScore.SITE_SCORE_TYPE.ProbInsertion};

    private AlleleProbabilityBuilder(int numTaxa, int numSites, TaxaList taxaList) {
        for (int i = 0; i < ALLELE_PROBABILITY_TYPES.length; ++i) {
            this.myBuilders.put(ALLELE_PROBABILITY_TYPES[i], Byte2DBuilder.getInstance(numTaxa, numSites, ALLELE_PROBABILITY_TYPES[i], taxaList));
        }
        this.myNumSites = numSites;
    }

    private AlleleProbabilityBuilder(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        for (int i = 0; i < ALLELE_PROBABILITY_TYPES.length; ++i) {
            this.myBuilders.put(ALLELE_PROBABILITY_TYPES[i], Byte2DBuilder.getInstance(writer, numSites, ALLELE_PROBABILITY_TYPES[i], taxaList));
        }
        this.myNumSites = numSites;
    }

    public static AlleleProbabilityBuilder getInstance(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        return new AlleleProbabilityBuilder(writer, numTaxa, numSites, taxaList);
    }

    public static AlleleProbabilityBuilder getAlleleProbabilityInstance(int numTaxa, int numSites, TaxaList taxaList) {
        return new AlleleProbabilityBuilder(numTaxa, numSites, taxaList);
    }

    public static AlleleProbability getFilteredInstance(AlleleProbability base, FilterGenotypeTable filterGenotypeTable) {
        Collection<Byte2D> storage = base.byteStorage();
        Byte2D[] resultStorage = new FilterByte2D[storage.size()];
        int count = 0;
        for (Byte2D current : storage) {
            resultStorage[count] = Byte2DBuilder.getFilteredInstance(current, filterGenotypeTable);
        }
        return new AlleleProbability(resultStorage);
    }

    public AlleleProbabilityBuilder addTaxon(int taxon, byte[] values, SiteScore.SITE_SCORE_TYPE type) {
        this.myBuilders.get((Object)type).addTaxon(taxon, values);
        return this;
    }

    public AlleleProbabilityBuilder addTaxon(int taxon, float[] values, SiteScore.SITE_SCORE_TYPE type) {
        if (this.myNumSites != values.length) {
            throw new IllegalArgumentException("AlleleProbabilityBuilder: addTaxon: number of values: " + values.length + " doesn't equal number of sites: " + this.myNumSites);
        }
        byte[] result = SiteScoreUtil.floatToBytePercentage(values);
        this.myBuilders.get((Object)type).addTaxon(taxon, result);
        return this;
    }

    public AlleleProbability build() {
        Byte2D[] input = new Byte2D[this.myBuilders.size()];
        int count = 0;
        for (Byte2DBuilder builder : this.myBuilders.values()) {
            input[count++] = builder.build();
        }
        this.myBuilders.clear();
        return new AlleleProbability(input);
    }
}

