/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import ch.systemsx.cisd.hdf5.IHDF5Writer;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.byte2d.Byte2DBuilder;
import net.maizegenetics.dna.snp.byte2d.FilterByte2D;
import net.maizegenetics.dna.snp.score.Dosage;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;

public class DosageBuilder {
    private Byte2DBuilder myBuilder;
    private final int myNumSites;

    private DosageBuilder(int numTaxa, int numSites, TaxaList taxaList) {
        this.myBuilder = Byte2DBuilder.getInstance(numTaxa, numSites, SiteScore.SITE_SCORE_TYPE.Dosage, taxaList);
        this.myNumSites = numSites;
    }

    private DosageBuilder(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        this.myBuilder = Byte2DBuilder.getInstance(writer, numSites, SiteScore.SITE_SCORE_TYPE.Dosage, taxaList);
        this.myNumSites = numSites;
    }

    public static DosageBuilder getInstance(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        return new DosageBuilder(writer, numTaxa, numSites, taxaList);
    }

    public static DosageBuilder getInstance(int numTaxa, int numSites, TaxaList taxaList) {
        return new DosageBuilder(numTaxa, numSites, taxaList);
    }

    public static Dosage getFilteredInstance(Dosage base, FilterGenotypeTable filterGenotypeTable) {
        FilterByte2D resultStorage = Byte2DBuilder.getFilteredInstance(base.byteStorage(SiteScore.SITE_SCORE_TYPE.Dosage), filterGenotypeTable);
        return new Dosage(resultStorage);
    }

    public DosageBuilder addTaxon(int taxon, byte[] values) {
        if (this.myNumSites != values.length) {
            throw new IllegalArgumentException("DosageBuilder: addTaxon: number of values: " + values.length + " doesn't equal number of sites: " + this.myNumSites);
        }
        this.myBuilder.addTaxon(taxon, values);
        return this;
    }

    public Dosage build() {
        Byte2D input = this.myBuilder.build();
        this.myBuilder = null;
        return new Dosage(input);
    }
}

