/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import ch.systemsx.cisd.hdf5.IHDF5Writer;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.byte2d.Byte2DBuilder;
import net.maizegenetics.dna.snp.byte2d.FilterByte2D;
import net.maizegenetics.dna.snp.score.ReferenceProbability;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.dna.snp.score.SiteScoreUtil;
import net.maizegenetics.taxa.TaxaList;

public class ReferenceProbabilityBuilder {
    private Byte2DBuilder myBuilder;
    private final int myNumSites;

    private ReferenceProbabilityBuilder(int numTaxa, int numSites, TaxaList taxaList) {
        this.myBuilder = Byte2DBuilder.getInstance(numTaxa, numSites, SiteScore.SITE_SCORE_TYPE.ReferenceProbablity, taxaList);
        this.myNumSites = numSites;
    }

    private ReferenceProbabilityBuilder(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        this.myBuilder = Byte2DBuilder.getInstance(writer, numSites, SiteScore.SITE_SCORE_TYPE.ReferenceProbablity, taxaList);
        this.myNumSites = numSites;
    }

    public static ReferenceProbabilityBuilder getInstance(IHDF5Writer writer, int numTaxa, int numSites, TaxaList taxaList) {
        return new ReferenceProbabilityBuilder(writer, numTaxa, numSites, taxaList);
    }

    public static ReferenceProbabilityBuilder getInstance(int numTaxa, int numSites, TaxaList taxaList) {
        return new ReferenceProbabilityBuilder(numTaxa, numSites, taxaList);
    }

    public static ReferenceProbability getFilteredInstance(ReferenceProbability base, FilterGenotypeTable filterGenotypeTable) {
        FilterByte2D resultStorage = Byte2DBuilder.getFilteredInstance(base.byteStorage(SiteScore.SITE_SCORE_TYPE.ReferenceProbablity), filterGenotypeTable);
        return new ReferenceProbability(resultStorage);
    }

    public ReferenceProbabilityBuilder addTaxon(int taxon, float[] values) {
        if (this.myNumSites != values.length) {
            throw new IllegalArgumentException("ImputeProbabilityBuilder: addTaxon: number of values: " + values.length + " doesn't equal number of sites: " + this.myNumSites);
        }
        this.myBuilder.addTaxon(taxon, SiteScoreUtil.floatToBytePercentage(values));
        return this;
    }

    public ReferenceProbability build() {
        Byte2D input = this.myBuilder.build();
        this.myBuilder = null;
        return new ReferenceProbability(input);
    }
}

