/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.maizegenetics.dna.snp.byte2d.Byte2D;

public abstract class SiteScore {
    private final Map<SITE_SCORE_TYPE, Byte2D> myValues = new HashMap<SITE_SCORE_TYPE, Byte2D>();
    protected final SITE_SCORE_TYPE myOnlyScoreType;
    private final int myNumTaxa;
    private final int myNumSites;

    SiteScore(Byte2D[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("SiteScore: init: no values provided.");
        }
        int numTaxa = values[0].numTaxa();
        int numSites = values[0].numSites();
        for (int i = 0; i < values.length; ++i) {
            if (numTaxa != values[i].numTaxa() || numSites != values[i].numSites()) {
                throw new IllegalArgumentException("SiteScore: init: number of taxa or sites don't match for all values.");
            }
            this.myValues.put(values[i].siteScoreType(), values[i]);
        }
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
        this.myOnlyScoreType = values.length == 1 ? values[0].siteScoreType() : null;
    }

    public Set<SITE_SCORE_TYPE> siteScoreTypes() {
        return this.myValues.keySet();
    }

    public int numTaxa() {
        return this.myNumTaxa;
    }

    public int numSites() {
        return this.myNumSites;
    }

    public int numAlleles() {
        return this.myValues.size();
    }

    protected Byte2D byteStorage(SITE_SCORE_TYPE type) {
        return this.myValues.get((Object)type);
    }

    Collection<Byte2D> byteStorage() {
        return this.myValues.values();
    }

    public static enum SITE_SCORE_TYPE {
        None,
        QualityScore,
        ReferenceProbablity,
        Dosage,
        DepthA,
        DepthC,
        DepthG,
        DepthT,
        DepthGap,
        DepthInsertion,
        ProbA,
        ProbC,
        ProbG,
        ProbT,
        ProbGap,
        ProbInsertion;

    }
}

