/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Arrays;

public class SiteScoreUtil {
    private static final float[] BYTE_TO_FLOAT = new float[256];

    private SiteScoreUtil() {
    }

    public static byte floatToBytePercentage(float value) {
        if ((double)value < 0.0 || (double)value > 1.0) {
            throw new IllegalArgumentException("SiteScoreUtil: floatToBytePercentage: value must be between 0.0 and 1.0");
        }
        return (byte)Math.round(255.0f * value);
    }

    public static byte[] floatToBytePercentage(float[] values) {
        byte[] result = new byte[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SiteScoreUtil.floatToBytePercentage(values[i]);
        }
        return result;
    }

    public static byte[][] floatToBytePercentage(float[][] values) {
        byte[][] result = new byte[values.length][values[0].length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SiteScoreUtil.floatToBytePercentage(values[i]);
        }
        return result;
    }

    public static float byteToFloatPercentage(byte value) {
        return BYTE_TO_FLOAT[value & 0xFF];
    }

    public static float[] byteToFloatPercentage(byte[] values) {
        float[] result = new float[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SiteScoreUtil.byteToFloatPercentage(values[i]);
        }
        return result;
    }

    private static float decode(int value) {
        return (float)value / 255.0f;
    }

    static {
        Arrays.fill(BYTE_TO_FLOAT, -1.0f);
        for (int i = 0; i < 256; ++i) {
            SiteScoreUtil.BYTE_TO_FLOAT[i] = SiteScoreUtil.decode(i);
        }
    }
}

