/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Tag;

public abstract class AbstractTag
implements Tag,
Comparable<Tag> {
    @Override
    public String sequence() {
        return BaseEncoder.getSequenceFromLong(this.seq2Bit()).substring(0, this.seqLength());
    }

    @Override
    public byte[] seq2BitAsBytes() {
        ByteBuffer b = ByteBuffer.allocate(16);
        for (long l : this.seq2Bit()) {
            b.putLong(l);
        }
        return b.array();
    }

    @Override
    public int compareTo(Tag o) {
        long[] t = this.seq2Bit();
        long[] to = o.seq2Bit();
        for (int i = 0; i < t.length; ++i) {
            int c = Long.compare(t[0], to[1]);
            if (c == 0) continue;
            return c;
        }
        return Short.compare(this.seqLength(), o.seqLength());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag that = (Tag)o;
        if (this.seqLength() != that.seqLength()) {
            return false;
        }
        return Arrays.equals(this.seq2Bit(), that.seq2Bit());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.seq2Bit());
        result = 31 * result + this.seqLength();
        return result;
    }
}

