/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.util.Arrays;
import net.maizegenetics.dna.tag.Tags;

public abstract class AbstractTags
implements Tags {
    protected int tagLengthInLong;
    protected long[][] tags;
    protected byte[] tagLength;

    @Override
    public boolean areTagsUnique() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] getTag(int index) {
        long[] theTag = new long[this.tagLengthInLong];
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            theTag[i] = this.tags[i][index];
        }
        return theTag;
    }

    @Override
    public int getTagCount() {
        return this.tags[0].length;
    }

    @Override
    public int getTagIndex(long[] read) {
        int first = 0;
        int len = this.tags[0].length - first;
        int comp = 0;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            comp = this.compareTags(middle, read);
            if (comp < 0) {
                first = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        if (first < this.tags[0].length && this.compareTags(first, read) == 0) {
            return first;
        }
        return -(first + 1);
    }

    public int getTagIndexFirst(long readFirst) {
        return Arrays.binarySearch(this.tags[0], readFirst);
    }

    public boolean areTagsEqual(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[i][index1] == this.tags[i][index2]) continue;
            return false;
        }
        return true;
    }

    public int compareTags(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[i][index1] < this.tags[i][index2]) {
                return -1;
            }
            if (this.tags[i][index1] <= this.tags[i][index2]) continue;
            return 1;
        }
        return 0;
    }

    public int compareTags(int index1, long[] t2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[i][index1] < t2[i]) {
                return -1;
            }
            if (this.tags[i][index1] <= t2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static int compareTags(long[] t1, long[] t2) {
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] < t2[i]) {
                return -1;
            }
            if (t1[i] <= t2[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int[] getTagIndexSet(long[] read) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTagLength(int index) {
        return this.tagLength[index];
    }

    public byte[] getTagLength() {
        return this.tagLength;
    }

    @Override
    public int getTagSizeInLong() {
        return this.tagLengthInLong;
    }

    @Override
    public String getNullTag() {
        char[] nullBases = new char[32 * this.tagLengthInLong];
        Arrays.fill(nullBases, 'A');
        return new String(nullBases);
    }

    public void swap(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            long temp = this.tags[i][index1];
            this.tags[i][index1] = this.tags[i][index2];
            this.tags[i][index2] = temp;
        }
        byte tl = this.tagLength[index1];
        this.tagLength[index1] = this.tagLength[index2];
        this.tagLength[index2] = tl;
    }

    public int compare(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[i][index1] < this.tags[i][index2]) {
                return -1;
            }
            if (this.tags[i][index1] <= this.tags[i][index2]) continue;
            return 1;
        }
        return 0;
    }

    public void sort() {
        System.out.println("Position index sort begin.");
        GenericSorting.quickSort((int)0, (int)this.getTagCount(), (IntComparator)this, (Swapper)this);
        System.out.println("Position index sort end.");
    }
}

