/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.maizegenetics.dna.tag.TaxaDistribution;
import org.xerial.snappy.Snappy;

abstract class AbstractTaxaDistribution
implements TaxaDistribution {
    AbstractTaxaDistribution() {
    }

    @Override
    public byte[] encodeTaxaDepth() {
        int i;
        int[][] tds = this.taxaWithDepths();
        ByteBuffer bb = ByteBuffer.allocate(8 + this.maxTaxa() / 64 + 2 * tds[0].length + this.totalDepth() / 64);
        bb.putInt(this.maxTaxa());
        bb.putInt(tds[0].length);
        bb.put(UnsignedBytes.checkedCast((long)tds[0][0]));
        for (i = 1; i < tds[0].length; ++i) {
            for (int space = tds[0][i] - tds[0][i - 1]; space >= 0; space -= 255) {
                bb.put(UnsignedBytes.saturatedCast((long)space));
            }
        }
        for (i = 0; i < tds[1].length; ++i) {
            for (int depth = tds[1][i]; depth >= 0; depth -= 255) {
                bb.put(UnsignedBytes.saturatedCast((long)depth));
            }
        }
        try {
            return Snappy.compress((byte[])Arrays.copyOf(bb.array(), bb.position()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Multiset<Integer> taxaDepthMap() {
        int[][] tds = this.taxaWithDepths();
        ImmutableMultiset.Builder taxaCnts = new ImmutableMultiset.Builder();
        for (int i = 0; i < tds[0].length; ++i) {
            taxaCnts.setCount((Object)tds[0][i], tds[1][i]);
        }
        return taxaCnts.build();
    }

    public boolean equals(Object o) {
        int[][] thatTDS;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof TaxaDistribution)) {
            return false;
        }
        TaxaDistribution that = (TaxaDistribution)o;
        if (this.maxTaxa() != that.maxTaxa()) {
            return false;
        }
        int[][] thisTDS = this.taxaWithDepths();
        if (!Arrays.equals(thisTDS[0], (thatTDS = that.taxaWithDepths())[0])) {
            return false;
        }
        return Arrays.equals(thisTDS[1], thatTDS[1]);
    }

    public String toString() {
        return "TaxaDist{totalDepth=" + this.totalDepth() + ", maxTaxa=" + this.maxTaxa() + ", " + this.taxaDepthMap().toString() + '}';
    }
}

