/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Reads;
import net.maizegenetics.util.BitUtil;
import net.maizegenetics.util.OpenBitSet;

public class ReadsByTaxa
implements Reads {
    public long[][] haplotype;
    public byte[][] hapDist;
    public int taxaNum = 0;
    public int haplotypeNum = 0;
    public String[] taxaNames;
    public int tagLengthInLong;
    public byte[] tagLength;

    public ReadsByTaxa() {
    }

    public ReadsByTaxa(String infile, boolean binary) {
        this.readDistFile(new File(infile), binary);
    }

    public ReadsByTaxa(String[] taxaNames, Reads theDistinctReads) {
        this.taxaNames = (String[])taxaNames.clone();
        this.taxaNum = taxaNames.length;
        this.haplotypeNum = theDistinctReads.getReadTotal();
        this.haplotype = new long[2][this.haplotypeNum];
        for (int i = 0; i < this.haplotypeNum; ++i) {
            long[] h = theDistinctReads.getRead(i);
            this.haplotype[0][i] = h[0];
            this.haplotype[1][i] = h[1];
        }
        this.hapDist = new byte[this.haplotypeNum][this.taxaNum];
    }

    public ReadsByTaxa(long[][] reads, byte[][] readDist, String[] namesForTaxa) {
        this.haplotype = reads;
        this.hapDist = readDist;
        this.taxaNames = namesForTaxa;
        this.taxaNum = namesForTaxa.length;
        this.haplotypeNum = reads[0].length;
    }

    public int getTaxaCount() {
        return this.taxaNames.length;
    }

    public String getTaxaName(int taxaIndex) {
        return this.taxaNames[taxaIndex];
    }

    public String[] getTaxaNames() {
        return this.taxaNames;
    }

    public int getIndexOfTaxaName(String taxon) {
        for (int i = 0; i < this.taxaNames.length; ++i) {
            if (!taxon.equals(this.taxaNames[i])) continue;
            return i;
        }
        return -1;
    }

    public int getReadCountForTaxa(int readIndex, int taxaIndex) {
        return this.hapDist[readIndex][taxaIndex];
    }

    public void setReadCountForTaxa(int readIndex, int taxaIndex, int value) {
        this.hapDist[readIndex][taxaIndex] = value > 127 ? 127 : (value < 0 ? 0 : (int)value);
    }

    public void addToReadCountForTaxa(int readIndex, int taxaIndex, int addValue) {
        this.setReadCountForTaxa(readIndex, taxaIndex, addValue + this.hapDist[readIndex][taxaIndex]);
    }

    public byte[] getReadCountsForTaxa(int readIndex) {
        return (byte[])this.hapDist[readIndex].clone();
    }

    public int getTaxaCountForRead(int readIndex) {
        int nTaxaWData = 0;
        for (byte cnt : this.hapDist[readIndex]) {
            if (cnt <= 0) continue;
            ++nTaxaWData;
        }
        return nTaxaWData;
    }

    @Override
    public long[] getRead(int i) {
        if (i >= this.haplotypeNum) {
            return null;
        }
        long[] result = new long[]{this.haplotype[0][i], this.haplotype[1][i]};
        return result;
    }

    @Override
    public int getReadIndex(long[] read) {
        int hit = Arrays.binarySearch(this.haplotype[0], read[0]);
        if (hit < 1) {
            return hit;
        }
        while (this.haplotype[0][hit - 1] == read[0]) {
            --hit;
        }
        while (this.haplotype[0][hit] == read[0] && hit < this.haplotype[0].length - 1 && this.haplotype[1][hit] < read[1]) {
            ++hit;
        }
        if (this.haplotype[0][hit] == read[0] && this.haplotype[1][hit] == read[1]) {
            return hit;
        }
        return -hit;
    }

    public void readTBTFile(File inFile) {
        System.out.println("Reading Haplotypes distribution from:" + inFile.toString());
        int hapsOutput = 0;
        try {
            DataInputStream rw = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4000000));
            this.haplotypeNum = rw.readInt();
            this.tagLengthInLong = rw.readInt();
            this.taxaNum = rw.readInt();
            this.taxaNames = new String[this.taxaNum];
            this.haplotype = new long[2][this.haplotypeNum];
            this.hapDist = new byte[this.haplotypeNum][this.taxaNum];
            this.tagLength = new byte[this.haplotypeNum];
            for (int t = 0; t < this.taxaNum; ++t) {
                this.taxaNames[t] = rw.readUTF();
            }
            int numberOfLongs = BitUtil.bits2words(this.taxaNum);
            long[] distInLong = new long[numberOfLongs];
            OpenBitSet obs = new OpenBitSet(distInLong, this.taxaNum);
            for (int i = 0; i < this.haplotypeNum; ++i) {
                int j;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.haplotype[j][i] = rw.readLong();
                }
                this.tagLength[i] = rw.readByte();
                for (j = 0; j < numberOfLongs; ++j) {
                    distInLong[j] = rw.readLong();
                }
                for (int t = 0; t < this.taxaNum; ++t) {
                    this.hapDist[i][t] = obs.fastGet(t) ? (byte)1 : 0;
                }
                ++hapsOutput;
            }
            rw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in writing output file e=" + e);
        }
    }

    void readDistFile(File inFile, boolean binary) {
        System.out.println("Reading Haplotypes distribution from:" + inFile.toString());
        int hapsOutput = 0;
        if (binary) {
            try {
                DataInputStream rw = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4000000));
                this.taxaNum = rw.readInt();
                this.haplotypeNum = rw.readInt();
                this.taxaNames = new String[this.taxaNum];
                this.haplotype = new long[2][this.haplotypeNum];
                this.hapDist = new byte[this.haplotypeNum][this.taxaNum];
                for (int t = 0; t < this.taxaNum; ++t) {
                    this.taxaNames[t] = rw.readUTF();
                }
                for (int i = 0; i < this.haplotypeNum; ++i) {
                    this.haplotype[0][i] = rw.readLong();
                    this.haplotype[1][i] = rw.readLong();
                    for (int t = 0; t < this.taxaNum; ++t) {
                        this.hapDist[i][t] = rw.readByte();
                    }
                    ++hapsOutput;
                }
                rw.close();
            }
            catch (Exception e) {
                System.out.println("Catch in writing output file e=" + e);
            }
        } else {
            long[] haplo = new long[2];
            try {
                BufferedReader br = new BufferedReader(new FileReader(inFile), 65536);
                ArrayList<String> inputLine = new ArrayList<String>(Arrays.asList(br.readLine().split("\t")));
                this.taxaNum = Integer.parseInt(inputLine.get(0));
                this.haplotypeNum = Integer.parseInt(inputLine.get(1));
                this.taxaNames = new String[this.taxaNum];
                this.haplotype = new long[2][this.haplotypeNum];
                this.hapDist = new byte[this.haplotypeNum][this.taxaNum];
                inputLine = new ArrayList<String>(Arrays.asList(br.readLine().split("\t")));
                for (int t = 0; t < this.taxaNum; ++t) {
                    this.taxaNames[t] = inputLine.get(t + 1);
                }
                for (int i = 0; i < this.haplotypeNum; ++i) {
                    inputLine = new ArrayList<String>(Arrays.asList(br.readLine().split("\t")));
                    haplo = BaseEncoder.getLongArrayFromSeq(inputLine.get(0));
                    this.haplotype[0][i] = haplo[0];
                    this.haplotype[1][i] = haplo[1];
                    for (int t = 0; t < this.taxaNum; ++t) {
                        this.hapDist[i][t] = Byte.valueOf(inputLine.get(t + 1));
                    }
                    ++hapsOutput;
                }
            }
            catch (Exception e) {
                System.out.println("Catch in writing output file e=" + e);
            }
        }
        System.out.println("Number of Taxa in file:" + this.taxaNum);
        System.out.println("Number of Haplotypes in file:" + hapsOutput);
    }

    public void writeDistFile(File outFile, boolean binary, int minCount) {
        int hapsOutput = 0;
        int outReads = this.readsWCountsGreaterThanMin(minCount);
        System.out.println(outReads + " reads will be output to " + outFile.getName());
        try {
            int t;
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 65536));
            if (binary) {
                fw.writeInt(this.taxaNum);
                fw.writeInt(outReads);
                for (t = 0; t < this.taxaNum; ++t) {
                    fw.writeUTF(this.taxaNames[t]);
                }
            } else {
                fw.writeBytes(this.taxaNum + "\t" + outReads + "\n");
                for (t = 0; t < this.taxaNum; ++t) {
                    fw.writeBytes("\t" + this.taxaNames[t]);
                }
                fw.writeBytes("\n");
            }
            for (int i = 0; i < this.haplotype[0].length; ++i) {
                int t2;
                if (this.getReadCount(i) < minCount) continue;
                if (!binary) {
                    fw.writeBytes(BaseEncoder.getSequenceFromLong(this.haplotype[0][i]) + BaseEncoder.getSequenceFromLong(this.haplotype[1][i]) + "\t");
                    for (t2 = 0; t2 < this.taxaNum; ++t2) {
                        fw.writeBytes(this.hapDist[i][t2] + "\t");
                    }
                    fw.writeBytes("\n");
                } else {
                    fw.writeLong(this.haplotype[0][i]);
                    fw.writeLong(this.haplotype[1][i]);
                    for (t2 = 0; t2 < this.taxaNum; ++t2) {
                        fw.writeByte(this.hapDist[i][t2]);
                    }
                }
                ++hapsOutput;
            }
            fw.flush();
            fw.close();
            System.out.println("Haplotypes written to:" + outFile.toString());
            System.out.println("Number of Haplotypes in file:" + hapsOutput);
        }
        catch (Exception e) {
            System.out.println("Catch in writing output file e=" + e);
        }
    }

    public void filterForListOfReads(File readsToKeepFile, File outFile, boolean binary) {
        int hapsOutput = 0;
        ArrayList<String> readsToKeepArrayList = new ArrayList<String>();
        int outReads = 0;
        try {
            int t;
            String readToKeep;
            BufferedReader br = new BufferedReader(new FileReader(readsToKeepFile), 65536);
            while ((readToKeep = br.readLine()) != null) {
                readsToKeepArrayList.add(readToKeep);
            }
            Object[] readsToKeep = readsToKeepArrayList.toArray(new String[readsToKeepArrayList.size()]);
            Arrays.sort(readsToKeep);
            for (int i = 0; i < this.haplotype[0].length; ++i) {
                String readStr = BaseEncoder.getSequenceFromLong(this.haplotype[0][i]) + BaseEncoder.getSequenceFromLong(this.haplotype[1][i]);
                if (Arrays.binarySearch(readsToKeep, readStr) <= -1) continue;
                ++outReads;
            }
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 65536));
            if (binary) {
                fw.writeInt(this.taxaNum);
                fw.writeInt(outReads);
                for (t = 0; t < this.taxaNum; ++t) {
                    fw.writeUTF(this.taxaNames[t]);
                }
            } else {
                fw.writeBytes(this.taxaNum + "\t" + outReads + "\n");
                for (t = 0; t < this.taxaNum; ++t) {
                    fw.writeBytes("\t" + this.taxaNames[t]);
                }
                fw.writeBytes("\n");
            }
            for (int i = 0; i < this.haplotype[0].length; ++i) {
                int t2;
                String readStr = BaseEncoder.getSequenceFromLong(this.haplotype[0][i]) + BaseEncoder.getSequenceFromLong(this.haplotype[1][i]);
                if (Arrays.binarySearch(readsToKeep, readStr) < 0) continue;
                if (!binary) {
                    fw.writeBytes(BaseEncoder.getSequenceFromLong(this.haplotype[0][i]) + BaseEncoder.getSequenceFromLong(this.haplotype[1][i]) + "\t");
                    for (t2 = 0; t2 < this.taxaNum; ++t2) {
                        fw.writeBytes(this.hapDist[i][t2] + "\t");
                    }
                    fw.writeBytes("\n");
                } else {
                    fw.writeLong(this.haplotype[0][i]);
                    fw.writeLong(this.haplotype[1][i]);
                    for (t2 = 0; t2 < this.taxaNum; ++t2) {
                        fw.writeByte(this.hapDist[i][t2]);
                    }
                }
                ++hapsOutput;
            }
            fw.flush();
            fw.close();
            System.out.println("Haplotypes written to:" + outFile.toString());
            System.out.println("Number of Haplotypes in file:" + hapsOutput);
        }
        catch (Exception e) {
            System.out.println("Catch in writing filtered output file e=" + e);
        }
    }

    protected void writeReadCountFile(File outFile, boolean binary, int minCount) {
        int hapsOutput = 0;
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 4000000));
            for (int i = 0; i < this.haplotype[0].length - 1; ++i) {
                if (this.getReadCount(i) < minCount) continue;
                if (!binary) {
                    fw.writeBytes(BaseEncoder.getSequenceFromLong(this.haplotype[0][i]) + BaseEncoder.getSequenceFromLong(this.haplotype[1][i]) + " " + this.getReadCount(i) + "\n");
                } else {
                    fw.writeLong(this.haplotype[0][i]);
                    fw.writeLong(this.haplotype[1][i]);
                    fw.writeInt(this.getReadCount(i));
                }
                ++hapsOutput;
            }
            fw.flush();
            fw.close();
            System.out.println("Reads written to:" + outFile.toString());
            System.out.println("Number of Reads in file:" + hapsOutput);
        }
        catch (Exception e) {
            System.out.println("Catch in writing output file e=" + e);
        }
    }

    private int readsWCountsGreaterThanMin(int minCount) {
        int sum = 0;
        for (int i = 0; i < this.getReadTotal(); ++i) {
            if (this.getReadCount(i) < minCount) continue;
            ++sum;
        }
        return sum;
    }

    @Override
    public int getReadCount(int index) {
        int sum = 0;
        for (byte cnt : this.hapDist[index]) {
            sum += cnt;
        }
        return sum;
    }

    @Override
    public int[] getReadIndexSet(long[] read) {
        int r = this.getReadIndex(read);
        if (r < 0) {
            return null;
        }
        int[] result = new int[]{r};
        return result;
    }

    @Override
    public boolean areReadsUnique() {
        return true;
    }

    @Override
    public int getReadTotal() {
        return this.haplotype[0].length;
    }
}

