/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

public class SAMUtils {
    public static String[][] getVariants(String inputLine) {
        String tagSequence = null;
        String cigarString = null;
        String mdField = null;
        String[] inputLineFields = inputLine.split("\t");
        int totalVariantCount = 0;
        for (int i = 0; i < inputLineFields.length; ++i) {
            if (inputLineFields[i].matches("MD.*")) {
                mdField = inputLineFields[i].substring(5);
            }
            if (i == 5) {
                tagSequence = inputLineFields[i];
            }
            if (i != 4) continue;
            cigarString = inputLineFields[i];
        }
        String[][] mdFieldVariants = SAMUtils.parseMDField(mdField, tagSequence);
        String[][] cigarStringVariants = SAMUtils.parseCIGAR(cigarString, tagSequence);
        if (mdFieldVariants != null) {
            totalVariantCount += mdFieldVariants[0].length;
        }
        if (cigarStringVariants != null) {
            totalVariantCount += cigarStringVariants[0].length;
        }
        String[][] totalVariants = new String[3][totalVariantCount];
        for (int i = 0; i < 3; ++i) {
            int recordedVariantCount = 0;
            while (recordedVariantCount < totalVariantCount) {
                int j;
                if (mdFieldVariants != null) {
                    for (j = 0; j < mdFieldVariants[0].length; ++j) {
                        totalVariants[i][j] = mdFieldVariants[i][j];
                        ++recordedVariantCount;
                    }
                }
                if (cigarStringVariants == null) continue;
                for (j = 0; j < cigarStringVariants[0].length; ++j) {
                    totalVariants[i][j + recordedVariantCount] = cigarStringVariants[i][j];
                    ++recordedVariantCount;
                }
            }
        }
        if (mdFieldVariants == null && cigarStringVariants == null) {
            return null;
        }
        return totalVariants;
    }

    public static int[] adjustCoordinates(String cigarString, int startCoordinate) {
        String currDigits = "";
        boolean firstLetter = true;
        int endCoordinate = startCoordinate - 1;
        for (int cigarStringPosition = 0; cigarStringPosition < cigarString.length(); ++cigarStringPosition) {
            String currentCharacter = cigarString.substring(cigarStringPosition, cigarStringPosition + 1);
            if (currentCharacter.matches("[0-9]")) {
                currDigits = currDigits.concat(currentCharacter);
                continue;
            }
            if (currentCharacter.matches("[MmDd]")) {
                endCoordinate += Integer.parseInt(currDigits);
                currDigits = "";
                firstLetter = false;
                continue;
            }
            if (currentCharacter.matches("[Ss]")) {
                if (firstLetter) {
                    int span = Integer.parseInt(currDigits);
                    endCoordinate = (startCoordinate -= span) + span - 1;
                    currDigits = "";
                    firstLetter = false;
                    continue;
                }
                endCoordinate += Integer.parseInt(currDigits);
                currDigits = "";
                continue;
            }
            if (!currentCharacter.matches("[Ii]")) continue;
            currDigits = "";
            firstLetter = false;
        }
        int[] coords = new int[]{startCoordinate, endCoordinate};
        return coords;
    }

    public static long endCoordinate(String cigarString, long startCoordinate) {
        String currDigits = "";
        long endCoordinate = startCoordinate - 1L;
        for (int cigarStringPosition = 0; cigarStringPosition < cigarString.length(); cigarStringPosition = (int)((byte)(cigarStringPosition + 1))) {
            String currentCharacter = cigarString.substring(cigarStringPosition, cigarStringPosition + 1);
            if (currentCharacter.matches("[0-9]")) {
                currDigits = currDigits.concat(currentCharacter);
                continue;
            }
            if (currentCharacter.matches("[MmDdSs]")) {
                endCoordinate += (long)Integer.parseInt(currDigits);
                currDigits = "";
                continue;
            }
            if (!currentCharacter.matches("[Ii]")) continue;
            currDigits = "";
        }
        return endCoordinate;
    }

    public static String[][] parseCIGAR(String cigarString, String tagSequence) {
        String matchingBaseCount = "";
        int tagSequencePosition = 0;
        String refHaplotype = "";
        String tagHaplotype = "";
        String[] variantPosition = new String[64];
        int variantCount = 0;
        try {
            for (int cigarStringPosition = 0; cigarStringPosition < cigarString.length(); cigarStringPosition = (int)((byte)(cigarStringPosition + 1))) {
                String currentCharacter = cigarString.substring(cigarStringPosition, cigarStringPosition + 1);
                if (currentCharacter.matches("[0-9]")) {
                    matchingBaseCount = matchingBaseCount.concat(currentCharacter);
                }
                if (!currentCharacter.matches("[A-Za-z]")) continue;
                tagSequencePosition += Integer.parseInt(matchingBaseCount);
                matchingBaseCount = "";
                if (!currentCharacter.matches("[I]")) continue;
                refHaplotype = refHaplotype.concat("+");
                tagHaplotype = tagHaplotype.concat("-");
                variantPosition[variantCount] = Integer.toString(tagSequencePosition);
                ++variantCount;
            }
        }
        catch (Exception e) {
            System.out.println("There was an exception in parseCIGAR: " + e);
        }
        String[][] returnValue = new String[3][variantCount];
        if (variantCount == 0) {
            returnValue = null;
        } else {
            for (int i = 0; i < variantCount; ++i) {
                returnValue[0][i] = refHaplotype.substring(i, i + 1);
                returnValue[1][i] = tagHaplotype.substring(i, i + 1);
                returnValue[2][i] = variantPosition[i];
            }
        }
        return returnValue;
    }

    public static String[][] parseMDField(String mdField, String tagSequence) {
        String matchingBaseCount = "";
        int tagSequencePosition = 0;
        boolean deletion = false;
        int deletionLength = 0;
        int variantCount = 0;
        String tagHaplotype = "";
        String refHaplotype = "";
        String[] variantPosition = new String[tagSequence.length()];
        try {
            for (int mdFieldPosition = 0; mdFieldPosition < mdField.length(); mdFieldPosition = (int)((byte)(mdFieldPosition + 1))) {
                if (mdField.substring(mdFieldPosition, mdFieldPosition + 1).equals("^")) {
                    deletion = true;
                }
                if (mdField.substring(mdFieldPosition, mdFieldPosition + 1).matches("[AGCTagct]")) {
                    tagSequencePosition = (byte)(tagSequencePosition + Integer.parseInt(matchingBaseCount));
                    matchingBaseCount = "";
                    if (deletion) {
                        deletionLength = (byte)(deletionLength + 1);
                    } else {
                        refHaplotype = refHaplotype.concat(mdField.substring(mdFieldPosition, mdFieldPosition + 1));
                        tagHaplotype = tagHaplotype.concat(tagSequence.substring(tagSequencePosition, tagSequencePosition + 1));
                        variantPosition[variantCount] = Integer.toString(tagSequencePosition);
                        ++variantCount;
                        tagSequencePosition = (byte)(tagSequencePosition + 1);
                    }
                }
                if (!mdField.substring(mdFieldPosition, mdFieldPosition + 1).matches("[0-9]")) continue;
                if (deletion) {
                    refHaplotype = refHaplotype.concat("-");
                    tagHaplotype = tagHaplotype.concat("+");
                    variantPosition[variantCount] = Integer.toString(tagSequencePosition);
                    ++variantCount;
                    deletionLength = 0;
                    deletion = false;
                }
                matchingBaseCount = matchingBaseCount.concat(mdField.substring(mdFieldPosition, mdFieldPosition + 1));
            }
        }
        catch (Exception e) {
            System.out.println("There was an exception in parseMDField: " + e);
        }
        String[][] returnValue = new String[3][variantCount];
        if (variantCount == 0) {
            returnValue = null;
        } else {
            for (int i = 0; i < variantCount; ++i) {
                returnValue[0][i] = refHaplotype.substring(i, i + 1);
                returnValue[1][i] = tagHaplotype.substring(i, i + 1);
                returnValue[2][i] = variantPosition[i];
            }
        }
        return returnValue;
    }
}

