/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.nio.ByteBuffer;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.Tag2Long;
import net.maizegenetics.dna.tag.Tag3Long;
import net.maizegenetics.dna.tag.TagVarLong;

public class TagBuilder {
    private TagBuilder() {
    }

    public static Tag instance(long[] seq2Bit, short length) {
        if (seq2Bit.length == 2) {
            return new Tag2Long(seq2Bit, (byte)length);
        }
        if (seq2Bit.length == 3) {
            return new Tag3Long(seq2Bit, (byte)length);
        }
        if (seq2Bit.length > 3) {
            return new TagVarLong(seq2Bit, length);
        }
        return null;
    }

    public static Tag instance(byte[] seq2BitInBytes, short length) {
        int seqBitLength = seq2BitInBytes.length / 8;
        long[] seq2Bit = new long[seqBitLength];
        ByteBuffer bb = ByteBuffer.wrap(seq2BitInBytes);
        for (int i = 0; i < seq2Bit.length; ++i) {
            seq2Bit[i] = bb.getLong();
        }
        if (seq2Bit.length == 2) {
            return new Tag2Long(seq2Bit, (byte)length);
        }
        if (seq2Bit.length == 3) {
            return new Tag3Long(seq2Bit, (byte)length);
        }
        if (seq2Bit.length > 3) {
            return new TagVarLong(seq2Bit, length);
        }
        return null;
    }

    public static Tag instance(String sequence) {
        long[] seq2Bit = BaseEncoder.getLongArrayFromSeq(sequence);
        int length = sequence.length();
        if (seq2Bit.length == 2) {
            return new Tag2Long(seq2Bit, (byte)length);
        }
        if (seq2Bit.length == 3) {
            return new Tag3Long(seq2Bit, (byte)length);
        }
        return new TagVarLong(seq2Bit, (short)length);
    }
}

