/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractTags;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class TagCounts
extends AbstractTags {
    int[] readCount;

    public TagCounts() {
        this.tagLengthInLong = 2;
        this.initMatrices(10);
    }

    public TagCounts(int tagLengthInLong, int maxSize) {
        this.tagLengthInLong = tagLengthInLong;
        this.initMatrices(maxSize);
    }

    public TagCounts(String inFile, TagsByTaxa.FilePacking binary) {
        this.readDistFile(inFile, binary);
    }

    public void readDistFile(String infile, TagsByTaxa.FilePacking binary) {
        File in = new File(infile);
        System.out.println("Reading Haplotypes distribution from:" + in.toString());
        switch (binary) {
            case Text: {
                this.readTextTagCountFile(in);
                break;
            }
            default: {
                this.readBinaryTagCountFile(in);
            }
        }
    }

    protected void initMatrices(int tagNum) {
        this.tags = new long[this.tagLengthInLong][tagNum];
        this.tagLength = new byte[tagNum];
        this.readCount = new int[tagNum];
    }

    public void toFASTA(String outfile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfile), 65536);
            for (int i = 0; i < this.getTagCount(); ++i) {
                bw.write(">" + String.valueOf(i));
                bw.newLine();
                bw.write(BaseEncoder.getSequenceFromLong(this.getTag(i)).substring(0, this.getTagLength(i)));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toFASTQ(String infile, String outfile) {
        int tagsRead = 0;
        long[] currSequence = new long[this.tagLengthInLong];
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile), 65536));
            DataInputStream rw = new DataInputStream(new BufferedInputStream(new FileInputStream(infile), 4000000));
            int tagNum = rw.readInt();
            this.tagLengthInLong = rw.readInt();
            while (rw.available() != 0) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    currSequence[j] = rw.readLong();
                }
                byte currLength = rw.readByte();
                int currCount = rw.readInt();
                ++tagsRead;
                String textSequence = BaseEncoder.getSequenceFromLong(currSequence);
                textSequence = textSequence.substring(0, currLength);
                fw.writeBytes("@length=" + currLength + "count=" + currCount + "\n" + textSequence + "\n" + "+\n" + "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n");
            }
            rw.close();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in reading TagCount file e=" + e);
        }
        System.out.println("Number of Tags in file:" + tagsRead);
    }

    void readTextTagCountFile(File inFile) {
        int tagsRead = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(inFile), 65536);
            String[] inputLine = br.readLine().trim().split("\\s");
            int tagNum = Integer.parseInt(inputLine[0]);
            this.tagLengthInLong = Integer.parseInt(inputLine[1]);
            this.initMatrices(tagNum);
            for (int i = 0; i < tagNum; ++i) {
                inputLine = br.readLine().split("\\s");
                long[] tt = BaseEncoder.getLongArrayFromSeq(inputLine[0]);
                for (int j = 0; j < tt.length; ++j) {
                    this.tags[j][i] = tt[j];
                }
                this.tagLength[i] = Byte.valueOf(inputLine[1]);
                this.readCount[i] = Integer.valueOf(inputLine[2]);
                ++tagsRead;
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("Catch in reading TagCount file e=" + e);
            e.printStackTrace();
        }
        System.out.println("Number of Tags in file:" + tagsRead);
        System.out.println("Number of Tags in memory:" + this.tags[0].length);
    }

    public void readBinaryTagCountFile(File inFile) {
        int tagsRead = 0;
        try {
            DataInputStream rw = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4000000));
            int tagNum = rw.readInt();
            this.tagLengthInLong = rw.readInt();
            this.initMatrices(tagNum);
            for (int i = 0; i < tagNum; ++i) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][i] = rw.readLong();
                }
                this.tagLength[i] = rw.readByte();
                this.readCount[i] = rw.readInt();
                ++tagsRead;
            }
            rw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in reading TagCount file e=" + e);
        }
        System.out.println("Number of Tags in file:" + tagsRead);
    }

    public void writeTagCountFile(String outFile, TagsByTaxa.FilePacking binary, int minCount) {
        int hapsOutput = 0;
        int[] outTagsAndReadsKept = this.tagsWCountsGreaterThanMin(minCount);
        System.out.println(outTagsAndReadsKept[0] + " tags will be output to " + outFile);
        System.out.println("These " + outTagsAndReadsKept[0] + " tags were covered by " + outTagsAndReadsKept[1] + " matching reads");
        switch (binary) {
            case Text: {
                hapsOutput = this.writeTextTagCountFile(outFile, outTagsAndReadsKept[0], minCount);
                break;
            }
            default: {
                hapsOutput = this.writeByteTagCountFile(outFile, binary, outTagsAndReadsKept[0], minCount);
            }
        }
        System.out.println("Tags written to:" + outFile.toString());
        System.out.println("Number of Tags in file:" + hapsOutput);
    }

    private int writeTextTagCountFile(String outFile, int outReads, int minCount) {
        int hapsOutput = 0;
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 65536));
            fw.writeBytes(outReads + "\t" + this.tagLengthInLong + "\n");
            for (int i = 0; i < this.tags[0].length; ++i) {
                if (this.getReadCount(i) < minCount) continue;
                fw.writeBytes(BaseEncoder.getSequenceFromLong(this.getTag(i)) + "\t");
                fw.writeBytes(this.getTagLength(i) + "\t");
                fw.writeBytes(this.getReadCount(i) + "\t");
                fw.writeBytes("\n");
                ++hapsOutput;
            }
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
        return hapsOutput;
    }

    private int writeByteTagCountFile(String outFile, TagsByTaxa.FilePacking binary, int outReads, int minCount) {
        int hapsOutput = 0;
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 65536));
            fw.writeInt(outReads);
            fw.writeInt(this.tagLengthInLong);
            for (int i = 0; i < this.tags[0].length; ++i) {
                if (this.getReadCount(i) < minCount) continue;
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    fw.writeLong(this.tags[j][i]);
                }
                fw.writeByte(this.tagLength[i]);
                fw.writeInt(this.getReadCount(i));
                ++hapsOutput;
            }
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
        return hapsOutput;
    }

    public int getReadCount(int index) {
        if (index >= this.readCount.length) {
            return -1;
        }
        return this.readCount[index];
    }

    protected int[] tagsWCountsGreaterThanMin(int minCount) {
        int nPassingTags = 0;
        int nKeptReads = 0;
        for (int i = 0; i < this.getTagCount(); ++i) {
            int readCount = this.getReadCount(i);
            if (readCount < minCount) continue;
            ++nPassingTags;
            nKeptReads += readCount;
        }
        int[] retArr = new int[]{nPassingTags, nKeptReads};
        return retArr;
    }

    public void setTag(long[] sequence, byte length, int count, int index) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            this.tags[i][index] = sequence[i];
            this.tagLength[index] = length;
            this.readCount[index] = count;
        }
    }

    @Override
    public void sort() {
        System.out.println("Position index sort begin.");
        GenericSorting.quickSort((int)0, (int)this.getSize(), (IntComparator)this, (Swapper)this);
        System.out.println("Position index sort end.");
    }

    protected void printRows(int numRows) {
        for (int i = 0; i < numRows; ++i) {
            System.out.println(BaseEncoder.getSequenceFromLong(this.tags[0][i]) + BaseEncoder.getSequenceFromLong(this.tags[1][i]) + " " + this.getTagLength(i) + " " + this.getReadCount(i));
        }
    }

    protected void collapseCounts() {
        this.sort();
        int collapsedRows = 0;
        for (int i = 1; i < this.getSize(); ++i) {
            if (this.tags[0][i - 1] != this.tags[0][i] || this.tags[1][i - 1] != this.tags[1][i]) continue;
            int n = i;
            this.readCount[n] = this.readCount[n] + this.readCount[i - 1];
            this.readCount[i - 1] = 0;
            ++collapsedRows;
        }
        System.out.println("Tag rows collapsed after sorting:" + collapsedRows);
    }

    public int getSize() {
        return this.tags[0].length;
    }

    public int getTotalCount() {
        int totalCount = 0;
        for (int i = 0; i < this.readCount.length; ++i) {
            totalCount += this.readCount[i];
        }
        return totalCount;
    }

    @Override
    public void swap(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            long temp = this.tags[i][index1];
            this.tags[i][index1] = this.tags[i][index2];
            this.tags[i][index2] = temp;
        }
        byte tl = this.tagLength[index1];
        this.tagLength[index1] = this.tagLength[index2];
        this.tagLength[index2] = tl;
        int t3 = this.readCount[index1];
        this.readCount[index1] = this.readCount[index2];
        this.readCount[index2] = t3;
    }

    @Override
    public int compare(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[i][index1] < this.tags[i][index2]) {
                return -1;
            }
            if (this.tags[i][index1] <= this.tags[i][index2]) continue;
            return 1;
        }
        if (this.readCount[index1] < this.readCount[index2]) {
            return -1;
        }
        if (this.readCount[index1] > this.readCount[index2]) {
            return 1;
        }
        return 0;
    }

    public byte compare(long[] sequence1, long[] sequence2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (sequence1[i] < sequence2[i]) {
                return -1;
            }
            if (sequence1[i] <= sequence2[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int[] getTagIndexSet(long[] read) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean areTagsUnique() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTagSizeInLong() {
        return this.tagLengthInLong;
    }

    @Override
    public int getTagLength(int index) {
        return this.tagLength[index];
    }

    @Override
    public int getTagCount() {
        return this.tags[0].length;
    }

    public long[][] getTags() {
        return this.tags;
    }
}

