/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.util.BitUtil;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.OpenBitSet;

public class TagsByTaxaUtils {
    private static TBTRecord currRecord = new TBTRecord();
    private static int numTags;
    private static int tagLengthInLong;
    private static int numTaxa;
    private static int longsInBitset;
    private static String[] taxaNames;
    private static DataOutputStream outputStream;
    private static DataInputStream inputStream;
    private static BufferedReader reader;
    private static BufferedWriter writer;
    private static String inputFileName;
    private static String outputFileName;
    private static TagsByTaxa.FilePacking inputFormat;
    private static TagsByTaxa.FilePacking outputFormat;

    public static void main(String[] args) {
        TagsByTaxaUtils.printCoverage("/media/jvh053111/all_sorghum_20120326/tbt/70MU0AAXX_s_1.tbt.byte", TagsByTaxa.FilePacking.Byte, false);
    }

    public static String bitsetToString(OpenBitSet bitset) {
        String result = "";
        int i = 0;
        while ((long)i < bitset.size()) {
            result = bitset.fastGet(i) ? result + "1" : result + "0";
            ++i;
        }
        return result;
    }

    public static String[] bitsetToStringArray(OpenBitSet bitset) {
        String[] result = new String[(int)bitset.size()];
        int i = 0;
        while ((long)i < bitset.size()) {
            result[i] = bitset.fastGet(i) ? "1" : "0";
            ++i;
        }
        return result;
    }

    public static void streamTextToBinary(String inputFileName, String outputFileName) {
        try {
            System.out.println("Reading " + inputFileName + ".");
            BufferedReader br = new BufferedReader(new FileReader(inputFileName), 65536);
            int hapsOutput = 0;
            String[] inputLine = br.readLine().split("\t");
            int tagNum = Integer.parseInt(inputLine[0]);
            int tagLengthInLong = Integer.parseInt(inputLine[1]);
            int taxaNum = Integer.parseInt(inputLine[2]);
            String[] taxaNames = new String[taxaNum];
            OpenBitSet obs = new OpenBitSet(taxaNum);
            inputLine = br.readLine().trim().split("\t");
            for (int t = 0; t < taxaNum; ++t) {
                taxaNames[t] = inputLine[t];
            }
            System.out.println("Writing " + outputFileName + ".");
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFileName), 65536));
            fw.writeInt(tagNum);
            fw.writeInt(tagLengthInLong);
            fw.writeInt(taxaNum);
            for (int t = 0; t < taxaNum; ++t) {
                fw.writeUTF(taxaNames[t]);
            }
            for (int i = 0; i < tagNum; ++i) {
                inputLine = br.readLine().split("\t");
                long[] tagSequence = BaseEncoder.getLongArrayFromSeq(inputLine[0]);
                byte tagLength = Byte.parseByte(inputLine[1]);
                for (int t = 0; t < taxaNum; ++t) {
                    obs.fastClear(t);
                    if (!inputLine[t + 2].matches("1")) continue;
                    obs.set(t);
                }
                for (int j = 0; j < tagLengthInLong; ++j) {
                    fw.writeLong(tagSequence[j]);
                }
                fw.writeByte(tagLength);
                long[] obsInLong = obs.getBits();
                for (int t = 0; t < obsInLong.length; ++t) {
                    fw.writeLong(obsInLong[t]);
                }
                if (++hapsOutput % 10000 != 0) continue;
                System.out.println("Wrote " + hapsOutput + " tags.");
            }
            fw.close();
            br.close();
            System.out.println("Number of Taxa in file:" + taxaNum);
            System.out.println("Number of Haplotypes in file:" + hapsOutput);
        }
        catch (Exception e) {
            System.out.println("Catch in writing output file e=" + e);
            e.printStackTrace();
        }
    }

    private static void writeRecord(TBTRecord currRecord) {
        switch (outputFormat) {
            case Text: {
                String outputLine = null;
                if (inputFormat.equals((Object)TagsByTaxa.FilePacking.Byte)) {
                    outputLine = BaseEncoder.getSequenceFromLong(currRecord.sequence) + "\t" + Byte.toString(currRecord.tagLength) + "\t";
                    for (int i = 0; i < currRecord.byteDistribution.length; ++i) {
                        outputLine = outputLine + currRecord.byteDistribution[i] + "\t";
                    }
                    outputLine = outputLine + "\n";
                }
                try {
                    writer.write(outputLine);
                }
                catch (Exception e) {
                    System.out.println("Caught Exception while writing TBT text record: " + e);
                }
                break;
            }
            case Byte: {
                try {
                    long[] e = currRecord.sequence;
                    int n = e.length;
                    for (int i = 0; i < n; ++i) {
                        Long i2 = e[i];
                        outputStream.writeLong(i2);
                    }
                    outputStream.write(currRecord.tagLength);
                    outputStream.write(currRecord.byteDistribution);
                    break;
                }
                catch (Exception e) {
                    System.out.println("Caught exception while writing binary TBT record: " + e);
                }
            }
        }
    }

    private static void readRecord() {
        switch (inputFormat) {
            case Byte: {
                TagsByTaxaUtils.currRecord.byteDistribution = new byte[numTaxa];
                try {
                    int i;
                    for (i = 0; i < tagLengthInLong; ++i) {
                        TagsByTaxaUtils.currRecord.sequence[i] = inputStream.readLong();
                    }
                    TagsByTaxaUtils.currRecord.tagLength = inputStream.readByte();
                    for (i = 0; i < numTaxa; ++i) {
                        TagsByTaxaUtils.currRecord.byteDistribution[i] = inputStream.readByte();
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("Caught exception while reading byte-encoded TBT record: " + e);
                    break;
                }
            }
            case Text: {
                OpenBitSet bitset = new OpenBitSet(numTaxa);
                try {
                    String[] currLine = reader.readLine().split("\\s");
                    TagsByTaxaUtils.currRecord.sequence = BaseEncoder.getLongArrayFromSeq(currLine[0]);
                    TagsByTaxaUtils.currRecord.tagLength = Byte.parseByte(currLine[1]);
                    for (int i = 0; i < numTaxa; ++i) {
                        if (!currLine[i + 2].equals("1")) continue;
                        bitset.fastSet(i);
                    }
                    TagsByTaxaUtils.currRecord.bitDistribution = bitset.getBits();
                }
                catch (Exception e) {
                    System.out.println("Caught exception while reading text TBT record: " + e);
                }
                break;
            }
            default: {
                System.out.println("Couldn't read TBT record: file format is unknown.");
            }
        }
    }

    private static void readHeader() {
        switch (inputFormat) {
            case Byte: {
                try {
                    numTags = inputStream.readInt();
                    tagLengthInLong = inputStream.readInt();
                    numTaxa = inputStream.readInt();
                    taxaNames = new String[numTaxa];
                    for (int i = 0; i < numTaxa; ++i) {
                        TagsByTaxaUtils.taxaNames[i] = inputStream.readUTF();
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("Caught exception while reading binary TBT file header: " + e);
                    System.exit(0);
                }
            }
            case Text: {
                try {
                    String[] headerLine = reader.readLine().split("\\s");
                    numTags = Integer.parseInt(headerLine[0]);
                    tagLengthInLong = Integer.parseInt(headerLine[2]);
                    numTaxa = Integer.parseInt(headerLine[2]);
                    taxaNames = reader.readLine().split("\\s");
                    break;
                }
                catch (Exception e) {
                    System.out.println("Caught exception while reading TBT text file header: " + e);
                }
            }
            default: {
                System.out.println("Couldn't read header: the file format isn't recognized.");
                System.exit(0);
            }
        }
        longsInBitset = BitUtil.bits2words(numTaxa);
        TagsByTaxaUtils.currRecord.sequence = new long[tagLengthInLong];
        TagsByTaxaUtils.currRecord.bitDistribution = new long[longsInBitset];
    }

    private static void writeHeader() {
        switch (outputFormat) {
            case Byte: {
                try {
                    outputStream.writeInt(numTags);
                    outputStream.writeInt(tagLengthInLong);
                    outputStream.writeInt(numTaxa);
                    for (String name : taxaNames) {
                        outputStream.writeUTF(name);
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("Caught exception while writing binary TBT file header: " + e);
                    break;
                }
            }
            case Text: {
                try {
                    writer.write(numTags + "\t" + tagLengthInLong + "\t" + numTaxa + "\n");
                    for (String name : taxaNames) {
                        writer.write(name + "\t");
                    }
                    writer.write("\n");
                }
                catch (Exception e) {
                    System.out.println("Caught exception while writing text TBT file header: " + e);
                }
                break;
            }
            default: {
                System.out.println("Couldn't print header: the file format isn't recognized.");
                System.exit(0);
            }
        }
    }

    public static void slice(String inputFileName, String[] sequences) {
        throw new UnsupportedOperationException("This function isn't finished yet.\n");
    }

    public static void filterByTOPM(String inputFileName, TagsOnPhysicalMap topm) {
        outputFileName = inputFileName.replaceFirst("tbt", "tbt.filteredbytopm");
        TagsByTaxaUtils.openIOStreams(inputFileName, TagsByTaxa.FilePacking.Byte, outputFileName, TagsByTaxa.FilePacking.Byte);
        TagsByTaxaUtils.readHeader();
        int filteredLines = 0;
        int unfilteredLines = numTags;
        for (int i = 0; i < unfilteredLines; ++i) {
            TagsByTaxaUtils.readRecord();
            if (topm.getTagIndex(TagsByTaxaUtils.currRecord.sequence) > 0) {
                ++filteredLines;
            }
            if (unfilteredLines % 1000000 != 0) continue;
            System.out.println("Counted " + (float)filteredLines / 1000000.0f + " million records.");
        }
        TagsByTaxaUtils.closeIOStreams();
        TagsByTaxaUtils.openIOStreams(inputFileName, TagsByTaxa.FilePacking.Byte, outputFileName, TagsByTaxa.FilePacking.Byte);
        TagsByTaxaUtils.readHeader();
        numTags = filteredLines;
        int writtenLines = 0;
        TagsByTaxaUtils.writeHeader();
        for (int i = 0; i < unfilteredLines; ++i) {
            TagsByTaxaUtils.readRecord();
            if (topm.getTagIndex(TagsByTaxaUtils.currRecord.sequence) <= 0) continue;
            TagsByTaxaUtils.writeRecord(currRecord);
            if (++writtenLines % 1000000 != 0) continue;
            System.out.println("Wrote " + (float)writtenLines / 1000000.0f + " million records.");
        }
        System.out.println("Wrote " + writtenLines + " records.");
        TagsByTaxaUtils.closeIOStreams();
    }

    public static void replaceInNames(String regex, String replacement, String inputFileName, TagsByTaxa.FilePacking format, String outputFileName) {
        int i;
        TagsByTaxaUtils.openIOStreams(inputFileName, format, outputFileName, format);
        TagsByTaxaUtils.readHeader();
        for (i = 0; i < taxaNames.length; ++i) {
            System.out.println("Replacing " + taxaNames[i] + " with ");
            TagsByTaxaUtils.taxaNames[i] = taxaNames[i].replaceAll(regex, replacement);
            System.out.println(taxaNames[i] + ".");
        }
        TagsByTaxaUtils.writeHeader();
        for (i = 0; i < numTags; ++i) {
            TagsByTaxaUtils.readRecord();
            TagsByTaxaUtils.writeRecord(currRecord);
        }
    }

    public static void positions(String inputFileName, TagsByTaxa.FilePacking format, TagsOnPhysicalMap topm, String[] taxa) {
        outputFileName = inputFileName.replaceFirst("tbt.bin", "positions.tbt.bin");
        int linesPrinted = 0;
        ArrayList<Integer> columnsTracked = new ArrayList<Integer>();
        TagsByTaxaUtils.openIOStreams(inputFileName, format, outputFileName, format);
        TagsByTaxaUtils.readHeader();
        for (int i = 0; i < taxaNames.length; ++i) {
            for (String taxon : taxa) {
                if (!taxaNames[i].equals(taxon)) continue;
                columnsTracked.add(i);
            }
        }
        try {
            outputStream.writeBytes("Printing positions of following taxa:\n");
            for (Integer integer : columnsTracked) {
                String taxon = taxaNames[integer];
                outputStream.writeBytes(taxon + "\n");
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception while printing positions of taxa: " + e);
        }
        for (int i = 0; i < numTags; ++i) {
            TagsByTaxaUtils.readRecord();
            OpenBitSet currBitset = new OpenBitSet(TagsByTaxaUtils.currRecord.bitDistribution, longsInBitset);
            for (Integer integer : columnsTracked) {
                if (!currBitset.fastGet(integer)) continue;
                int topmIndex = topm.getTagIndex(TagsByTaxaUtils.currRecord.sequence);
                try {
                    outputStream.writeBytes(topm.printRow(topmIndex) + "\n");
                }
                catch (Exception e) {
                    System.out.println("Caught exception while printing positions of taxa: " + e);
                }
            }
            ++linesPrinted;
        }
        TagsByTaxaUtils.closeIOStreams();
    }

    private static void openIOStreams(String inputFileName, TagsByTaxa.FilePacking inputFormat, String outputFileName, TagsByTaxa.FilePacking outputFormat) {
        TagsByTaxaUtils.inputFormat = inputFormat;
        TagsByTaxaUtils.outputFormat = outputFormat;
        TagsByTaxaUtils.inputFileName = inputFileName;
        if (outputFileName == null) {
            outputFileName = inputFileName + ".output";
        } else {
            TagsByTaxaUtils.outputFileName = outputFileName;
        }
        try {
            switch (inputFormat) {
                case Byte: {
                    inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFileName), 65536));
                    break;
                }
                case Text: {
                    reader = new BufferedReader(new FileReader(inputFileName), 65536);
                    break;
                }
                default: {
                    System.out.println("Couldn't determine input file format.");
                    System.exit(0);
                }
            }
            switch (outputFormat) {
                case Byte: {
                    outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFileName), 65536));
                    break;
                }
                case Text: {
                    writer = new BufferedWriter(new FileWriter(outputFileName), 65536);
                    break;
                }
                default: {
                    System.out.println("Couldn't determine input file format.");
                    System.exit(0);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception while opening input & output files in TagsByTaxaUtils: " + e);
        }
    }

    private static void closeIOStreams() {
        try {
            switch (inputFormat) {
                case Byte: {
                    inputStream.close();
                    break;
                }
                case Text: {
                    reader.close();
                }
            }
            switch (outputFormat) {
                case Byte: {
                    outputStream.close();
                    break;
                }
                case Text: {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception while opening input & output files in TagsByTaxaUtils: " + e);
        }
    }

    public static HashMap<String, Integer> sumCounts(String inputFileName, TagsByTaxa.FilePacking format, boolean progressIndication) {
        int i;
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        outputFileName = inputFileName + ".tmp";
        TagsByTaxaUtils.openIOStreams(inputFileName, format, outputFileName, format);
        TagsByTaxaUtils.readHeader();
        int[] tagCount = new int[numTaxa];
        for (i = 0; i < numTags; ++i) {
            if (progressIndication && i % 100000 == 1) {
                System.out.println("Finished reading " + i + "tags...");
            }
            TagsByTaxaUtils.readRecord();
            if (format == TagsByTaxa.FilePacking.Byte) {
                for (int j = 0; j < numTaxa; ++j) {
                    int n = j;
                    tagCount[n] = tagCount[n] + TagsByTaxaUtils.currRecord.byteDistribution[j];
                }
                continue;
            }
            System.out.println("TBT file format not recognized.");
        }
        for (i = 0; i < numTaxa; ++i) {
            results.put(taxaNames[i], tagCount[i]);
        }
        return results;
    }

    public static void printTotalTagsAndTaxa(String directoryName, TagsByTaxa.FilePacking format) {
        String[] filenames;
        int totalTags = 0;
        int totalTaxa = 0;
        for (String filename : filenames = DirectoryCrawler.listFileNames(".*.tbt.bin|.*.tbt.txt|.*.tbt.byte", directoryName)) {
            TagsByTaxaUtils.openIOStreams(filename, format, null, format);
            TagsByTaxaUtils.readHeader();
            totalTags += numTags;
            totalTaxa += numTaxa;
            System.out.println("Reading " + inputFileName + ".  Counted " + numTags + " tags over " + numTaxa + " taxa.");
        }
        System.out.println("Total: " + totalTags + " non-unique tags over " + totalTaxa + " non-unique taxa.");
    }

    public static void printSumCounts(String inputFileName, TagsByTaxa.FilePacking format, boolean progressIndication) {
        HashMap<String, Integer> results = TagsByTaxaUtils.sumCounts(inputFileName, format, progressIndication);
        for (String index : results.keySet()) {
            System.out.println(index + "\t" + results.get(index));
        }
    }

    public static void printSumCountsOfAll(String directoryName, TagsByTaxa.FilePacking format) {
        for (String filename : DirectoryCrawler.listFileNames(".*.tbt.bin|.*.tbt.txt|.*.tbt.byte", directoryName)) {
            System.out.println(filename + ":");
            TagsByTaxaUtils.printSumCounts(filename, format, false);
        }
    }

    public static void sparsity(String inputFileName, TagsByTaxa.FilePacking format) {
        long zeroValues = 0L;
        long nonZeroValues = 0L;
        TagsByTaxaUtils.openIOStreams(inputFileName, format, inputFileName + ".tmp", format);
        TagsByTaxaUtils.readHeader();
        System.out.println("Measuring TBT matrix sparsity.");
        for (int i = 0; i < numTags; ++i) {
            TagsByTaxaUtils.readRecord();
            if (i % 1000000 == 0) {
                System.out.println("Read " + i / 1000000 + " million tags.");
            }
            if (format.equals((Object)TagsByTaxa.FilePacking.Byte)) {
                for (byte value : TagsByTaxaUtils.currRecord.byteDistribution) {
                    if (value == 0) {
                        ++zeroValues;
                        continue;
                    }
                    ++nonZeroValues;
                }
                continue;
            }
            System.out.println("This format isn't recognized by the sparsity function.");
            System.exit(0);
        }
        long totalValues = zeroValues + nonZeroValues;
        System.out.println("\nTags: " + numTags + "\n" + "Taxa: " + numTaxa + "\n" + "Size: " + numTags * numTaxa + " values.\n" + zeroValues + " zero values.\n" + nonZeroValues + " non-zero values.\n" + "Sparsity is " + (float)zeroValues / (float)totalValues + ".");
    }

    public static void printCoverage(String inputFileName, TagsByTaxa.FilePacking format, boolean itemized) {
        int max;
        TagsByTaxaUtils.openIOStreams(inputFileName, format, inputFileName + ".tmp", format);
        TagsByTaxaUtils.readHeader();
        int[] taxonCoverage = new int[10];
        int[] tagCoverage = new int[10];
        int[] tagsCovered = new int[taxaNames.length];
        int[] tagsUncovered = new int[taxaNames.length];
        if (itemized) {
            System.out.println("Total " + taxaNames.length + " taxa." + '\n' + "sequence" + '\t' + "taxon coverage");
        }
        for (int i = 0; i < numTags; ++i) {
            int bin;
            TagsByTaxaUtils.readRecord();
            float coverage = currRecord.taxonCoverage();
            int n = bin = (int)(coverage * 10.0f);
            taxonCoverage[n] = taxonCoverage[n] + 1;
            if (itemized) {
                System.out.println(BaseEncoder.getSequenceFromLong(TagsByTaxaUtils.currRecord.sequence) + '\t' + coverage);
            }
            byte[] currCounts = currRecord.taxonDist();
            for (int j = 0; j < tagsCovered.length; ++j) {
                if (currCounts[j] > 0) {
                    int n2 = j;
                    tagsCovered[n2] = tagsCovered[n2] + 1;
                    continue;
                }
                int n3 = j;
                tagsUncovered[n3] = tagsUncovered[n3] + 1;
            }
        }
        float total = 0.0f;
        if (!itemized) {
            System.out.println("Taxon Coverage:");
        }
        for (int count : taxonCoverage) {
            total += (float)count;
        }
        if (!itemized) {
            System.out.println("percent of taxa covered\ttags at coverage level\tfraction of total tags");
            for (int bin = 0; bin < 10; ++bin) {
                int min = bin * 10;
                max = (bin + 1) * 10;
                float pct = (float)taxonCoverage[bin] / total;
                System.out.println(min + "-" + max + "%:" + '\t' + taxonCoverage[bin] + '\t' + pct);
            }
        }
        if (itemized) {
            System.out.println("Total " + numTags + " tags." + '\n' + "taxon" + '\t' + "tag coverage" + '\t' + "fraction of total");
        }
        for (int i = 0; i < taxaNames.length; ++i) {
            int bin;
            float coverage = (float)tagsCovered[i] / (float)numTags;
            int n = bin = (int)(coverage * 10.0f);
            tagCoverage[n] = tagCoverage[n] + 1;
            if (!itemized) continue;
            System.out.println(taxaNames[i] + '\t' + tagsCovered[i] + '\t' + coverage);
        }
        if (!itemized) {
            System.out.println("Tag Coverage:");
        }
        if (!itemized) {
            System.out.println("percent of tags covered\ttaxa at coverage level\tfraction of total taxa");
            for (int bin = 0; bin < 10; ++bin) {
                int min = bin * 10;
                max = (bin + 1) * 10;
                float pct = (float)tagCoverage[bin] / (float)taxaNames.length;
                System.out.println(min + "-" + max + "%:" + '\t' + tagCoverage[bin] + '\t' + pct);
            }
        }
    }

    public static TagsByTaxa.FilePacking format(String filename) {
        TagsByTaxa.FilePacking format = null;
        String fileExtension = filename.substring(filename.lastIndexOf("."));
        if (fileExtension.equals(".byte")) {
            format = TagsByTaxa.FilePacking.Byte;
        }
        if (format == null) {
            System.out.println("Couldn't identify format of input file: " + filename);
            System.exit(0);
        }
        return format;
    }

    public static void mergeTaxaByName(String inputFileName, String outputFileName, TagsByTaxa.FilePacking format, boolean caseSensitive) {
        int j;
        int i;
        TagsByTaxaUtils.openIOStreams(inputFileName, format, outputFileName, format);
        TagsByTaxaUtils.readHeader();
        TreeSet<String> uniqueNames = new TreeSet<String>();
        for (int i2 = 0; i2 < taxaNames.length; ++i2) {
            TagsByTaxaUtils.taxaNames[i2] = caseSensitive ? taxaNames[i2].substring(0, taxaNames[i2].indexOf(":")) : taxaNames[i2].substring(0, taxaNames[i2].indexOf(":")).toUpperCase();
            uniqueNames.add(taxaNames[i2]);
        }
        Object[] nameArray = uniqueNames.toArray(new String[uniqueNames.size()]);
        Arrays.sort(nameArray);
        int[] newColumn = new int[taxaNames.length];
        for (i = 0; i < taxaNames.length; ++i) {
            for (j = 0; j < nameArray.length; ++j) {
                if (!taxaNames[i].equals(nameArray[j])) continue;
                newColumn[i] = j;
            }
        }
        taxaNames = (String[])Arrays.copyOf(nameArray, nameArray.length);
        numTaxa = taxaNames.length;
        TagsByTaxaUtils.writeHeader();
        for (i = 0; i < numTags; ++i) {
            TagsByTaxaUtils.readRecord();
            OpenBitSet oldBitset = new OpenBitSet(TagsByTaxaUtils.currRecord.bitDistribution, longsInBitset);
            OpenBitSet newBitset = new OpenBitSet(uniqueNames.size());
            j = 0;
            while ((long)j < oldBitset.capacity()) {
                if (oldBitset.fastGet(j)) {
                    newBitset.fastSet(newColumn[j]);
                }
                ++j;
            }
            TagsByTaxaUtils.currRecord.bitDistribution = newBitset.getBits();
            TagsByTaxaUtils.writeRecord(currRecord);
            TagsByTaxaUtils.currRecord.bitDistribution = new long[longsInBitset];
        }
        TagsByTaxaUtils.closeIOStreams();
    }

    public static void streamBinaryToText(String inputFileName, int maxRecords) {
        TagsByTaxaUtils.openIOStreams(inputFileName, TagsByTaxaUtils.format(inputFileName), inputFileName.replaceFirst("\\.bin$|\\.byte$", ".txt"), TagsByTaxa.FilePacking.Text);
        TagsByTaxaUtils.readHeader();
        TagsByTaxaUtils.writeHeader();
        int writtenLines = 0;
        for (int i = 0; i < numTags && i < maxRecords; ++i) {
            TagsByTaxaUtils.readRecord();
            TagsByTaxaUtils.writeRecord(currRecord);
            ++writtenLines;
        }
        System.out.println("Wrote " + writtenLines + " records.");
        TagsByTaxaUtils.closeIOStreams();
    }

    private static class TBTRecord {
        long[] sequence;
        byte tagLength;
        long[] bitDistribution;
        byte[] byteDistribution;

        public byte[] taxonDist() {
            if (inputFormat == TagsByTaxa.FilePacking.Byte) {
                return this.byteDistribution;
            }
            System.out.println("Taxon distribution of the current tag is blank.");
            return null;
        }

        public float taxonCoverage() {
            long zeroValues = 0L;
            long nonZeroValues = 0L;
            for (byte value : this.taxonDist()) {
                if (value > 0) {
                    ++zeroValues;
                    continue;
                }
                ++nonZeroValues;
            }
            return (float)nonZeroValues / ((float)zeroValues + (float)nonZeroValues);
        }
    }
}

