/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.maizegenetics.dna.tag.TaxaDistExpandable;
import net.maizegenetics.dna.tag.TaxaDistFixed;
import net.maizegenetics.dna.tag.TaxaDistSingleTaxon;
import net.maizegenetics.dna.tag.TaxaDistribution;
import org.xerial.snappy.Snappy;

public class TaxaDistBuilder {
    private TaxaDistBuilder() {
    }

    public static TaxaDistribution create(int maxTaxa, int taxaWithTag) {
        return new TaxaDistSingleTaxon(maxTaxa, taxaWithTag);
    }

    public static TaxaDistribution create(int maxTaxa) {
        return new TaxaDistExpandable(maxTaxa);
    }

    public static TaxaDistribution create(int maxTaxa, int[] taxaWithTags, int[] depthOfTags) {
        return new TaxaDistFixed(maxTaxa, taxaWithTags, depthOfTags);
    }

    public static TaxaDistribution create(byte[] encodedTaxaDistribution) {
        int[][] decodedTD = TaxaDistBuilder.getDepthMatrixForEncodedDepths(encodedTaxaDistribution);
        return new TaxaDistFixed(decodedTD[2][0], decodedTD[0], decodedTD[1]);
    }

    public static TaxaDistribution create(TaxaDistribution srcTaxaDist) {
        TaxaDistExpandable dstTD = new TaxaDistExpandable(srcTaxaDist.maxTaxa());
        int[] depths = srcTaxaDist.depths();
        for (int taxaIndex = 0; taxaIndex < depths.length; ++taxaIndex) {
            for (int j = 0; j < depths[taxaIndex]; ++j) {
                dstTD.increment(taxaIndex);
            }
        }
        return dstTD;
    }

    public static TaxaDistribution create(int maxTaxa, int[] encodeTaxaDepths) {
        TaxaDistExpandable dstTD = new TaxaDistExpandable(maxTaxa);
        for (int taxaDepth : encodeTaxaDepths) {
            int taxa = taxaDepth >>> 8;
            int depth = UnsignedBytes.toInt((byte)((byte)taxaDepth));
            for (int i = 0; i < depth; ++i) {
                dstTD.increment(taxa);
            }
        }
        return dstTD;
    }

    private static int[][] getDepthMatrixForEncodedDepths(byte[] input) {
        try {
            int inc;
            int i;
            int maxValueInInt = UnsignedBytes.toInt((byte)-1);
            ByteBuffer bb = ByteBuffer.wrap(Snappy.uncompress((byte[])input));
            int maxTaxa = bb.getInt();
            int taxaWithDepth = bb.getInt();
            int[][] result = new int[][]{new int[taxaWithDepth], new int[taxaWithDepth], {maxTaxa}};
            for (i = 0; i < taxaWithDepth; ++i) {
                int space = i > 0 ? result[0][i - 1] : 0;
                inc = UnsignedBytes.toInt((byte)bb.get());
                while (inc == maxValueInInt) {
                    space += inc;
                    inc = UnsignedBytes.toInt((byte)bb.get());
                }
                result[0][i] = space += inc;
            }
            for (i = 0; i < taxaWithDepth; ++i) {
                int depth = 0;
                inc = UnsignedBytes.toInt((byte)bb.get());
                while (inc == maxValueInInt) {
                    depth += inc;
                    inc = UnsignedBytes.toInt((byte)bb.get());
                }
                result[1][i] = depth += inc;
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

