/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import com.google.common.primitives.Shorts;
import net.maizegenetics.dna.tag.AbstractTaxaDistribution;
import net.maizegenetics.dna.tag.TaxaDistribution;

class TaxaDistExpandable
extends AbstractTaxaDistribution {
    private short[][] taxaWithTag;
    private int[] size;
    private int totalDepth;
    private final int maxTaxa;

    public TaxaDistExpandable(int maxTaxa) {
        this.maxTaxa = maxTaxa;
        this.initializeArrays();
    }

    private void initializeArrays() {
        int shortSets = 1 + (this.maxTaxa >>> 16);
        this.taxaWithTag = new short[shortSets][];
        for (int i = 0; i < shortSets; ++i) {
            this.taxaWithTag[i] = new short[5];
        }
        this.size = new int[shortSets];
    }

    @Override
    public synchronized TaxaDistribution increment(int taxaNum) {
        int shortSet = taxaNum >>> 16;
        this.taxaWithTag[shortSet] = Shorts.ensureCapacity((short[])this.taxaWithTag[shortSet], (int)(this.size[shortSet] + 1), (int)this.size[shortSet]);
        this.taxaWithTag[shortSet][this.size[shortSet]] = (short)taxaNum;
        int n = shortSet;
        this.size[n] = this.size[n] + 1;
        ++this.totalDepth;
        return this;
    }

    @Override
    public int[] depths() {
        int[] depths = new int[this.maxTaxa];
        for (int i = 0; i < this.taxaWithTag.length; ++i) {
            int base = i * 65536;
            for (int j = 0; j < this.size[i]; ++j) {
                int n = this.unSignShort(this.taxaWithTag[i][j]) + base;
                depths[n] = depths[n] + 1;
            }
        }
        return depths;
    }

    @Override
    public int[][] taxaWithDepths() {
        int[] depths = this.depths();
        int countNoZero = 0;
        for (int depth : depths) {
            if (depth <= 0) continue;
            ++countNoZero;
        }
        int[][] taxaDepth = new int[2][countNoZero];
        countNoZero = 0;
        for (int i = 0; i < depths.length; ++i) {
            if (depths[i] <= 0) continue;
            taxaDepth[0][countNoZero] = i;
            taxaDepth[1][countNoZero] = depths[i];
            ++countNoZero;
        }
        return taxaDepth;
    }

    @Override
    public int totalDepth() {
        return this.totalDepth;
    }

    @Override
    public int maxTaxa() {
        return this.maxTaxa;
    }

    @Override
    public int memorySize() {
        int size = 40;
        for (int i = 0; i < this.taxaWithTag.length; ++i) {
            size += 16 + this.taxaWithTag[i].length * 2;
        }
        return size;
    }

    private int unSignShort(short v) {
        if (v < 0) {
            return -v + 1;
        }
        return v;
    }
}

