/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Arrays;
import net.maizegenetics.dna.tag.AbstractTaxaDistribution;
import net.maizegenetics.dna.tag.TaxaDistribution;
import org.xerial.snappy.Snappy;

class TaxaDistFixed
extends AbstractTaxaDistribution {
    private byte[] compTaxaSize;
    private int numTaxaWithTags;
    private int totalDepth;
    private final int maxTaxa;

    public TaxaDistFixed(int maxTaxa, int[] taxaWithTags, int[] depthOfTags) {
        this.maxTaxa = maxTaxa;
        this.numTaxaWithTags = taxaWithTags.length;
        this.totalDepth = 0;
        for (int depthOfTag : depthOfTags) {
            this.totalDepth += depthOfTag;
        }
        try {
            this.compTaxaSize = Snappy.compress((int[])Ints.concat((int[][])new int[][]{taxaWithTags, depthOfTags}));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized TaxaDistribution increment(int taxaNum) {
        throw new UnsupportedOperationException("TaxaDistFixed cannot be increment.  Change to expandable first first.");
    }

    @Override
    public int[] depths() {
        try {
            int[] depths = new int[this.maxTaxa];
            int[] taxaSize = Snappy.uncompressIntArray((byte[])this.compTaxaSize);
            for (int i = 0; i < this.numTaxaWithTags; ++i) {
                depths[taxaSize[i]] = taxaSize[i + this.numTaxaWithTags];
            }
            return depths;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int[][] taxaWithDepths() {
        try {
            int[][] taxaDepth = new int[2][this.numTaxaWithTags];
            int[] taxaSize = Snappy.uncompressIntArray((byte[])this.compTaxaSize);
            taxaDepth[0] = Arrays.copyOf(taxaSize, this.numTaxaWithTags);
            taxaDepth[1] = Arrays.copyOfRange(taxaSize, this.numTaxaWithTags, taxaSize.length);
            return taxaDepth;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int totalDepth() {
        return this.totalDepth;
    }

    @Override
    public int maxTaxa() {
        return this.maxTaxa;
    }

    @Override
    public int memorySize() {
        return 28 + this.compTaxaSize.length;
    }

    @Override
    public String toString() {
        return "TaxaDist{totalDepth=" + this.totalDepth + ", maxTaxa=" + this.maxTaxa + ", " + this.taxaDepthMap().toString() + '}';
    }
}

