/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.Matrix;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import net.maizegenetics.matrixalgebra.Matrix.BlasDoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.ColtDoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.EJMLDoubleMatrix;
import org.apache.log4j.Logger;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.ops.CommonOps;

public class DoubleMatrixFactory {
    private static Logger myLogger = Logger.getLogger(DoubleMatrixFactory.class);
    private FactoryType myType;
    public static DoubleMatrixFactory DEFAULT;

    public DoubleMatrixFactory(FactoryType type) {
        this.myType = type;
    }

    public static void setDefault(FactoryType type) {
        DEFAULT = new DoubleMatrixFactory(type);
    }

    public FactoryType getType() {
        return this.myType;
    }

    public DoubleMatrix make(int row, int col) {
        if (this.myType == FactoryType.ejml) {
            return new EJMLDoubleMatrix(row, col);
        }
        if (this.myType == FactoryType.colt) {
            return new ColtDoubleMatrix(row, col);
        }
        if (this.myType == FactoryType.blas) {
            return new BlasDoubleMatrix(row, col);
        }
        if (this.myType == FactoryType.jblas) {
            return null;
        }
        return null;
    }

    public DoubleMatrix make(int row, int col, double[] values) {
        return this.make(row, col, values, false);
    }

    public DoubleMatrix make(int row, int col, double[] values, boolean columnMajor) {
        if (columnMajor) {
            if (this.myType == FactoryType.ejml) {
                EJMLDoubleMatrix temp = new EJMLDoubleMatrix(col, row, values);
                return temp.transpose();
            }
            if (this.myType == FactoryType.colt) {
                return new ColtDoubleMatrix(row, col, values);
            }
            if (this.myType == FactoryType.blas) {
                return BlasDoubleMatrix.getInstance(row, col, values, true);
            }
        } else {
            if (this.myType == FactoryType.ejml) {
                return new EJMLDoubleMatrix(row, col, values);
            }
            if (this.myType == FactoryType.colt) {
                ColtDoubleMatrix temp = new ColtDoubleMatrix(col, row, values);
                return temp.transpose();
            }
            if (this.myType == FactoryType.blas) {
                return BlasDoubleMatrix.getInstance(row, col, values, false);
            }
        }
        if (this.myType == FactoryType.jblas) {
            return null;
        }
        return null;
    }

    public DoubleMatrix make(double[][] values) {
        if (this.myType == FactoryType.ejml) {
            return new EJMLDoubleMatrix(values);
        }
        if (this.myType == FactoryType.colt) {
            return new ColtDoubleMatrix(values);
        }
        if (this.myType == FactoryType.blas) {
            return new BlasDoubleMatrix(values);
        }
        if (this.myType == FactoryType.jblas) {
            return null;
        }
        return null;
    }

    public DoubleMatrix make(int row, int col, double val) {
        if (this.myType == FactoryType.ejml) {
            return new EJMLDoubleMatrix(row, col, val);
        }
        if (this.myType == FactoryType.colt) {
            return new ColtDoubleMatrix(row, col, val);
        }
        if (this.myType == FactoryType.blas) {
            return BlasDoubleMatrix.getInstance(row, col, val);
        }
        if (this.myType == FactoryType.jblas) {
            return null;
        }
        return null;
    }

    public DoubleMatrix identity(int n) {
        if (this.myType == FactoryType.ejml) {
            return new EJMLDoubleMatrix(n);
        }
        if (this.myType == FactoryType.colt) {
            return new ColtDoubleMatrix(n);
        }
        if (this.myType == FactoryType.blas) {
            return BlasDoubleMatrix.getIdentityMatrix(n);
        }
        if (this.myType == FactoryType.jblas) {
            return null;
        }
        return null;
    }

    public DoubleMatrix diagonal(double[] diag) {
        if (this.myType == FactoryType.ejml) {
            return new EJMLDoubleMatrix(diag);
        }
        if (this.myType == FactoryType.colt) {
            return new ColtDoubleMatrix(diag);
        }
        if (this.myType == FactoryType.blas) {
            return BlasDoubleMatrix.getDiagonalMatrix(diag);
        }
        if (this.myType == FactoryType.jblas) {
            return null;
        }
        return null;
    }

    public DoubleMatrix compose(DoubleMatrix[][] components) {
        if (this.myType == FactoryType.ejml) {
            int i;
            int totalRows = 0;
            int totalCols = 0;
            int nRows = components.length;
            int nCols = components[0].length;
            for (i = 0; i < nRows; ++i) {
                totalRows += components[i][0].numberOfRows();
            }
            for (i = 0; i < nCols; ++i) {
                totalCols += components[0][i].numberOfColumns();
            }
            DenseMatrix64F result = new DenseMatrix64F(totalRows, totalCols);
            int startRow = 0;
            for (int r = 0; r < nRows; ++r) {
                int startCol = 0;
                for (int c = 0; c < nCols; ++c) {
                    DenseMatrix64F dm = ((EJMLDoubleMatrix)components[r][c]).myMatrix;
                    CommonOps.insert((Matrix64F)dm, (Matrix64F)result, (int)startRow, (int)startCol);
                    startCol += dm.numCols;
                }
                startRow += components[r][0].numberOfRows();
            }
            return new EJMLDoubleMatrix(result);
        }
        if (this.myType == FactoryType.colt) {
            int nRows = components.length;
            int nCols = components[0].length;
            DoubleMatrix2D[][] coltComponents = new DoubleMatrix2D[nRows][nCols];
            for (int r = 0; r < nRows; ++r) {
                for (int c = 0; c < nCols; ++c) {
                    coltComponents[r][c] = ((ColtDoubleMatrix)components[r][c]).myMatrix;
                }
            }
            return new ColtDoubleMatrix(DoubleFactory2D.dense.compose(coltComponents));
        }
        if (this.myType == FactoryType.blas) {
            return BlasDoubleMatrix.compose(components);
        }
        if (this.myType == FactoryType.jblas) {
            return null;
        }
        return null;
    }

    static {
        try {
            System.loadLibrary("TasselBlas");
            DEFAULT = new DoubleMatrixFactory(FactoryType.blas);
            myLogger.info((Object)"Using BLAS/LAPACK for DoubleMatrix operations");
        }
        catch (UnsatisfiedLinkError err) {
            DEFAULT = new DoubleMatrixFactory(FactoryType.ejml);
            myLogger.info((Object)"TasselBlas library for system-specific BLAS/LAPACK not found. Using system-independent EJML for DoubleMatrix operations.");
        }
        catch (SecurityException se) {
            DEFAULT = new DoubleMatrixFactory(FactoryType.ejml);
            myLogger.info((Object)"No permission to load blasDoubleMatrix library. Using EJML for DoubleMatrix operations.");
        }
    }

    public static enum FactoryType {
        ejml,
        jblas,
        colt,
        blas;

    }
}

