/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import net.maizegenetics.matrixalgebra.Matrix.ColtDoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;

public class ColtSingularValueDecomposition
implements SingularValueDecomposition {
    cern.colt.matrix.linalg.SingularValueDecomposition myDecomposition;

    public ColtSingularValueDecomposition(DoubleMatrix dm) {
        int rows = dm.numberOfRows();
        int cols = dm.numberOfColumns();
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(rows, cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                matrix.setQuick(r, c, dm.get(r, c));
            }
        }
        this.myDecomposition = new cern.colt.matrix.linalg.SingularValueDecomposition(matrix);
    }

    public ColtSingularValueDecomposition(DoubleMatrix2D matrix) {
        this.myDecomposition = new cern.colt.matrix.linalg.SingularValueDecomposition(matrix);
    }

    @Override
    public DoubleMatrix getU(boolean transpose) {
        if (transpose) {
            return new ColtDoubleMatrix(this.myDecomposition.getU().viewDice().copy());
        }
        return new ColtDoubleMatrix(this.myDecomposition.getU());
    }

    @Override
    public DoubleMatrix getV(boolean transpose) {
        if (transpose) {
            return new ColtDoubleMatrix(this.myDecomposition.getV().viewDice().copy());
        }
        return new ColtDoubleMatrix(this.myDecomposition.getV());
    }

    @Override
    public DoubleMatrix getS() {
        return new ColtDoubleMatrix(this.myDecomposition.getS());
    }

    @Override
    public double[] getSingularValues() {
        return this.myDecomposition.getSingularValues();
    }

    @Override
    public int getRank() {
        return this.myDecomposition.rank();
    }
}

