/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class CorePhenotype
implements Phenotype {
    protected final List<PhenotypeAttribute> myAttributeList;
    protected final List<Phenotype.ATTRIBUTE_TYPE> myAttributeTypeList;
    protected final Multimap<Phenotype.ATTRIBUTE_TYPE, Integer> myAttributeTypeMap;
    protected final HashMap<String, Integer> myAttributeNameMap;
    protected final int numberOfAttributes;
    protected final int numberOfObservations;
    protected final String name;
    protected final TaxaAttribute myTaxaAttribute;

    CorePhenotype(List<PhenotypeAttribute> attributes, List<Phenotype.ATTRIBUTE_TYPE> types, String name) {
        this.myAttributeList = new ArrayList<PhenotypeAttribute>(attributes);
        this.myAttributeTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(types);
        this.name = name;
        this.myAttributeTypeMap = HashMultimap.create();
        int typeCount = 0;
        for (Phenotype.ATTRIBUTE_TYPE type : types) {
            this.myAttributeTypeMap.put((Object)type, (Object)typeCount++);
        }
        this.numberOfAttributes = attributes.size();
        this.numberOfObservations = this.myAttributeList.get(0).size();
        Collection taxaIndices = this.myAttributeTypeMap.get((Object)Phenotype.ATTRIBUTE_TYPE.taxa);
        if (taxaIndices.size() == 1) {
            Integer Ndx = (Integer)taxaIndices.iterator().next();
            this.myTaxaAttribute = (TaxaAttribute)this.myAttributeList.get(Ndx);
        } else {
            this.myTaxaAttribute = null;
        }
        this.myAttributeNameMap = new HashMap();
        int attrCount = 0;
        for (PhenotypeAttribute attr : attributes) {
            this.myAttributeNameMap.put(attr.name(), attrCount++);
        }
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] names = new String[this.numberOfAttributes];
        int ptr = 0;
        for (PhenotypeAttribute attr : this.myAttributeList) {
            names[ptr++] = attr.name();
        }
        return names;
    }

    @Override
    public String getTableTitle() {
        return this.name;
    }

    @Override
    public int getColumnCount() {
        return this.numberOfAttributes;
    }

    @Override
    public long getRowCount() {
        return this.numberOfObservations;
    }

    @Override
    public long getElementCount() {
        return this.getRowCount() * (long)this.getColumnCount();
    }

    @Override
    public Object[] getRow(long row) {
        Object[] rowData = new Object[this.numberOfAttributes];
        int ptr = 0;
        for (PhenotypeAttribute attr : this.myAttributeList) {
            rowData[ptr++] = attr.value((int)row);
        }
        return rowData;
    }

    @Override
    public Object getValueAt(long row, int col) {
        return this.myAttributeList.get(col).value((int)row);
    }

    @Override
    public Object value(int obs, int attrnum) {
        return this.myAttributeList.get(attrnum).value(obs);
    }

    @Override
    public boolean isMissing(int obs, int attrnum) {
        return this.myAttributeList.get(attrnum).isMissing(obs);
    }

    @Override
    public PhenotypeAttribute attribute(int attrnum) {
        return this.myAttributeList.get(attrnum);
    }

    @Override
    public int indexOfAttribute(PhenotypeAttribute attribute) {
        return this.myAttributeList.indexOf(attribute);
    }

    @Override
    public List<PhenotypeAttribute> attributeListCopy() {
        return new ArrayList<PhenotypeAttribute>(this.myAttributeList);
    }

    @Override
    public List<PhenotypeAttribute> attributeListOfType(Phenotype.ATTRIBUTE_TYPE type) {
        int[] indices = this.attributeIndicesOfType(type);
        ArrayList<PhenotypeAttribute> attrList = new ArrayList<PhenotypeAttribute>();
        for (int ndx : indices) {
            attrList.add(this.myAttributeList.get(ndx));
        }
        return attrList;
    }

    @Override
    public List<Phenotype.ATTRIBUTE_TYPE> typeListCopy() {
        return new ArrayList<Phenotype.ATTRIBUTE_TYPE>(this.myAttributeTypeList);
    }

    @Override
    public TaxaList taxa() {
        int[] taxaIndices = this.attributeIndicesOfType(Phenotype.ATTRIBUTE_TYPE.taxa);
        if (taxaIndices.length == 1) {
            TaxaAttribute taxaAttr = (TaxaAttribute)this.myAttributeList.get(taxaIndices[0]);
            TreeSet<Taxon> taxaSet = new TreeSet<Taxon>();
            for (Taxon taxon : taxaAttr.allTaxa()) {
                taxaSet.add(taxon);
            }
            return new TaxaListBuilder().addAll(taxaSet).build();
        }
        return null;
    }

    @Override
    public int numberOfAttributes() {
        return this.numberOfAttributes;
    }

    @Override
    public int numberOfAttributesOfType(Phenotype.ATTRIBUTE_TYPE type) {
        return this.attributeIndicesOfType(type).length;
    }

    @Override
    public int[] attributeIndicesOfType(Phenotype.ATTRIBUTE_TYPE type) {
        return Ints.toArray((Collection)this.myAttributeTypeMap.get((Object)type));
    }

    @Override
    public Phenotype.ATTRIBUTE_TYPE attributeType(int attrnum) {
        return this.myAttributeTypeList.get(attrnum);
    }

    @Override
    public int numberOfObservations() {
        return this.numberOfObservations;
    }

    @Override
    public String attributeName(int attrnum) {
        return this.myAttributeList.get(attrnum).name();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasTaxaAttribute() {
        return this.myTaxaAttribute != null;
    }

    @Override
    public TaxaAttribute taxaAttribute() {
        return this.myTaxaAttribute;
    }

    @Override
    public int attributeIndexForName(String name) {
        Integer Index = this.myAttributeNameMap.get(name);
        if (Index == null) {
            return -1;
        }
        return Index;
    }

    public static boolean areAttributeAndTypeListsCompatible(List<PhenotypeAttribute> attributes, List<Phenotype.ATTRIBUTE_TYPE> types) {
        if (attributes.size() != types.size()) {
            return false;
        }
        boolean compatible = true;
        Iterator<Phenotype.ATTRIBUTE_TYPE> typeIter = types.iterator();
        for (PhenotypeAttribute attr : attributes) {
            Phenotype.ATTRIBUTE_TYPE myType;
            if (attr.isTypeCompatible(myType = typeIter.next())) continue;
            compatible = false;
            break;
        }
        return compatible;
    }
}

