/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.TableReport;

public class GenotypePhenotype
implements TableReport {
    private final GenotypeTable myGenotype;
    private final Phenotype myPhenotype;
    private final String name;

    GenotypePhenotype(GenotypeTable theGenotype, Phenotype thePhenotype, String name) {
        this.myGenotype = theGenotype;
        this.myPhenotype = thePhenotype;
        this.name = name;
    }

    public GenotypeTable genotypeTable() {
        return this.myGenotype;
    }

    public Phenotype phenotype() {
        return this.myPhenotype;
    }

    public boolean areGenotypeValuesDiscrete() {
        return true;
    }

    public boolean areTaxaReplicated() {
        return true;
    }

    public String[] getStringGenotype(int site) {
        return null;
    }

    public double[] getNumericGenotype(int site) {
        return null;
    }

    public BitSet missingGenotypes(int site) {
        return null;
    }

    @Override
    public Object[] getTableColumnNames() {
        int numberOfPhenotypeColumns = this.myPhenotype.getColumnCount();
        Object[] colNames = new Object[numberOfPhenotypeColumns + 1];
        System.arraycopy(this.myPhenotype.getTableColumnNames(), 0, colNames, 0, numberOfPhenotypeColumns);
        colNames[numberOfPhenotypeColumns] = "Genotype";
        return null;
    }

    @Override
    public String getTableTitle() {
        return this.name;
    }

    @Override
    public int getColumnCount() {
        return 1 + this.myPhenotype.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.myPhenotype.getRowCount();
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(long row) {
        int numberOfPhenotypeColumns = this.myPhenotype.getColumnCount();
        Object[] rowData = new Object[this.getColumnCount()];
        System.arraycopy(this.myPhenotype.getRow(row), 0, rowData, 0, numberOfPhenotypeColumns);
        rowData[numberOfPhenotypeColumns] = this.genotypeToDisplay((int)row);
        return rowData;
    }

    @Override
    public Object getValueAt(long row, int col) {
        int haplotypeColumn = this.myPhenotype.getColumnCount();
        if (col == haplotypeColumn) {
            return this.genotypeToDisplay((int)row);
        }
        return this.myPhenotype.getValueAt(row, col);
    }

    private String genotypeToDisplay(int row) {
        int genotypeRow = this.indexOfGenotype(row);
        int siteCount = Math.min(this.myGenotype.numberOfSites(), 10);
        StringBuilder builder = new StringBuilder();
        builder.append(this.myGenotype.genotypeAsStringRange(genotypeRow, 0, siteCount));
        if (this.myGenotype.numberOfSites() > 10) {
            builder.append("...");
        }
        return builder.toString();
    }

    private int indexOfGenotype(int phenotypeRow) {
        return this.myGenotype.taxa().indexOf((Taxon)this.myPhenotype.taxa().get(phenotypeRow));
    }
}

