/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class NumericAttribute
implements PhenotypeAttribute {
    private final String name;
    private final float[] values;
    private final BitSet missing;
    private static final List<Phenotype.ATTRIBUTE_TYPE> myAllowedTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();

    public NumericAttribute(String name, float[] values, BitSet missing) {
        this.name = name;
        this.values = values;
        this.missing = missing;
    }

    public float floatValue(int obs) {
        return this.values[obs];
    }

    public float[] floatValues() {
        return this.values;
    }

    @Override
    public Object value(int obs) {
        return new Float(this.values[obs]);
    }

    @Override
    public Object allValues() {
        return this.values;
    }

    @Override
    public PhenotypeAttribute subset(int[] obs, String newName) {
        int n = obs.length;
        float[] valueSubset = new float[n];
        OpenBitSet missingSubset = new OpenBitSet(n);
        for (int i = 0; i < n; ++i) {
            valueSubset[i] = this.values[obs[i]];
            if (!this.missing.fastGet(obs[i])) continue;
            missingSubset.fastSet(i);
        }
        if (newName == null) {
            newName = this.name;
        }
        return new NumericAttribute(newName, valueSubset, missingSubset);
    }

    @Override
    public PhenotypeAttribute changeName(String newName) {
        return new NumericAttribute(newName, this.values, this.missing);
    }

    @Override
    public boolean isMissing(int obs) {
        return this.missing.fastGet(obs);
    }

    @Override
    public BitSet missing() {
        return this.missing;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public List<Phenotype.ATTRIBUTE_TYPE> getCompatibleTypes() {
        return myAllowedTypes;
    }

    @Override
    public boolean isTypeCompatible(Phenotype.ATTRIBUTE_TYPE type) {
        return myAllowedTypes.contains((Object)type);
    }

    static {
        myAllowedTypes.add(Phenotype.ATTRIBUTE_TYPE.data);
        myAllowedTypes.add(Phenotype.ATTRIBUTE_TYPE.covariate);
    }
}

