/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.pipeline;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.maizegenetics.pipeline.TasselPipeline;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TasselPipelineXMLUtil {
    private TasselPipelineXMLUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeArgsAsXML(String filename, String[] args) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("TasselPipeline");
            doc.appendChild(rootElement);
            TasselPipelineXMLUtil.createXML(doc, rootElement, args);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("method", "xml");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filename));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createXML(Document doc, Element element, String[] args) throws IOException {
        int index = 0;
        while (index < args.length) {
            String current = args[index];
            if (!TasselPipelineXMLUtil.isFork(current)) {
                throw new IllegalArgumentException("TasselPipelineXMLUtil: createXML: this flag should be either -fork, -combine, or -runfork: " + current);
            }
            Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
            while (++index < args.length && !TasselPipelineXMLUtil.isFork(args[index])) {
                if (TasselPipelineXMLUtil.isSelfDescribingPlugin(args[index])) {
                    index = TasselPipelineXMLUtil.createSelfDescribingPluginXML(doc, newElement, args, index);
                    continue;
                }
                if (TasselPipelineXMLUtil.isModifier(args[index])) {
                    index = TasselPipelineXMLUtil.createString(doc, newElement, args, index);
                    continue;
                }
                index = TasselPipelineXMLUtil.createXML(doc, newElement, args, index);
            }
        }
    }

    private static int createXML(Document doc, Element element, String[] args, int index) throws IOException {
        String current = args[index];
        Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
        while (++index < args.length && TasselPipelineXMLUtil.isModifier(args[index])) {
            index = TasselPipelineXMLUtil.createString(doc, newElement, args, index);
        }
        return index - 1;
    }

    private static int createSelfDescribingPluginXML(Document doc, Element element, String[] args, int index) throws IOException {
        String current = args[index];
        Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
        while (++index < args.length) {
            if (args[index].equalsIgnoreCase("-endPlugin")) {
                ++index;
                break;
            }
            if (args[index].startsWith("-runfork")) break;
            index = TasselPipelineXMLUtil.createString(doc, newElement, args, index);
        }
        return index - 1;
    }

    private static boolean isFork(String str) {
        return str.startsWith("-fork") || str.startsWith("-runfork") || str.startsWith("-combine");
    }

    private static boolean isModifier(String str) {
        if (str.startsWith("-")) {
            TasselPipeline.FLAGS temp = null;
            try {
                temp = TasselPipeline.FLAGS.valueOf(str.substring(1));
            }
            catch (Exception e) {
                temp = null;
            }
            if (str.startsWith("-fork") || str.startsWith("-runfork") || str.startsWith("-combine")) {
                return false;
            }
            if (temp != null) {
                return false;
            }
            return !TasselPipelineXMLUtil.isSelfDescribingPlugin(str);
        }
        return true;
    }

    private static boolean isSelfDescribingPlugin(String str) {
        if (str.startsWith("-")) {
            str = str.substring(1);
        }
        List<String> matches = Utils.getFullyQualifiedClassNames(str);
        for (String current : matches) {
            if (!Plugin.isPlugin(current)) continue;
            return true;
        }
        return false;
    }

    private static Element createTag(Document doc, Element element, String tag) {
        String str = tag.substring(tag.lastIndexOf(45) + 1);
        Element tagElement = doc.createElement(str);
        element.appendChild(tagElement);
        return tagElement;
    }

    private static int createString(Document doc, Element element, String[] args, int index) throws IOException {
        String current = args[index].substring(args[index].lastIndexOf(45) + 1);
        if (args[index].startsWith("-")) {
            Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
            while (true) {
                if (++index >= args.length) {
                    return index - 1;
                }
                if (args[index].startsWith("-")) {
                    return index - 1;
                }
                newElement.appendChild(doc.createTextNode(args[index]));
            }
        }
        element.appendChild(doc.createTextNode(current));
        return index;
    }

    public static String[] readXMLAsArgs(String filename) {
        ArrayList<String> temp = new ArrayList<String>();
        try {
            File fXmlFile = new File(filename);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            Element rootElement = doc.getDocumentElement();
            if (!rootElement.getNodeName().equalsIgnoreCase("TasselPipeline")) {
                throw new IllegalArgumentException("TasselPipelineXMLUtil: readXMLAsArgs: Root Node must be TasselPipeline: " + rootElement.getNodeName());
            }
            NodeList children = rootElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node current = children.item(i);
                TasselPipelineXMLUtil.getFlags(current, temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] args = new String[temp.size()];
        temp.toArray(args);
        return args;
    }

    private static void getFlags(Node node, List<String> flags) {
        if (node.getNodeType() != 1) {
            return;
        }
        String flagName = node.getNodeName().trim();
        flags.add("-" + flagName);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (current.getNodeType() == 3) {
                String temp = current.getNodeValue().trim();
                if (temp.length() == 0) continue;
                flags.add(temp);
                continue;
            }
            TasselPipelineXMLUtil.getFlags(current, flags);
        }
        if (TasselPipelineXMLUtil.isSelfDescribingPlugin(flagName)) {
            flags.add("-endPlugin");
        }
    }
}

