/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public abstract class AbstractPlugin
implements Plugin {
    private static final Logger myLogger = Logger.getLogger(AbstractPlugin.class);
    private final List<PluginListener> myListeners = new ArrayList<PluginListener>();
    private final List<Plugin> myInputs = new ArrayList<Plugin>();
    private final Frame myParentFrame;
    private final boolean myIsInteractive;
    private boolean myTrace = false;
    private boolean myThreaded = false;
    private static final int TEXT_FIELD_WIDTH = 25;
    private boolean parametersAreSet = true;
    private static final int DEFAULT_TOOL_TIP_LINE_LENGTH = 50;
    private static final List<String> myPrintedCitations = new ArrayList<String>();

    public AbstractPlugin() {
        this(null, true);
    }

    public AbstractPlugin(Frame parentFrame, boolean isInteractive) {
        this.myParentFrame = parentFrame;
        this.myIsInteractive = isInteractive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            this.preProcessParameters(input);
            if (this.isInteractive() && !this.setParametersViaGUI()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.checkRequiredParameters();
            this.postProcessParameters();
            this.printParameterValues();
            this.checkParameters();
            DataSet output = this.processData(input);
            this.fireDataSetReturned(new PluginEvent(output, this.getClass()));
            DataSet dataSet = output;
            return dataSet;
        }
        catch (Exception e) {
            if (this.isInteractive()) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                DialogUtils.showError(e.getMessage() + "\n", (Component)this.getParentFrame());
            } else {
                myLogger.error((Object)e.getMessage());
                this.printUsage();
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                System.exit(1);
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    protected void preProcessParameters(DataSet input) {
    }

    protected void postProcessParameters() {
    }

    @Override
    public DataSet processData(DataSet input) {
        throw new UnsupportedOperationException();
    }

    protected List<Field> getParameterFields() {
        Field[] fields;
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameter.class)) continue;
            current.setAccessible(true);
            result.add(current);
        }
        return result;
    }

    private List<PluginParameter<?>> getParameterInstances() {
        Field[] fields;
        ArrayList result = new ArrayList();
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameter.class)) continue;
            current.setAccessible(true);
            try {
                PluginParameter parameter = (PluginParameter)current.get(this);
                result.add(parameter);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("AbstractPlugin: getParameterInstances: problem getting parameter instances");
            }
        }
        return result;
    }

    private Field getParameterField(String key) {
        Field[] fields;
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameter.class)) continue;
            try {
                current.setAccessible(true);
                PluginParameter parameter = (PluginParameter)current.get(this);
                if (!parameter.cmdLineName().equals(key)) continue;
                return current;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("AbstractPlugin: getParameterField: problem with key: " + key);
            }
        }
        throw new IllegalArgumentException("AbstractPlugin: getParameterField: unknown key: " + key);
    }

    private PluginParameter<?> getParameterInstance(String key) {
        try {
            Field field = this.getParameterField(key);
            return (PluginParameter)field.get(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T convert(String input, Class<T> outputClass) {
        try {
            if (outputClass.isEnum()) {
                return Enum.valueOf(outputClass, input);
            }
            if (outputClass.isAssignableFrom(String.class)) {
                return (T)input;
            }
            return input == null ? null : (T)outputClass.getConstructor(String.class).newInstance(input);
        }
        catch (Exception nfe) {
            throw new IllegalArgumentException("Problem converting: " + input + " to " + outputClass.getName());
        }
    }

    @Override
    public void setParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (args[i].startsWith("-")) {
                    PluginParameter<?> parameter = this.getParameterInstance(arg = arg.substring(1));
                    if (parameter == null) {
                        myLogger.error((Object)("Unrecognized argument: " + args[i]));
                        this.printUsage();
                        System.exit(1);
                    }
                    if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                        if (parameter.valueType().isAssignableFrom(Boolean.class)) {
                            this.setParameter(arg, Boolean.TRUE);
                            continue;
                        }
                        if (Number.class.isAssignableFrom(parameter.valueType())) {
                            this.setParameter(arg, args[i + 1]);
                            ++i;
                            continue;
                        }
                        myLogger.error((Object)("Parameter requires a value: " + args[i]));
                        this.printUsage();
                        System.exit(1);
                        continue;
                    }
                    this.setParameter(arg, args[i + 1]);
                    ++i;
                    continue;
                }
                myLogger.error((Object)("Argument expected to start with dash(-): " + args[i]));
                this.printUsage();
                System.exit(1);
            }
        }
    }

    private void checkRequiredParameters() {
        ArrayList<String> cmdLineNames = new ArrayList<String>();
        for (PluginParameter<?> current : this.getParameterInstances()) {
            if (cmdLineNames.contains(current.cmdLineName())) {
                if (this.isInteractive()) {
                    throw new IllegalStateException(current.cmdLineName() + " exist multiple times for this plugin.");
                }
                myLogger.error((Object)("-" + current.cmdLineName() + " exist multiple times for this plugin.\n"));
                this.printUsage();
                System.exit(1);
            } else {
                cmdLineNames.add(current.cmdLineName());
            }
            if (!current.required() || !current.isEmpty()) continue;
            if (this.isInteractive()) {
                throw new IllegalStateException(current.guiName() + " must be defined.");
            }
            myLogger.error((Object)("-" + current.cmdLineName() + " is required.\n"));
            this.printUsage();
            System.exit(1);
        }
    }

    private void checkParameters() {
        for (PluginParameter<?> current : this.getParameterInstances()) {
            String dirname;
            File directory;
            String outFolder;
            File outDir;
            String filename;
            if (current.fileType() == PluginParameter.FILE_TYPE.IN_FILE && !current.isEmpty()) {
                filename = current.value().toString();
                File theFile = new File(filename);
                if (!theFile.exists()) {
                    if (this.isInteractive()) {
                        throw new IllegalStateException(current.guiName() + ": " + filename + " doesn't exist.");
                    }
                    myLogger.error((Object)("-" + current.cmdLineName() + ": " + filename + " doesn't exist\n"));
                    this.printUsage();
                    System.exit(1);
                }
                if (!theFile.isFile()) {
                    if (this.isInteractive()) {
                        throw new IllegalStateException(current.guiName() + ": " + filename + " isn't a file.");
                    }
                    myLogger.error((Object)("-" + current.cmdLineName() + ": " + filename + " isn't a file\n"));
                    this.printUsage();
                    System.exit(1);
                }
            }
            if (current.fileType() == PluginParameter.FILE_TYPE.OUT_FILE && !current.isEmpty() && !(outDir = new File(outFolder = Utils.getDirectory(filename = current.value().toString()))).isDirectory()) {
                if (this.isInteractive()) {
                    throw new IllegalStateException(current.guiName() + ": Output Directory: " + outFolder + " doesn't exist.");
                }
                myLogger.error((Object)("-" + current.cmdLineName() + ": Output Directory: " + outFolder + " doesn't exist\n"));
                this.printUsage();
                System.exit(1);
            }
            if (current.fileType() != PluginParameter.FILE_TYPE.IN_DIR && current.fileType() != PluginParameter.FILE_TYPE.OUT_DIR || current.isEmpty() || (directory = new File(dirname = current.value().toString())).isDirectory()) continue;
            if (this.isInteractive()) {
                throw new IllegalStateException(current.guiName() + ": Directory: " + dirname + " doesn't exist.");
            }
            myLogger.error((Object)("-" + current.cmdLineName() + ": Directory: " + dirname + " doesn't exist\n"));
            this.printUsage();
            System.exit(1);
        }
    }

    protected void printParameterValues() {
        List<PluginParameter<?>> parameters = this.getParameterInstances();
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(Utils.getBasename(this.getClass().getName()));
        builder.append(" Parameters\n");
        for (PluginParameter<?> current : parameters) {
            builder.append(current.cmdLineName());
            builder.append(": ");
            builder.append(current.value());
            builder.append("\n");
        }
        myLogger.info((Object)builder.toString());
    }

    private void printUsage() {
        StringBuilder builder = new StringBuilder();
        String description = this.pluginDescription();
        if (description != null) {
            builder.append("\n");
            builder.append(Utils.getBasename(this.getClass().getName())).append(" Description...\n");
            builder.append(this.pluginDescription());
            builder.append("\n");
        }
        builder.append("\nUsage:\n");
        builder.append(Utils.getBasename(this.getClass().getName())).append(" <options>\n");
        for (PluginParameter<?> current : this.getParameterInstances()) {
            builder.append("-");
            builder.append(current.cmdLineName());
            builder.append(" ");
            if (current.valueType().isAssignableFrom(Boolean.class)) {
                builder.append("<true | false>");
            } else {
                builder.append("<");
                builder.append(current.guiName());
                builder.append(">");
            }
            builder.append(" : ");
            builder.append(current.description());
            if (current.range() != null) {
                if (current.valueType().isEnum()) {
                    builder.append(" [");
                    Comparable[] values = (Comparable[])current.valueType().getEnumConstants();
                    for (int i = 0; i < values.length; ++i) {
                        if (i != 0) {
                            builder.append(" ");
                        }
                        builder.append(values[i].toString());
                    }
                    builder.append("]");
                } else {
                    builder.append(" ");
                    builder.append(current.range().toString());
                }
            }
            if (current.defaultValue() != null) {
                builder.append(" (Default: ");
                builder.append(current.defaultValue());
                builder.append(")");
            }
            if (current.required()) {
                builder.append(" (required)");
            }
            builder.append("\n");
        }
        myLogger.info((Object)builder.toString());
    }

    @Override
    public String getUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append(Utils.getBasename(this.getClass().getName()));
        builder.append("\n");
        String description = this.pluginDescription();
        if (description != null) {
            builder.append("\nDescription: ");
            builder.append(this.pluginDescription());
            builder.append("\n\n");
        }
        for (PluginParameter<?> current : this.getParameterInstances()) {
            builder.append("\n");
            builder.append(current.guiName());
            builder.append(" : ");
            builder.append(current.description());
            if (current.range() != null) {
                if (current.valueType().isEnum()) {
                    builder.append(" [");
                    Comparable[] values = (Comparable[])current.valueType().getEnumConstants();
                    for (int i = 0; i < values.length; ++i) {
                        if (i != 0) {
                            builder.append(" ");
                        }
                        builder.append(values[i].toString());
                    }
                    builder.append("]");
                } else {
                    builder.append(" ");
                    builder.append(current.range().toString());
                }
            }
            if (current.defaultValue() != null) {
                builder.append(" (Default: ");
                builder.append(current.defaultValue());
                builder.append(")");
            }
            if (current.required()) {
                builder.append(" (required)");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public Comparable getParameter(Enum key) {
        return this.getParameterInstance(key.toString()).value();
    }

    @Override
    public Comparable getParameter(String key) {
        return this.getParameterInstance(key).value();
    }

    @Override
    public Plugin setParameter(PluginParameter param, Object value) {
        if (value instanceof String) {
            this.setParameter(param.cmdLineName(), (String)value);
        } else if (value instanceof Comparable) {
            this.setParameter(param.cmdLineName(), (Comparable)value);
        } else {
            throw new IllegalArgumentException("AbstractPlugin: setParameter: illegal value type: " + value.getClass().getName());
        }
        return this;
    }

    @Override
    public Plugin setParameter(String key, Comparable value) {
        block7: {
            PluginParameter parameter = null;
            try {
                Field field = this.getParameterField(key);
                parameter = (PluginParameter)field.get(this);
                if (parameter == null) {
                    throw new IllegalArgumentException("setParameter: Unknown Parameter: " + key);
                }
                if (parameter.range() != null && !parameter.range().contains(value)) {
                    throw new IllegalArgumentException("setParameter: " + parameter.cmdLineName() + " value: " + value.toString() + " outside range: " + parameter.range().toString());
                }
                PluginParameter<Comparable> newParameter = new PluginParameter<Comparable>(parameter, value);
                field.set(this, newParameter);
            }
            catch (Exception e) {
                if (this.isInteractive()) {
                    try {
                        throw e;
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                        break block7;
                    }
                }
                myLogger.error((Object)(key + ": " + e.getMessage()));
                this.printUsage();
                System.exit(1);
            }
        }
        return this;
    }

    @Override
    public Plugin setParameter(String key, String value) {
        PluginParameter<?> parameter = null;
        try {
            parameter = this.getParameterInstance(key);
            return this.setParameter(key, (Comparable)AbstractPlugin.convert(value, parameter.valueType()));
        }
        catch (Exception e) {
            if (this.isInteractive()) {
                throw new IllegalArgumentException(this.getParameterInstance(key).guiName() + ": " + e.getMessage());
            }
            myLogger.error((Object)(key + ": " + e.getMessage()));
            this.printUsage();
            System.exit(1);
            return this;
        }
    }

    private <T extends Comparable<T>> boolean setParametersViaGUI() {
        final List<PluginParameter<?>> parameterInstances = this.getParameterInstances();
        if (parameterInstances.isEmpty()) {
            return true;
        }
        final JDialog dialog = new JDialog(this.getParentFrame(), null, true);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractPlugin.this.parametersAreSet = false;
                dialog.setVisible(false);
            }
        });
        final HashMap<String, JComponent> parameterFields = new HashMap<String, JComponent>();
        this.parametersAreSet = true;
        JButton okButton = new JButton();
        okButton.setActionCommand("Ok");
        okButton.setText("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (PluginParameter current : parameterInstances) {
                        JComponent component = (JComponent)parameterFields.get(current.cmdLineName());
                        if (component instanceof JTextField) {
                            String input = ((JTextField)component).getText().trim();
                            AbstractPlugin.this.setParameter(current.cmdLineName(), input);
                            continue;
                        }
                        if (component instanceof JCheckBox) {
                            if (((JCheckBox)component).isSelected()) {
                                AbstractPlugin.this.setParameter(current.cmdLineName(), Boolean.TRUE);
                                continue;
                            }
                            AbstractPlugin.this.setParameter(current.cmdLineName(), Boolean.FALSE);
                            continue;
                        }
                        if (!(component instanceof JComboBox)) continue;
                        Enum temp = (Enum)((JComboBox)component).getSelectedItem();
                        AbstractPlugin.this.setParameter(current.cmdLineName(), (Comparable)((Object)temp));
                    }
                }
                catch (Exception ex) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Problem Setting Parameters: ");
                    builder.append("\n");
                    builder.append(Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(ex), 50));
                    String str = builder.toString();
                    DialogUtils.showError(str, (Component)AbstractPlugin.this.getParentFrame());
                    return;
                }
                dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractPlugin.this.parametersAreSet = false;
                dialog.setVisible(false);
            }
        });
        JButton defaultsButton = new JButton();
        defaultsButton.setText("Defaults");
        defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractPlugin.this.setFieldsToDefault(parameterFields);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (final PluginParameter<?> current : this.getParameterInstances()) {
            if (current.valueType().isEnum()) {
                Comparable[] values;
                JComboBox<Comparable> menu = new JComboBox<Comparable>();
                for (Comparable item : values = (Comparable[])current.valueType().getEnumConstants()) {
                    menu.addItem(item);
                }
                menu.setSelectedItem(current.value());
                this.createEnableDisableAction(current, parameterFields, menu);
                JPanel temp = new JPanel(new FlowLayout(1));
                temp.add(new JLabel(current.guiName()));
                temp.add(menu);
                temp.setToolTipText(this.getToolTip(current));
                panel.add(temp);
                parameterFields.put(current.cmdLineName(), menu);
                continue;
            }
            if (current.valueType().isAssignableFrom(Boolean.class)) {
                JCheckBox check = new JCheckBox(current.guiName());
                check.setToolTipText(this.getToolTip(current));
                if (current.value() == Boolean.TRUE) {
                    check.setSelected(true);
                } else {
                    check.setSelected(false);
                }
                this.createEnableDisableAction(current, parameterFields, check);
                JPanel temp = new JPanel(new FlowLayout(1));
                temp.add(check);
                panel.add(temp);
                parameterFields.put(current.cmdLineName(), check);
                continue;
            }
            final JTextField field = current.fileType() != PluginParameter.FILE_TYPE.NA ? new JTextField(17) : new JTextField(25);
            if (current.value() != null) {
                field.setText(current.value().toString());
            }
            field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String input = field.getText().trim();
                    try {
                        if (!current.acceptsValue(input)) {
                            JOptionPane.showMessageDialog(dialog, current.guiName() + " range: " + current.range().toString());
                            field.setText(AbstractPlugin.this.getParameterInstance(current.cmdLineName()).value().toString());
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(dialog, current.guiName() + ": " + ex.getMessage());
                        field.setText(AbstractPlugin.this.getParameterInstance(current.cmdLineName()).value().toString());
                    }
                }
            });
            String label = null;
            label = current.required() ? current.guiName() + "*" : current.guiName();
            JPanel line = null;
            if (current.fileType() == PluginParameter.FILE_TYPE.IN_FILE) {
                JButton browse = this.getOpenFile(dialog, field);
                line = this.getLine(label, field, browse, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field, browse});
            } else if (current.fileType() == PluginParameter.FILE_TYPE.OUT_FILE) {
                JButton browse = this.getSaveFile(dialog, field);
                line = this.getLine(label, field, browse, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field, browse});
            } else if (current.fileType() == PluginParameter.FILE_TYPE.IN_DIR) {
                JButton browse = this.getOpenDir(dialog, field);
                line = this.getLine(label, field, browse, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field, browse});
            } else if (current.fileType() == PluginParameter.FILE_TYPE.OUT_DIR) {
                JButton browse = this.getSaveDir(dialog, field);
                line = this.getLine(label, field, browse, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field, browse});
            } else {
                line = this.getLine(label, field, null, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, field);
            }
            panel.add(line);
            parameterFields.put(current.cmdLineName(), field);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)new JScrollPane(panel, 20, 31), this.getButtonName());
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout());
        pnlButtons.add(okButton);
        pnlButtons.add(cancelButton);
        pnlButtons.add(defaultsButton);
        dialog.getContentPane().add((Component)tabbedPane, "Center");
        dialog.getContentPane().add((Component)pnlButtons, "South");
        JTextArea helpText = new JTextArea(this.getUsage());
        helpText.setLineWrap(true);
        helpText.setWrapStyleWord(true);
        helpText.setMargin(new Insets(10, 10, 10, 10));
        helpText.setEditable(false);
        tabbedPane.add((Component)new JScrollPane(helpText), "Help");
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize.getHeight() - 125.0 < (double)dialog.getHeight()) {
            dialog.setSize(dialog.getWidth(), (int)screenSize.getHeight() - 125);
        }
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(this.getParentFrame());
        dialog.setVisible(true);
        return this.parametersAreSet;
    }

    private void setFieldsToDefault(Map<String, JComponent> parameterFields) {
        List<PluginParameter<?>> parameterInstances = this.getParameterInstances();
        if (parameterInstances.isEmpty()) {
            return;
        }
        for (PluginParameter<?> current : parameterInstances) {
            JComponent component = parameterFields.get(current.cmdLineName());
            if (component instanceof JTextField) {
                Object defaultValue = current.defaultValue();
                if (defaultValue == null) {
                    ((JTextField)component).setText(null);
                } else {
                    ((JTextField)component).setText(defaultValue.toString());
                }
                this.setParameter(current.cmdLineName(), (Comparable)defaultValue);
                continue;
            }
            if (component instanceof JCheckBox) {
                Boolean value = (Boolean)current.defaultValue();
                ((JCheckBox)component).setSelected(value);
                this.setParameter(current.cmdLineName(), value);
                continue;
            }
            if (!(component instanceof JComboBox)) continue;
            ((JComboBox)component).setSelectedItem(current.defaultValue());
            this.setParameter(current.cmdLineName(), (Comparable)current.defaultValue());
        }
    }

    private void createEnableDisableAction(PluginParameter<?> current, Map<String, JComponent> parameterFields, JComponent component) {
        this.createEnableDisableAction(current, parameterFields, new JComponent[]{component});
    }

    private void createEnableDisableAction(final PluginParameter<?> current, Map<String, JComponent> parameterFields, final JComponent[] components) {
        if (current.dependentOnParameter() != null) {
            JComponent depends = parameterFields.get(current.dependentOnParameter().cmdLineName());
            if (depends instanceof JCheckBox) {
                final JCheckBox checkBox = (JCheckBox)depends;
                for (JComponent component : components) {
                    if (checkBox.isSelected() == ((Boolean)current.dependentOnParameterValue()).booleanValue()) {
                        component.setEnabled(true);
                        continue;
                    }
                    component.setEnabled(false);
                }
                checkBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        for (JComponent component : components) {
                            if (checkBox.isSelected() == ((Boolean)current.dependentOnParameterValue()).booleanValue()) {
                                component.setEnabled(true);
                                continue;
                            }
                            component.setEnabled(false);
                        }
                    }
                });
            } else if (depends instanceof JComboBox) {
                final JComboBox comboBox = (JComboBox)depends;
                for (JComponent component : components) {
                    if (comboBox.getSelectedItem() == current.dependentOnParameterValue()) {
                        component.setEnabled(true);
                        continue;
                    }
                    component.setEnabled(false);
                }
                comboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        for (JComponent component : components) {
                            if (comboBox.getSelectedItem() == current.dependentOnParameterValue()) {
                                component.setEnabled(true);
                                continue;
                            }
                            component.setEnabled(false);
                        }
                    }
                });
            }
        }
    }

    private String getToolTip(PluginParameter<?> parameter) {
        String description = parameter.description();
        int count = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        int n = description.length();
        for (int i = 0; i < n; ++i) {
            ++count;
            if (description.charAt(i) == '\n') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            if (count > 50 && description.charAt(i) == ' ') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            builder.append(description.charAt(i));
        }
        builder.append("</html>");
        return builder.toString();
    }

    private JPanel getLine(String label, JTextField ref, JButton button, String description) {
        JPanel result = new JPanel(new FlowLayout(2));
        result.setToolTipText(description);
        result.add(new JLabel(label));
        ref.setEditable(true);
        ref.setHorizontalAlignment(2);
        ref.setAlignmentX(0.5f);
        ref.setAlignmentY(0.5f);
        ref.setMaximumSize(ref.getPreferredSize());
        result.add(ref);
        if (button != null) {
            result.add(button);
        }
        return result;
    }

    private JButton getOpenFile(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(TasselPrefs.getOpenDir());
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showOpenDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putOpenDir(fileChooser.getCurrentDirectory().getPath());
                }
            }
        });
        return result;
    }

    private JButton getSaveFile(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(TasselPrefs.getSaveDir());
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showSaveDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putSaveDir(fileChooser.getCurrentDirectory().getPath());
                }
            }
        });
        return result;
    }

    private JButton getOpenDir(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(Utils.getDirectory(TasselPrefs.getOpenDir()));
        fileChooser.setFileSelectionMode(1);
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showOpenDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putOpenDir(file.getPath());
                }
            }
        });
        return result;
    }

    private JButton getSaveDir(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(Utils.getDirectory(TasselPrefs.getSaveDir()));
        fileChooser.setFileSelectionMode(1);
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showOpenDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putSaveDir(file.getPath());
                }
            }
        });
        return result;
    }

    @Override
    public JMenu getMenu() {
        return null;
    }

    @Override
    public void receiveInput(Plugin input) {
        if (input == null) {
            throw new IllegalArgumentException("AbstractPlugin: receiveInput: input can not be null.");
        }
        if (!this.myInputs.contains(input)) {
            this.myInputs.add(input);
        }
        input.addListener(this);
    }

    @Override
    public JPanel getPanel() {
        return null;
    }

    @Override
    public boolean isInteractive() {
        return this.myIsInteractive;
    }

    @Override
    public Frame getParentFrame() {
        return this.myParentFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PluginListener listener) {
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            if (listener != null && !this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
            }
        }
    }

    protected List<PluginListener> getListeners() {
        return this.myListeners;
    }

    public List<Plugin> getInputs() {
        return this.myInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataSetReturned(PluginEvent event) {
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            Iterator<PluginListener> itr = this.myListeners.iterator();
            while (itr.hasNext()) {
                try {
                    PluginListener current;
                    if (this.myThreaded) {
                        current = itr.next();
                        ThreadedPluginListener thread = new ThreadedPluginListener(current, event);
                        thread.start();
                        continue;
                    }
                    current = itr.next();
                    current.dataSetReturned(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void fireDataSetReturned(DataSet data) {
        this.fireDataSetReturned(new PluginEvent(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgress(PluginEvent event) {
        Datum datum;
        Integer percent;
        List<Datum> percentage;
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            for (PluginListener current : this.myListeners) {
                current.progress(event);
            }
        }
        DataSet ds = (DataSet)event.getSource();
        if (ds != null && (percentage = ds.getDataOfType(Integer.class)).size() > 0 && (percent = (Integer)(datum = percentage.get(0)).getData()) == 100 && !myPrintedCitations.contains(this.getCitation())) {
            myLogger.info((Object)(this.getClass().getName() + "  Citation: " + this.getCitation()));
            myPrintedCitations.add(this.getCitation());
        }
    }

    protected void fireProgress(Integer percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("AbstractPlugin: fireProgress: percent must be between 0 and 100 inclusive.  arg: " + percent);
        }
        Datum percentage = new Datum("Percent", percent, null);
        this.fireProgress(new PluginEvent(new DataSet(percentage, (Plugin)this)));
    }

    @Override
    public String getCitation() {
        return "Bradbury PJ, Zhang Z, Kroon DE, Casstevens TM, Ramdoss Y, Buckler ES. (2007) TASSEL: Software for association mapping of complex traits in diverse samples. Bioinformatics 23:2633-2635.";
    }

    @Override
    public String pluginDescription() {
        return null;
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        DataSet input = (DataSet)event.getSource();
        this.performFunction(input);
    }

    @Override
    public void progress(PluginEvent event) {
    }

    public void reverseTrace(int indent) {
        if (this.myTrace) {
            return;
        }
        this.indent(indent);
        System.out.println(this.getClass().getName());
        Iterator<Plugin> itr = this.myInputs.iterator();
        while (itr.hasNext()) {
            try {
                AbstractPlugin current = (AbstractPlugin)itr.next();
                current.reverseTrace(indent + 3);
            }
            catch (Exception exception) {}
        }
        this.myTrace = true;
    }

    public void trace(int indent) {
        if (this.myTrace) {
            return;
        }
        this.indent(indent);
        System.out.println(this.getClass().getName());
        Iterator<PluginListener> itr = this.myListeners.iterator();
        while (itr.hasNext()) {
            try {
                AbstractPlugin current = (AbstractPlugin)itr.next();
                current.trace(indent + 3);
            }
            catch (Exception exception) {}
        }
        this.myTrace = true;
    }

    private void indent(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.myThreaded = threaded;
    }

    @Override
    public boolean cancel() {
        return false;
    }

    @Override
    public void run() {
        this.performFunction(null);
    }

    @Override
    public void progress(int percent, Object meta) {
        this.fireProgress(percent);
    }
}

