/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.awt.Frame;
import java.lang.reflect.Constructor;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.ProgressListener;
import org.apache.log4j.Logger;

public interface Plugin
extends PluginListener,
ProgressListener,
Runnable {
    public static final Logger myLogger = Logger.getLogger(Plugin.class);

    public JMenu getMenu();

    public DataSet performFunction(DataSet var1);

    public DataSet processData(DataSet var1);

    public Comparable getParameter(Enum var1);

    public Comparable getParameter(String var1);

    public Plugin setParameter(PluginParameter var1, Object var2);

    public Plugin setParameter(String var1, Comparable var2);

    public Plugin setParameter(String var1, String var2);

    public void receiveInput(Plugin var1);

    public JPanel getPanel();

    public boolean isInteractive();

    public Frame getParentFrame();

    public ImageIcon getIcon();

    public String getButtonName();

    public String getToolTipText();

    public void addListener(PluginListener var1);

    public void setThreaded(boolean var1);

    public boolean cancel();

    public void setParameters(String[] var1);

    public String getCitation();

    public String pluginDescription();

    public String getUsage();

    public static Plugin getPluginInstance(String className, Frame frame) {
        try {
            Class<?> currentMatch = Class.forName(className);
            Constructor<?> constructor = currentMatch.getConstructor(Frame.class);
            return (Plugin)constructor.newInstance(frame);
        }
        catch (Exception ex) {
            try {
                Class<?> currentMatch = Class.forName(className);
                Constructor<?> constructor = currentMatch.getConstructor(Frame.class, Boolean.TYPE);
                return (Plugin)constructor.newInstance(frame, false);
            }
            catch (NoSuchMethodException nsme) {
                myLogger.warn((Object)("Self-describing Plugins should implement this constructor: " + className));
                myLogger.warn((Object)"public Plugin(Frame parentFrame, boolean isInteractive) {");
                myLogger.warn((Object)"   super(parentFrame, isInteractive);");
                myLogger.warn((Object)"}");
                return null;
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    public static boolean isPlugin(String className) {
        try {
            Class<?> currentMatch = Class.forName(className);
            return !currentMatch.isInterface() && Plugin.class.isAssignableFrom(currentMatch);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

