/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import com.google.common.collect.Range;
import net.maizegenetics.plugindef.AbstractPlugin;

public final class PluginParameter<T extends Comparable<T>> {
    private final String myGuiName;
    private final String myUnits;
    private final String myCmdLineName;
    private final String myDescription;
    private final Range<T> myRange;
    private final T myDefaultValue;
    private final T myValue;
    private final boolean myRequired;
    private final Class<T> myClass;
    private final PluginParameter<?> myDependentOnParameter;
    private final Comparable<?> myDependentOnParameterValue;
    private final FILE_TYPE myFileType;

    private PluginParameter(String guiName, String guiUnits, String cmdLineName, String description, Range<T> range, T defaultValue, T value, boolean required, FILE_TYPE fileType, PluginParameter<?> dependentOnParameter, Comparable<?> dependentOnParameterValue, Class<T> type) {
        this.myGuiName = guiName;
        this.myUnits = guiUnits;
        this.myCmdLineName = cmdLineName;
        this.myDescription = description;
        this.myRange = range;
        this.myDefaultValue = defaultValue;
        this.myValue = value == null ? defaultValue : value;
        if (!this.acceptsValue(this.myValue)) {
            StringBuilder builder = new StringBuilder();
            builder.append("PluginParameter: init: " + this.myCmdLineName + " value: " + value.toString() + " outside range: ");
            if (this.valueType().isEnum()) {
                builder.append(" [");
                Comparable[] values = (Comparable[])this.valueType().getEnumConstants();
                for (int i = 0; i < values.length; ++i) {
                    if (i != 0) {
                        builder.append(" ");
                    }
                    builder.append(values[i].toString());
                }
                builder.append("]");
            } else {
                builder.append(this.myRange.toString());
            }
            throw new IllegalArgumentException(builder.toString());
        }
        this.myRequired = required;
        if (this.myDefaultValue != null && this.myRequired) {
            throw new IllegalArgumentException("PluginParameter: init: " + this.myCmdLineName + " shouldn't have default value and be required.");
        }
        this.myClass = type;
        this.myFileType = fileType;
        this.myDependentOnParameter = dependentOnParameter;
        this.myDependentOnParameterValue = dependentOnParameterValue;
    }

    public PluginParameter(PluginParameter<T> oldParameter, T newValue) {
        this(oldParameter.myGuiName, oldParameter.myUnits, oldParameter.myCmdLineName, oldParameter.myDescription, oldParameter.myRange, oldParameter.myDefaultValue, newValue, oldParameter.myRequired, oldParameter.myFileType, oldParameter.dependentOnParameter(), oldParameter.dependentOnParameterValue(), oldParameter.myClass);
    }

    public String guiName() {
        return this.myGuiName;
    }

    public String units() {
        return this.myUnits;
    }

    public String cmdLineName() {
        return this.myCmdLineName;
    }

    public String description() {
        return this.myDescription;
    }

    public Range<T> range() {
        return this.myRange;
    }

    public boolean acceptsValue(T value) {
        return this.myRange == null || this.myRange.contains(value);
    }

    public boolean acceptsValue(String input) {
        Comparable value = (Comparable)AbstractPlugin.convert(input, this.valueType());
        return this.myRange == null || this.myRange.contains(value);
    }

    public T value() {
        return this.myValue;
    }

    public T defaultValue() {
        return this.myDefaultValue;
    }

    public boolean required() {
        return this.myRequired;
    }

    public Class<T> valueType() {
        return this.myClass;
    }

    public FILE_TYPE fileType() {
        return this.myFileType;
    }

    public PluginParameter<?> dependentOnParameter() {
        return this.myDependentOnParameter;
    }

    public Comparable<?> dependentOnParameterValue() {
        return this.myDependentOnParameterValue;
    }

    public boolean isEmpty() {
        return this.myValue == null || this.myValue.toString().trim().length() == 0;
    }

    /* synthetic */ PluginParameter(String x0, String x1, String x2, String x3, Range x4, Comparable x5, Comparable x6, boolean x7, FILE_TYPE x8, PluginParameter x9, Comparable x10, Class x11, 1 x12) {
        this(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
    }

    public static class Builder<T extends Comparable<T>> {
        private String myGuiName;
        private String myUnits = "";
        private final String myCmdLineName;
        private String myDescription = "";
        private Range<T> myRange = null;
        private final T myDefaultValue;
        private boolean myIsRequired = false;
        private final Class<T> myClass;
        private FILE_TYPE myFileType = FILE_TYPE.NA;
        private PluginParameter<?> myDependentOnParameter = null;
        private Comparable<?> myDependentOnParameterValue = null;

        public Builder(String cmdLineName, T defaultValue, Class<T> type) {
            this.myCmdLineName = cmdLineName.toString();
            this.myDefaultValue = defaultValue;
            this.myClass = type;
        }

        public Builder<T> units(String units) {
            this.myUnits = units;
            return this;
        }

        public Builder<T> description(String description) {
            this.myDescription = description;
            return this;
        }

        public Builder<T> range(Range<T> range) {
            this.myRange = range;
            return this;
        }

        public Builder<T> required(boolean required) {
            this.myIsRequired = required;
            return this;
        }

        public Builder<T> guiName(String guiName) {
            this.myGuiName = guiName;
            return this;
        }

        public Builder<T> inFile() {
            this.myFileType = FILE_TYPE.IN_FILE;
            return this;
        }

        public Builder<T> outFile() {
            this.myFileType = FILE_TYPE.OUT_FILE;
            return this;
        }

        public Builder<T> inDir() {
            this.myFileType = FILE_TYPE.IN_DIR;
            return this;
        }

        public Builder<T> outDir() {
            this.myFileType = FILE_TYPE.OUT_DIR;
            return this;
        }

        public Builder<T> dependentOnParameter(PluginParameter<?> parameter) {
            if (Boolean.class.isAssignableFrom(parameter.valueType())) {
                return this.dependentOnParameter(parameter, Boolean.valueOf(true));
            }
            throw new IllegalArgumentException("PluginParameter: dependentOnParameter: no default value for: " + parameter.valueType().getName());
        }

        public Builder<T> dependentOnParameter(PluginParameter<?> parameter, Comparable<?> value) {
            this.myDependentOnParameter = parameter;
            this.myDependentOnParameterValue = value;
            return this;
        }

        public PluginParameter<T> build() {
            if (this.myGuiName == null || this.myGuiName.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append(Character.toUpperCase(this.myCmdLineName.charAt(0)));
                for (int i = 1; i < this.myCmdLineName.length(); ++i) {
                    char current = this.myCmdLineName.charAt(i);
                    if (Character.isUpperCase(current)) {
                        builder.append(" ");
                    }
                    builder.append(current);
                }
                this.myGuiName = builder.toString();
            }
            if (this.myDescription.isEmpty()) {
                this.myDescription = this.myGuiName;
            }
            return new PluginParameter(this.myGuiName, this.myUnits, this.myCmdLineName, this.myDescription, (Range)this.myRange, (Comparable)this.myDefaultValue, null, this.myIsRequired, this.myFileType, this.myDependentOnParameter, this.myDependentOnParameterValue, this.myClass, null);
        }
    }

    public static enum FILE_TYPE {
        NA,
        IN_FILE,
        OUT_FILE,
        IN_DIR,
        OUT_DIR;

    }
}

