/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import net.maizegenetics.stats.linearmodels.Level;

public class BasicLevel
implements Level {
    private Comparable[] levelValues;
    private int index;
    private int random;

    public BasicLevel(Comparable[] levelValues) {
        this.levelValues = levelValues;
    }

    public BasicLevel(Level[] levels) {
        int nlevels = 0;
        for (int i = 0; i < levels.length; ++i) {
            nlevels = this.getNumberOfSublevels();
        }
        this.levelValues = new Comparable[nlevels];
        int cnt = 0;
        for (int i = 0; i < levels.length; ++i) {
            for (int j = 0; j < levels[i].getNumberOfSublevels(); ++j) {
                this.levelValues[cnt++] = levels[i].getSublevel(j);
            }
        }
    }

    public BasicLevel(Collection c) {
        LinkedList<Comparable> levelList = new LinkedList<Comparable>();
        for (Level level : c) {
            for (int i = 0; i < level.getNumberOfSublevels(); ++i) {
                levelList.add(level.getSublevel(i));
            }
        }
        this.levelValues = new Comparable[levelList.size()];
        levelList.toArray(this.levelValues);
    }

    @Override
    public int compareTo(Level otherLevel) {
        for (int i = 0; i < this.levelValues.length; ++i) {
            int result = this.levelValues[i].compareTo(otherLevel.getSublevel(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Level)) {
            return false;
        }
        Level otherLevel = (Level)o;
        if (this.levelValues.length != otherLevel.getNumberOfSublevels()) {
            return false;
        }
        for (int i = 0; i < this.levelValues.length; ++i) {
            if (this.levelValues[i].equals(otherLevel.getSublevel(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashval = 0;
        for (int i = 0; i < this.levelValues.length; ++i) {
            hashval += this.levelValues[i].hashCode();
        }
        return hashval;
    }

    public String toString() {
        StringBuffer out = new StringBuffer(this.levelValues[0].toString());
        for (int i = 1; i < this.levelValues.length; ++i) {
            out.append(":");
            out.append(this.levelValues[i].toString());
        }
        return out.toString();
    }

    @Override
    public int getNumberOfSublevels() {
        return this.levelValues.length;
    }

    @Override
    public Comparable[] getSublevels() {
        return this.levelValues;
    }

    @Override
    public Comparable getSublevel(int sublevel) {
        return this.levelValues[sublevel];
    }

    @Override
    public boolean contains(Comparable sublevel) {
        for (int i = 0; i < this.levelValues.length; ++i) {
            if (!this.levelValues[i].equals(sublevel)) continue;
            return true;
        }
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getRandom() {
        return this.random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public static Comparator indexComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                BasicLevel basicLevel1 = (BasicLevel)o1;
                BasicLevel basicLevel2 = (BasicLevel)o2;
                int result = basicLevel1.compareTo(basicLevel2);
                if (result != 0) {
                    return result;
                }
                return basicLevel1.getIndex() - basicLevel2.getIndex();
            }
        };
    }

    public static Comparator randomComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                BasicLevel basicLevel1 = (BasicLevel)o1;
                BasicLevel basicLevel2 = (BasicLevel)o2;
                int result = basicLevel1.compareTo(basicLevel2);
                if (result != 0) {
                    return result;
                }
                if (basicLevel1.getRandom() > basicLevel2.getRandom()) {
                    return 1;
                }
                if (basicLevel1.getRandom() < basicLevel2.getRandom()) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

