/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.NestedCovariateModelEffect;

public class ModelEffectUtils {
    private ModelEffectUtils() {
    }

    public static DoubleMatrix getXtY(ModelEffect X, ModelEffect Y) {
        if (X instanceof FactorModelEffect) {
            FactorModelEffect fme = (FactorModelEffect)X;
            if (Y instanceof FactorModelEffect) {
                return fme.getXtX2((FactorModelEffect)Y);
            }
            if (Y instanceof CovariateModelEffect) {
                return fme.getXty(((CovariateModelEffect)Y).getCovariate());
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return fme.getX().mult(Y.getX(), true, false);
            }
        } else if (X instanceof CovariateModelEffect) {
            double[] cov = ((CovariateModelEffect)X).getCovariate();
            if (Y instanceof FactorModelEffect) {
                return ModelEffectUtils.getXtY(Y, X).transpose();
            }
            if (Y instanceof CovariateModelEffect) {
                return Y.getXty(cov);
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return Y.getXty(cov).transpose();
            }
        } else if (X instanceof NestedCovariateModelEffect) {
            if (Y instanceof FactorModelEffect) {
                return X.getX().mult(Y.getX(), true, false);
            }
            if (Y instanceof CovariateModelEffect) {
                return X.getXty(((CovariateModelEffect)Y).getCovariate());
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return ((NestedCovariateModelEffect)X).getXtX2((NestedCovariateModelEffect)Y);
            }
        }
        return null;
    }

    public static int[] getIntegerLevels(Object[] originalLevels) {
        int nLevels = originalLevels.length;
        int[] intLevels = new int[nLevels];
        HashMap<Object, Integer> levelMap = new HashMap<Object, Integer>();
        for (int i = 0; i < nLevels; ++i) {
            Integer ndx = (Integer)levelMap.get(originalLevels[i]);
            if (ndx == null) {
                ndx = new Integer(levelMap.size());
                levelMap.put(originalLevels[i], ndx);
            }
            intLevels[i] = ndx;
        }
        return intLevels;
    }

    public static <T> int[] getIntegerLevels(T[] originalLevels, ArrayList<T> ids) {
        int nLevels = originalLevels.length;
        int[] intLevels = new int[nLevels];
        HashMap<T, Integer> levelMap = new HashMap<T, Integer>();
        for (int i = 0; i < nLevels; ++i) {
            Integer ndx = (Integer)levelMap.get(originalLevels[i]);
            if (ndx == null) {
                ndx = new Integer(levelMap.size());
                levelMap.put(originalLevels[i], ndx);
            }
            intLevels[i] = ndx;
        }
        if (ids != null) {
            TreeSet sortedEntries = new TreeSet(new Comparator<Map.Entry<T, Integer>>(){

                @Override
                public int compare(Map.Entry<T, Integer> arg0, Map.Entry<T, Integer> arg1) {
                    return arg0.getValue().compareTo(arg1.getValue());
                }
            });
            sortedEntries.addAll(levelMap.entrySet());
            for (Map.Entry entry : sortedEntries) {
                ids.add(entry.getKey());
            }
        }
        return intLevels;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int[] getIntegerLevels(ArrayList<T> originalLevels, ArrayList<T> ids) {
        int[] intLevels = new int[originalLevels.size()];
        HashMap<T, Integer> levelMap = new HashMap<T, Integer>();
        int count = 0;
        for (T level : originalLevels) {
            void var7_7;
            Integer n = (Integer)levelMap.get(level);
            if (n == null) {
                Integer n2 = new Integer(levelMap.size());
                levelMap.put(level, n2);
            }
            intLevels[count++] = var7_7.intValue();
        }
        if (ids != null) {
            TreeSet sortedEntries = new TreeSet(new Comparator<Map.Entry<T, Integer>>(){

                @Override
                public int compare(Map.Entry<T, Integer> arg0, Map.Entry<T, Integer> arg1) {
                    return arg0.getValue().compareTo(arg1.getValue());
                }
            });
            sortedEntries.addAll(levelMap.entrySet());
            for (Map.Entry entry : sortedEntries) {
                ids.add(entry.getKey());
            }
        }
        return intLevels;
    }

    public static <T> int[] getIntegerLevels(ArrayList<T> originalLevels) {
        return ModelEffectUtils.getIntegerLevels(originalLevels, null);
    }

    public static double[] getNumericCodingForAdditiveModel(Object[] marker, String allele) {
        String firstMarker = (String)marker[0];
        int nmarkers = marker.length;
        double[] values = new double[nmarkers];
        if (firstMarker.contains(":")) {
            Pattern colon = Pattern.compile(":");
            for (int m = 0; m < nmarkers; ++m) {
                String markerval = (String)marker[m];
                String[] markerAlleles = colon.split(markerval);
                if (markerAlleles[0].equals(allele)) {
                    int n = m;
                    values[n] = values[n] + 1.0;
                }
                if (!markerAlleles[1].equals(allele)) continue;
                int n = m;
                values[n] = values[n] + 1.0;
            }
        } else {
            Pattern nuc = Pattern.compile("[RSYWKM0]");
            for (int m = 0; m < nmarkers; ++m) {
                String markerval = (String)marker[m];
                if (markerval.equals(allele)) {
                    values[m] = 2.0;
                    continue;
                }
                if (nuc.matcher((String)marker[m]).matches()) {
                    values[m] = 1.0;
                    continue;
                }
                marker[m] = 0;
            }
        }
        return values;
    }
}

