/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Utils;

public class TaxaListIOUtils {
    private TaxaListIOUtils() {
    }

    public static Multimap<String, Taxon> getMapOfTaxonByAnnotation(TaxaList taxaList, String annotation) {
        ImmutableMultimap.Builder annoMap = new ImmutableMultimap.Builder().orderKeysBy((Comparator)Ordering.natural());
        for (Taxon taxon : taxaList) {
            for (String value : taxon.getTextAnnotation(annotation)) {
                annoMap.put((Object)value, (Object)taxon);
            }
        }
        return annoMap.build();
    }

    public static TaxaList subsetTaxaListByAnnotation(TaxaList baseTaxaList, String annotation, String annoValue) {
        TaxaListBuilder tlb = new TaxaListBuilder();
        block0: for (Taxon taxon : baseTaxaList) {
            for (String value : taxon.getTextAnnotation(annotation)) {
                if (!value.equals(annoValue)) continue;
                tlb.add(taxon);
                continue block0;
            }
        }
        return tlb.build();
    }

    public static TaxaList retainSpecificAnnotations(TaxaList baseTaxaList, String[] annotationsToKeep) {
        ImmutableSet keepers = new ImmutableSet.Builder().addAll(Arrays.asList(annotationsToKeep)).build();
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (Taxon taxon : baseTaxaList) {
            Taxon.Builder tb = new Taxon.Builder(taxon.getName());
            for (Map.Entry<String, String> entry : taxon.getAllAnnotationEntries()) {
                if (!keepers.contains(entry.getKey())) continue;
                tb.addAnno(entry.getKey(), entry.getValue());
            }
            tlb.add(tb.build());
        }
        return tlb.build();
    }

    public static TaxaList removeSpecificAnnotations(TaxaList baseTaxaList, String[] annotationsToRemove) {
        ImmutableSet keepers = new ImmutableSet.Builder().addAll(Arrays.asList(annotationsToRemove)).build();
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (Taxon taxon : baseTaxaList) {
            Taxon.Builder tb = new Taxon.Builder(taxon.getName());
            for (Map.Entry<String, String> entry : taxon.getAllAnnotationEntries()) {
                if (keepers.contains(entry.getKey())) continue;
                tb.addAnno(entry.getKey(), entry.getValue());
            }
            tlb.add(tb.build());
        }
        return tlb.build();
    }

    public static Set<String> allAnnotationKeys(TaxaList baseTaxaList) {
        ImmutableSet.Builder keepers = new ImmutableSet.Builder();
        for (Taxon taxon : baseTaxaList) {
            for (Map.Entry<String, String> entry : taxon.getAllAnnotationEntries()) {
                keepers.add((Object)entry.getKey());
            }
        }
        return keepers.build();
    }

    public static void exportAnnotatedTaxaListTable() {
    }

    public static TaxaList readTaxaAnnotationFile(String fileName, String taxaNameField, Map<String, String> filters, boolean mergeSameNames) {
        try {
            BufferedReader fileIn = Utils.getBufferedReader(fileName, 1000000);
            fileIn.mark(65536);
            String line = fileIn.readLine();
            TaxaListBuilder tlb = new TaxaListBuilder();
            int indexOfName = 0;
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<Boolean> isQuant = new ArrayList<Boolean>();
            if (line.contains(taxaNameField)) {
                int i = 0;
                for (String header : line.split("\\t")) {
                    if (header.equals(taxaNameField)) {
                        indexOfName = i;
                    }
                    isQuant.add(header.startsWith("#") || header.startsWith("<#"));
                    headers.add(header.replace(">", "").replace("<", "").replace("#", ""));
                    ++i;
                }
            } else {
                fileIn.reset();
            }
            while ((line = fileIn.readLine()) != null) {
                String[] s = line.split("\\t");
                Taxon.Builder anID = new Taxon.Builder(s[indexOfName]);
                for (int i = 0; i < s.length; ++i) {
                    String[] cs;
                    if (i == indexOfName) continue;
                    for (String ta : cs = s[i].split(";")) {
                        if (ta == null || ta.isEmpty()) continue;
                        if (((Boolean)isQuant.get(i)).booleanValue()) {
                            if (ta.equals("NA")) {
                                anID.addAnno((String)headers.get(i), Double.NaN);
                                continue;
                            }
                            anID.addAnno((String)headers.get(i), Double.parseDouble(ta));
                            continue;
                        }
                        anID.addAnno((String)headers.get(i), ta);
                    }
                }
                Taxon t = anID.build();
                if (!TaxaListIOUtils.doesTaxonHaveAllAnnotations(t, filters)) continue;
                if (mergeSameNames) {
                    tlb.addOrMerge(t);
                    continue;
                }
                tlb.add(t);
            }
            return tlb.build();
        }
        catch (Exception e) {
            System.err.println("Error in Reading Annotated Taxon File:" + fileName);
            e.printStackTrace();
            return null;
        }
    }

    public static TaxaList readTaxaAnnotationFile(String fileName, String taxaNameField) {
        return TaxaListIOUtils.readTaxaAnnotationFile(fileName, taxaNameField, new HashMap<String, String>(), false);
    }

    public static boolean doesTaxonHaveAllAnnotations(Taxon taxon, Map<String, String> filters) {
        SetMultimap<String, String> taxonAnno = taxon.getAnnotationAsMap();
        boolean keep = true;
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            keep = false;
            for (String s1 : taxonAnno.get((Object)entry.getKey())) {
                if (!s1.equals(entry.getValue())) continue;
                keep = true;
            }
            if (keep) continue;
            break;
        }
        return keep;
    }

    public static SetMultimap<String, String> parseVCFHeadersIntoMap(String s) {
        if (s == null) {
            return null;
        }
        if (!s.startsWith("<") || !s.endsWith(">")) {
            return null;
        }
        String value = s.substring(1, s.length() - 1);
        ImmutableSetMultimap.Builder im = new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
        for (String s1 : Splitter.on((String)",").trimResults().split((CharSequence)value)) {
            String[] ssEntry = s1.split("=", 2);
            im.put((Object)ssEntry[0], (Object)ssEntry[1]);
        }
        return im.build();
    }
}

