/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import java.util.ArrayList;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.TableReport;

public class TaxaListTableReport
implements TableReport {
    private static final String[] DEFAULT_COLUMN_HEADINGS = new String[]{"Taxa", "Name"};
    private final TaxaList myTaxaList;
    private final String[] myColumnHeadings;

    public TaxaListTableReport(TaxaList taxaList) {
        this.myTaxaList = taxaList;
        ArrayList<String> annotationColumns = new ArrayList<String>();
        for (Taxon current : this.myTaxaList) {
            for (String key : current.getAnnotationAsMap().keySet()) {
                if (annotationColumns.contains(key)) continue;
                annotationColumns.add(key);
            }
        }
        int totalHeadings = DEFAULT_COLUMN_HEADINGS.length + annotationColumns.size();
        this.myColumnHeadings = new String[totalHeadings];
        for (int i = 0; i < DEFAULT_COLUMN_HEADINGS.length; ++i) {
            this.myColumnHeadings[i] = DEFAULT_COLUMN_HEADINGS[i];
        }
        for (int j = DEFAULT_COLUMN_HEADINGS.length; j < totalHeadings; ++j) {
            this.myColumnHeadings[j] = (String)annotationColumns.get(j - DEFAULT_COLUMN_HEADINGS.length);
        }
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.myColumnHeadings;
    }

    @Override
    public String getTableTitle() {
        return "Taxa List";
    }

    @Override
    public int getColumnCount() {
        return this.myColumnHeadings.length;
    }

    @Override
    public long getRowCount() {
        return this.myTaxaList.numberOfTaxa();
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(long row) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object getValueAt(long row, int col) {
        switch (col) {
            case 0: {
                return ((Taxon)this.myTaxaList.get((int)row)).getName();
            }
            case 1: {
                return ((Taxon)this.myTaxaList.get((int)row)).getName();
            }
        }
        String[] annotations = ((Taxon)this.myTaxaList.get((int)row)).getTextAnnotation(this.myColumnHeadings[col]);
        if (annotations != null) {
            return annotations[0];
        }
        return null;
    }
}

