/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.GeneralAnnotationUtils;

public class Taxon
implements Serializable,
Comparable<Taxon>,
GeneralAnnotation {
    private static final long serialVersionUID = -7873729831795750538L;
    public static final String DELIMITER = ":";
    public static Taxon ANONYMOUS = new Taxon("");
    public static final String FatherKey = "FATHER";
    public static final String MotherKey = "MOTHER";
    public static final String PedigreeKey = "PEDIGREE";
    public static final String SexKey = "SEX";
    public static final String InbreedFKey = "INBREEDF";
    public static final String SynonymKey = "SYNONYM";
    public static final String LatitudeKey = "LATITUDE";
    public static final String LongitudeKey = "LONGITUDE";
    public static final String AltitudeKey = "ALTITUDE";
    public static final String GenusKey = "GENUS";
    public static final String SpeciesKey = "SPECIES";
    private final Map.Entry<String, String>[] myAnno;
    private final String myName;
    private final int hashCode;
    private static final ConcurrentMap<Map.Entry<String, String>, Map.Entry<String, String>> TAXON_ANNO_HASH = new ConcurrentHashMap<Map.Entry<String, String>, Map.Entry<String, String>>(1000000);

    private static Map.Entry<String, String> getCanonicalAnnotation(String key, String value) {
        AbstractMap.SimpleImmutableEntry<String, String> str;
        Map.Entry canon;
        if (TAXON_ANNO_HASH.size() > 1000000) {
            TAXON_ANNO_HASH.clear();
        }
        return (canon = (Map.Entry)TAXON_ANNO_HASH.putIfAbsent(str = new AbstractMap.SimpleImmutableEntry<String, String>(key, value), str)) == null ? str : canon;
    }

    public Taxon(String name) {
        this(new Builder(name));
    }

    private Taxon(Builder builder) {
        this.myName = builder.myTaxonName;
        this.hashCode = this.myName.hashCode();
        this.myAnno = new Map.Entry[builder.myAnnotations.size()];
        for (int i = 0; i < builder.myAnnotations.size(); ++i) {
            this.myAnno[i] = (Map.Entry)builder.myAnnotations.get(i);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String toStringWithVCFAnnotation() {
        StringBuilder sb = new StringBuilder("<");
        sb.append("ID=" + this.getName() + ",");
        for (Map.Entry<String, String> en : this.myAnno) {
            sb.append(en.getKey() + "=" + en.getValue() + ",");
        }
        if (this.myAnno.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Taxon c) {
        if (this == c) {
            return 0;
        }
        return this.myName.compareTo(c.getName());
    }

    public boolean equals(Object c) {
        if (this == c) {
            return true;
        }
        if (c instanceof Taxon) {
            return this.myName.equals(((Taxon)c).getName());
        }
        if (c instanceof String) {
            return this.myName.equals((String)c);
        }
        return false;
    }

    public String getName() {
        return this.myName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object[] getAnnotation(String annoName) {
        return GeneralAnnotationUtils.getAnnotation(this.myAnno, annoName);
    }

    @Override
    public String[] getTextAnnotation(String annoName) {
        return GeneralAnnotationUtils.getTextAnnotation(this.myAnno, annoName);
    }

    @Override
    public double[] getQuantAnnotation(String annoName) {
        return GeneralAnnotationUtils.getQuantAnnotation(this.myAnno, annoName);
    }

    @Override
    public String getConsensusAnnotation(String annoName) {
        return GeneralAnnotationUtils.getConsensusAnnotation(this.myAnno, annoName);
    }

    @Override
    public double getAverageAnnotation(String annoName) {
        return GeneralAnnotationUtils.getAverageAnnotation(this.myAnno, annoName);
    }

    @Override
    public Map.Entry<String, String>[] getAllAnnotationEntries() {
        return Arrays.copyOf(this.myAnno, this.myAnno.length);
    }

    @Override
    public SetMultimap<String, String> getAnnotationAsMap() {
        ImmutableSetMultimap.Builder result = new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
        for (Map.Entry<String, String> en : this.myAnno) {
            result.put((Object)en.getKey(), (Object)en.getValue());
        }
        return result.build();
    }

    @Override
    public boolean isAnnotatedWithValue(String annoName, String annoValue) {
        return GeneralAnnotationUtils.isAnnotatedWithValue(this.myAnno, annoName, annoValue);
    }

    public static class Builder {
        private String myTaxonName;
        private ArrayList<Map.Entry<String, String>> myAnnotations = new ArrayList(0);

        public Builder(Taxon aTaxon) {
            this.myTaxonName = aTaxon.getName();
            for (Map.Entry<String, String> entry : aTaxon.getAllAnnotationEntries()) {
                this.myAnnotations.add(entry);
            }
        }

        public Builder(String aTaxonName) {
            this.myTaxonName = aTaxonName;
        }

        public Builder addAnno(String key, String value) {
            Map.Entry ent = Taxon.getCanonicalAnnotation(key, value);
            this.myAnnotations.add(ent);
            return this;
        }

        public Builder addAnno(String key, Number value) {
            Map.Entry ent = Taxon.getCanonicalAnnotation(key, value.toString());
            this.myAnnotations.add(ent);
            return this;
        }

        public Builder name(String newName) {
            this.myTaxonName = newName;
            return this;
        }

        public Builder sex(byte val) {
            return this.addAnno(Taxon.SexKey, val);
        }

        public Builder inbreedF(float val) {
            return this.addAnno(Taxon.InbreedFKey, Float.valueOf(val));
        }

        public Builder parents(String mom, String dad) {
            this.addAnno(Taxon.MotherKey, mom);
            return this.addAnno(Taxon.FatherKey, dad);
        }

        public Builder pedigree(String val) {
            return this.addAnno(Taxon.PedigreeKey, val);
        }

        public Builder synonym(String val) {
            return this.addAnno(Taxon.SynonymKey, val);
        }

        public Taxon build() {
            Collections.sort(this.myAnnotations, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> s1, Map.Entry<String, String> s2) {
                    int keyComp = s1.getKey().compareTo(s2.getKey());
                    if (keyComp != 0) {
                        return keyComp;
                    }
                    return s1.getValue().compareTo(s2.getValue());
                }
            });
            return new Taxon(this);
        }
    }
}

