/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.distance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.TaxaListMatrix;
import net.maizegenetics.util.FormattedOutput;
import net.maizegenetics.util.TableReport;

public class DistanceMatrix
implements TaxaListMatrix,
TableReport {
    private TaxaList taxaList;
    private double[][] distance = null;
    static final long serialVersionUID = 4725925229860707633L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.taxaList);
        out.writeObject(this.distance);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.taxaList = (TaxaList)in.readObject();
        this.distance = (double[][])in.readObject();
    }

    public DistanceMatrix() {
    }

    public DistanceMatrix(double[][] distance, TaxaList taxaList) {
        this.distance = distance;
        this.taxaList = taxaList;
    }

    public DistanceMatrix(DistanceMatrix dm) {
        double[][] copy = new double[dm.distance.length][];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = new double[dm.distance[i].length];
            System.arraycopy(dm.distance[i], 0, copy[i], 0, dm.distance[i].length);
        }
        this.distance = copy;
        this.taxaList = dm.taxaList;
    }

    public DistanceMatrix(DistanceMatrix dm, TaxaList subset) {
        this.distance = new double[subset.numberOfTaxa()][subset.numberOfTaxa()];
        for (int i = 0; i < this.distance.length; ++i) {
            int index1 = dm.whichIdNumber(subset.taxaName(i));
            this.distance[i][i] = dm.distance[index1][index1];
            for (int j = 0; j < i; ++j) {
                int index2 = dm.whichIdNumber(subset.taxaName(j));
                this.distance[i][j] = dm.distance[index1][index2];
                this.distance[j][i] = this.distance[i][j];
            }
        }
        this.taxaList = subset;
    }

    public void printPHYLIP(PrintWriter out) {
        out.println("  " + this.distance.length);
        FormattedOutput format = FormattedOutput.getInstance();
        for (int i = 0; i < this.distance.length; ++i) {
            format.displayLabel(out, this.taxaList.taxaName(i), 10);
            out.print("      ");
            for (int j = 0; j < this.distance.length; ++j) {
                if (j % 6 == 0 && j != 0) {
                    out.println();
                    out.print("                ");
                }
                out.print("  ");
                format.displayDecimal(out, this.distance[i][j], 5);
            }
            out.println();
        }
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        this.printPHYLIP(new PrintWriter(sw));
        return sw.toString();
    }

    public double squaredDistance(DistanceMatrix mat, boolean weighted) {
        double sum = 0.0;
        for (int i = 0; i < this.distance.length - 1; ++i) {
            for (int j = i + 1; j < this.distance.length; ++j) {
                double diff = this.distance[i][j] - mat.distance[i][j];
                double weight = weighted ? 1.0 / (this.distance[i][j] * this.distance[i][j]) : 1.0;
                sum += weight * diff * diff;
            }
        }
        return 2.0 * sum;
    }

    public double absoluteDistance(DistanceMatrix mat) {
        double sum = 0.0;
        for (int i = 0; i < this.distance.length - 1; ++i) {
            for (int j = i + 1; j < this.distance.length; ++j) {
                double diff = Math.abs(this.distance[i][j] - mat.distance[i][j]);
                sum += diff;
            }
        }
        return 2.0 * sum;
    }

    @Override
    public int getSize() {
        return this.distance.length;
    }

    @Override
    public final double[][] getClonedDistances() {
        double[][] copy = new double[this.distance.length][];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = new double[this.distance[i].length];
            System.arraycopy(this.distance[i], 0, copy[i], 0, this.distance[i].length);
        }
        return copy;
    }

    public final double[][] getDistances() {
        return this.getClonedDistances();
    }

    @Override
    public final double getDistance(int row, int col) {
        return this.distance[row][col];
    }

    public void setDistance(int i, int j, double dist) {
        double d = dist;
        this.distance[j][i] = d;
        this.distance[i][j] = d;
    }

    public void addDistance(int i, int j, double delta) {
        double[] dArray = this.distance[i];
        int n = j;
        dArray[n] = dArray[n] + delta;
        double[] dArray2 = this.distance[j];
        int n2 = i;
        dArray2[n2] = dArray2[n2] + delta;
    }

    @Override
    public double meanDistance() {
        double dist = 0.0;
        int count = 0;
        for (int i = 0; i < this.distance.length; ++i) {
            for (int j = 0; j < this.distance[i].length; ++j) {
                if (i == j || Double.isNaN(this.distance[i][j])) continue;
                dist += this.distance[i][j];
                ++count;
            }
        }
        return dist / (double)count;
    }

    public Taxon getTaxon(int i) {
        return (Taxon)this.taxaList.get(i);
    }

    public int numberOfTaxa() {
        return this.taxaList.numberOfTaxa();
    }

    public int whichIdNumber(String name) {
        return this.taxaList.indexOf(name);
    }

    public int whichIdNumber(Taxon id) {
        return this.taxaList.indexOf(id);
    }

    @Override
    public TaxaList getTaxaList() {
        return this.taxaList;
    }

    @Override
    public boolean isSymmetric() {
        int i;
        for (i = 0; i < this.distance.length; ++i) {
            if (this.distance[i][i] == 0.0) continue;
            return false;
        }
        for (i = 0; i < this.distance.length - 1; ++i) {
            for (int j = i + 1; j < this.distance.length; ++j) {
                if (this.distance[i][j] == this.distance[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean isIn(int value, int[] set) {
        if (set == null) {
            return false;
        }
        for (int i = 0; i < set.length; ++i) {
            if (set[i] != value) continue;
            return true;
        }
        return false;
    }

    public int getClosestIndex(int fromIndex, int[] exclusion) {
        double min = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < this.distance.length; ++i) {
            double d;
            if (i == fromIndex || this.isIn(i, exclusion) || !((d = this.distance[fromIndex][i]) < min)) continue;
            min = d;
            index = i;
        }
        return index;
    }

    @Deprecated
    protected final void setIdGroup(TaxaList base) {
        this.taxaList = base;
    }

    @Deprecated
    protected final void setDistances(double[][] matrix) {
        this.distance = matrix;
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] colNames = new String[this.getSize() + 1];
        colNames[0] = "Taxa";
        for (int i = 0; i < this.distance[0].length; ++i) {
            colNames[i + 1] = this.getTaxon(i).toString();
        }
        return colNames;
    }

    @Override
    public Object[] getRow(long rowLong) {
        int row = (int)rowLong;
        Object[] result = new Object[this.distance[row].length + 1];
        result[0] = this.getTaxon(row);
        for (int j = 1; j <= this.distance[row].length; ++j) {
            result[j] = "" + this.distance[row][j - 1];
        }
        return result;
    }

    @Override
    public String getTableTitle() {
        return "Alignment Distance Matrix";
    }

    @Override
    public long getRowCount() {
        if (this.distance != null) {
            return this.distance.length;
        }
        return 0L;
    }

    @Override
    public long getElementCount() {
        return this.getRowCount() * (long)this.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        if (this.distance != null && this.distance[0] != null) {
            return this.distance[0].length + 1;
        }
        return 0;
    }

    @Override
    public Object getValueAt(long rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getTaxon((int)rowIndex);
        }
        return new Double(this.distance[(int)rowIndex][columnIndex - 1]);
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "Taxa";
        }
        return this.getTaxon(col - 1).toString();
    }
}

