/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.maizegenetics.taxa.IdGroupUtils;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.Trait;

public abstract class AbstractPhenotype
implements Phenotype {
    private String[] factors;
    private boolean[] useFactor;
    private TaxaList taxa;
    private List<Trait> traitList;

    public AbstractPhenotype(TaxaList taxa, List<Trait> traitList) {
        this.taxa = taxa;
        this.traitList = traitList;
        this.init();
    }

    public AbstractPhenotype(TaxaList taxa, List<Trait> traitList, String[] factors, boolean[] useFactor) {
        this.taxa = taxa;
        this.traitList = traitList;
        this.factors = factors;
        this.useFactor = useFactor;
    }

    private void init() {
        LinkedHashSet<String> factorList = new LinkedHashSet<String>();
        for (Trait trait : this.traitList) {
            ArrayList<String> theseFactors = trait.getFactorNames();
            if (theseFactors == null) continue;
            factorList.addAll(theseFactors);
        }
        int n = factorList.size();
        this.factors = new String[n];
        this.useFactor = new boolean[n];
        if (n > 0) {
            factorList.toArray(this.factors);
        }
        for (int i = 0; i < n; ++i) {
            this.useFactor[i] = true;
        }
    }

    @Override
    public String getActiveFactorName(int factor) {
        int active = -1;
        int n = this.factors.length;
        for (int count = 0; count < n; ++count) {
            if (this.useFactor[count]) {
                ++active;
            }
            if (factor != active) continue;
            return this.factors[count];
        }
        return null;
    }

    @Override
    public String[] getActiveFactorNames() {
        int n = this.getNumberOfActiveFactors();
        String[] names = new String[n];
        int count = 0;
        int activeCount = 0;
        for (String name : this.factors) {
            if (!this.useFactor[count++]) continue;
            names[activeCount++] = name;
        }
        return names;
    }

    @Override
    public String getFactorName(int factor) {
        return this.factors[factor];
    }

    @Override
    public String[] getFactorNameCopy() {
        String[] names = new String[this.factors.length];
        System.arraycopy(this.factors, 0, names, 0, names.length);
        return names;
    }

    @Override
    public int getNumberOfActiveFactors() {
        int count = 0;
        for (boolean active : this.useFactor) {
            if (!active) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getNumberOfFactors() {
        return this.factors.length;
    }

    @Override
    public int getNumberOfTaxa() {
        return this.taxa.numberOfTaxa();
    }

    @Override
    public int getNumberOfTraits() {
        return this.traitList.size();
    }

    @Override
    public TaxaList getTaxa() {
        return this.taxa;
    }

    @Override
    public Taxon getTaxon(int taxon) {
        return (Taxon)this.taxa.get(taxon);
    }

    @Override
    public Trait getTrait(int trait) {
        return this.traitList.get(trait);
    }

    @Override
    public List<Trait> getTraits() {
        return this.traitList;
    }

    @Override
    public boolean isFactorActive(int factor) {
        return this.useFactor[factor];
    }

    @Override
    public void setActiveFactor(int factor, boolean active) {
        this.useFactor[factor] = active;
    }

    @Override
    public int whichTaxon(Taxon taxon) {
        return this.taxa.indexOf(taxon);
    }

    @Override
    public int whichTrait(Trait trait) {
        return this.traitList.indexOf(trait);
    }

    public static List<Trait> copyTraitsFromPhenotype(Phenotype phenotype) {
        ArrayList<Trait> newTraitList = new ArrayList<Trait>();
        for (Trait t : phenotype.getTraits()) {
            newTraitList.add(t);
        }
        return newTraitList;
    }

    @Override
    public void report(PrintWriter out) {
    }

    @Override
    public int getColumnCount() {
        return this.traitList.size() + 1;
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }

    @Override
    public long getRowCount() {
        return this.taxa.numberOfTaxa();
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] names = new String[this.getColumnCount()];
        int nTraits = this.getNumberOfTraits();
        names[0] = "Taxa";
        for (int i = 0; i < nTraits; ++i) {
            names[i + 1] = this.traitList.get(i).toString();
        }
        return names;
    }

    @Override
    public String getTableTitle() {
        String title = "Phenotypes";
        return title;
    }

    @Override
    public Object[] getRow(long rowLong) {
        int row = (int)rowLong;
        int n = this.getColumnCount();
        Object[] rowvalues = new Object[n];
        rowvalues[0] = this.getTaxon(row);
        for (int i = 1; i < n; ++i) {
            Trait trait = this.getTrait(i - 1);
            if (trait.isDiscrete()) {
                String[] labels = (String[])trait.getProperty("level_labels");
                double dblval = this.getData(row, i - 1);
                if (Double.isNaN(dblval)) {
                    rowvalues[i] = "?";
                    continue;
                }
                rowvalues[i] = labels[(int)dblval];
                continue;
            }
            rowvalues[i] = this.getData(row, i - 1);
        }
        return rowvalues;
    }

    @Override
    public String[] getRowNames() {
        return IdGroupUtils.getNames(this.getTaxa());
    }

    @Override
    public Object getValueAt(long rowLong, int col) {
        Trait trait;
        int row = (int)rowLong;
        if (col == 0) {
            return this.getTaxon(row);
        }
        if ((trait = this.traitList.get(--col)).isDiscrete()) {
            double dblval = this.getData(row, col);
            if (Double.isNaN(dblval)) {
                return "?";
            }
            return trait.getLevelLabel((int)dblval);
        }
        return new Double(this.getData(row, col));
    }
}

