/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.AbstractPhenotype;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;

public class FilterPhenotype
extends AbstractPhenotype {
    private Phenotype thePhenotype;
    private int[] taxaIndex = null;
    private int[] traitIndex = null;
    private int numberOfRows = 0;
    private int numberOfColumns = 0;

    private FilterPhenotype(Phenotype phenotype, int[] taxa, TaxaList taxaGroup, int[] traits, List<Trait> traitList) {
        super(taxaGroup, traitList);
        this.thePhenotype = phenotype;
        this.taxaIndex = taxa;
        this.traitIndex = traits;
        this.numberOfRows = taxa.length;
        this.numberOfColumns = traits.length;
    }

    public static FilterPhenotype getInstance(Phenotype phenotype, int[] taxa, int[] traits) {
        List<Trait> traitList;
        int i;
        int n;
        TaxaList taxaGroup;
        if (taxa == null) {
            taxaGroup = phenotype.getTaxa();
            n = taxaGroup.numberOfTaxa();
            taxa = new int[n];
            for (i = 0; i < n; ++i) {
                taxa[i] = i;
            }
        } else {
            n = taxa.length;
            Taxon[] ids = new Taxon[n];
            for (int i2 = 0; i2 < n; ++i2) {
                ids[i2] = phenotype.getTaxon(taxa[i2]);
            }
            taxaGroup = new TaxaListBuilder().addAll(ids).build();
        }
        if (traits == null) {
            traitList = FilterPhenotype.copyTraitsFromPhenotype(phenotype);
            n = traitList.size();
            traits = new int[n];
            for (i = 0; i < n; ++i) {
                traits[i] = i;
            }
        } else {
            traitList = new ArrayList<Trait>();
            for (int t : traits) {
                traitList.add(Trait.getInstance(phenotype.getTrait(t)));
            }
        }
        return new FilterPhenotype(phenotype, taxa, taxaGroup, traits, traitList);
    }

    public static FilterPhenotype getInstance(Phenotype phenotype, TaxaList taxa, List<Trait> traits) {
        int[] traitIndex;
        List<Trait> traitList;
        int i;
        int[] taxaIndex;
        int n;
        TaxaList taxaGroup;
        if (taxa == null) {
            taxaGroup = phenotype.getTaxa();
            n = taxaGroup.numberOfTaxa();
            taxaIndex = new int[n];
            for (i = 0; i < n; ++i) {
                taxaIndex[i] = i;
            }
        } else {
            taxaGroup = taxa;
            n = taxaGroup.numberOfTaxa();
            taxaIndex = new int[n];
            for (i = 0; i < n; ++i) {
                taxaIndex[i] = phenotype.whichTaxon((Taxon)taxaGroup.get(i));
            }
        }
        if (traits == null) {
            traitList = FilterPhenotype.copyTraitsFromPhenotype(phenotype);
            n = traitList.size();
            traitIndex = new int[n];
            for (i = 0; i < n; ++i) {
                traitIndex[i] = i;
            }
        } else {
            traitList = traits;
            n = traitList.size();
            traitIndex = new int[n];
            for (i = 0; i < n; ++i) {
                traitIndex[i] = phenotype.whichTrait(traitList.get(i));
            }
        }
        return new FilterPhenotype(phenotype, taxaIndex, taxaGroup, traitIndex, traitList);
    }

    public static FilterPhenotype getInstanceRemoveIDs(Phenotype phenotype, TaxaList taxa) {
        TaxaListBuilder result = new TaxaListBuilder();
        TaxaList current = phenotype.getTaxa();
        int n = current.numberOfTaxa();
        for (int i = 0; i < n; ++i) {
            if (taxa.indexOf((Taxon)current.get(i)) > 0) continue;
            result.add((Taxon)current.get(i));
        }
        return FilterPhenotype.getInstance(phenotype, result.build(), null);
    }

    @Override
    public double getData(int taxon, int trait) {
        if (taxon == -1 || trait == -1) {
            return Double.NaN;
        }
        int taxonNdx = this.taxaIndex[taxon];
        int traitNdx = this.traitIndex[trait];
        if (taxonNdx < 0 || taxonNdx >= this.thePhenotype.getNumberOfTaxa()) {
            return Double.NaN;
        }
        if (traitNdx < 0 || traitNdx >= this.thePhenotype.getNumberOfTraits()) {
            return Double.NaN;
        }
        return this.thePhenotype.getData(this.taxaIndex[taxon], this.traitIndex[trait]);
    }

    @Override
    public double getData(Taxon taxon, Trait trait) {
        return this.thePhenotype.getData(this.whichTaxon(taxon), this.whichTrait(trait));
    }

    @Override
    public double[][] getData() {
        double[][] result = new double[this.numberOfRows][this.numberOfColumns];
        for (int r = 0; r < this.numberOfRows; ++r) {
            for (int c = 0; c < this.numberOfColumns; ++c) {
                result[r][c] = this.getData(r, c);
            }
        }
        return result;
    }

    @Override
    public void setData(int taxon, int trait, double value) {
        this.thePhenotype.setData(this.taxaIndex[taxon], this.traitIndex[trait], value);
    }

    public void setData(Taxon taxon, Trait trait, double value) {
        this.setData(this.whichTaxon(taxon), this.whichTrait(trait), value);
    }

    public SimplePhenotype simpleCopy() {
        return new SimplePhenotype(this.getTaxa(), this.getTraits(), this.getData());
    }
}

