/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.Trait;

public class PhenotypeUtils {
    private PhenotypeUtils() {
    }

    public static List<Trait> getListofType(Phenotype pheno, String traitType) {
        ArrayList<Trait> traitList = new ArrayList<Trait>();
        int ntraits = pheno.getNumberOfTraits();
        for (int t = 0; t < ntraits; ++t) {
            Trait trait = pheno.getTrait(t);
            if (!trait.getType().equals(traitType)) continue;
            traitList.add(trait);
        }
        return traitList;
    }

    public static boolean areMarkersConsistentForDiscreteness(Phenotype pheno) {
        int ntraits = pheno.getNumberOfTraits();
        ArrayList<Boolean> discreteList = new ArrayList<Boolean>();
        for (int t = 0; t < ntraits; ++t) {
            Trait trait = pheno.getTrait(t);
            if (!trait.getType().equals("marker")) continue;
            discreteList.add(trait.isDiscrete());
        }
        int nmarkers = discreteList.size();
        Iterator it = discreteList.iterator();
        Boolean discrete = (Boolean)it.next();
        boolean consistent = true;
        while (it.hasNext() && consistent) {
            if (discrete.equals(it.next())) continue;
            consistent = false;
        }
        return consistent;
    }

    public static boolean areMarkersConsistentForPloidy(Phenotype pheno) {
        Pattern colon = Pattern.compile(":");
        List<Trait> markerList = PhenotypeUtils.getListofType(pheno, "marker");
        if (!markerList.get(0).isDiscrete()) {
            return true;
        }
        String firstlabel = markerList.get(0).getLevelLabel(0);
        int nalleles = colon.split(firstlabel).length;
        boolean consistent = true;
        Iterator<Trait> it = markerList.iterator();
        while (it.hasNext() && consistent) {
            for (String label : it.next().getLevelLabels()) {
                if (nalleles == colon.split(label).length) continue;
                consistent = false;
            }
        }
        return consistent;
    }

    public static void saveAs(Phenotype pheno, PrintWriter pw) {
        int t;
        StringBuilder sb;
        String sep = "\t";
        int nheaders = pheno.getNumberOfFactors();
        int ntraits = pheno.getNumberOfTraits();
        int ntaxa = pheno.getNumberOfTaxa();
        for (int h = 0; h < nheaders; ++h) {
            sb = new StringBuilder("<Header name=");
            String factorName = pheno.getFactorName(h);
            sb.append(factorName).append(">");
            for (int t2 = 0; t2 < ntraits; ++t2) {
                sb.append(sep).append(pheno.getTrait(t2).getFactorValue(factorName));
            }
            pw.println(sb.toString());
        }
        sb = new StringBuilder("<Use>");
        for (t = 0; t < ntraits; ++t) {
            sb.append(sep).append(pheno.getTrait(t).getType());
        }
        pw.println(sb.toString());
        sb = new StringBuilder("<Format>");
        for (t = 0; t < ntraits; ++t) {
            sb.append(sep);
            if (pheno.getTrait(t).isDiscrete()) {
                sb.append("char");
                continue;
            }
            sb.append("num");
        }
        pw.println(sb.toString());
        sb = new StringBuilder("<Trait>");
        for (t = 0; t < ntraits; ++t) {
            sb.append(sep).append(pheno.getTrait(t).getName());
        }
        pw.println(sb.toString());
        long nrows = pheno.getRowCount();
        int ncol = pheno.getColumnCount();
        for (long r = 0L; r < nrows; ++r) {
            sb = new StringBuilder(pheno.getValueAt(r, 0).toString());
            for (int c = 1; c < ncol; ++c) {
                sb.append(sep).append(pheno.getValueAt(r, c));
            }
            pw.println(sb.toString());
        }
    }
}

