/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import java.util.List;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.AbstractPhenotype;
import net.maizegenetics.trait.Trait;

public class SimplePhenotype
extends AbstractPhenotype {
    private DoubleMatrix2D data;

    public SimplePhenotype(TaxaList taxa, List<Trait> traits, DoubleMatrix2D data) {
        super(taxa, traits);
        this.data = data;
    }

    public SimplePhenotype(TaxaList taxa, List<Trait> traits, double[][] data) {
        super(taxa, traits);
        this.data = DoubleFactory2D.dense.make(data);
    }

    public SimplePhenotype(TaxaList taxa, List<Trait> traits) {
        super(taxa, traits);
        this.data = DoubleFactory2D.dense.make(this.getNumberOfTaxa(), this.getNumberOfTraits(), Double.NaN);
    }

    @Override
    public double getData(int taxon, int trait) {
        return this.data.get(taxon, trait);
    }

    @Override
    public double getData(Taxon taxon, Trait trait) {
        return this.getData(this.whichTaxon(taxon), this.whichTrait(trait));
    }

    @Override
    public double[][] getData() {
        return this.data.toArray();
    }

    @Override
    public void setData(int taxon, int trait, double value) {
        this.data.set(taxon, trait, value);
    }

    public void setData(Taxon taxon, Trait trait, double value) {
        this.data.set(this.whichTaxon(taxon), this.whichTrait(trait), value);
    }
}

