/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.InputStream;
import java.security.MessageDigest;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class CheckSum {
    private static final Logger myLogger = Logger.getLogger(CheckSum.class);

    private CheckSum() {
    }

    public static String getMD5Checksum(String filename) {
        return CheckSum.getChecksum(filename, "MD5");
    }

    public static String getChecksum(String filename, String protocol) {
        try {
            int numOfBytesRead;
            InputStream inputStream = Utils.getInputStream(filename);
            MessageDigest digester = MessageDigest.getInstance(protocol);
            byte[] buffer = new byte[8192];
            while ((numOfBytesRead = inputStream.read(buffer)) > 0) {
                digester.update(buffer, 0, numOfBytesRead);
            }
            byte[] hashValue = digester.digest();
            return CheckSum.convertBytesToHex(hashValue);
        }
        catch (Exception ex) {
            myLogger.error((Object)ex.getMessage());
            return null;
        }
    }

    private static String convertBytesToHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            builder.append(String.format("%02x", bytes[i] & 0xFF));
        }
        return builder.toString();
    }
}

