/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import net.maizegenetics.util.Graph;
import net.maizegenetics.util.Tuple;

public final class GraphUtils<T> {
    public static <T> Tuple<ArrayList<Tuple<T, T>>, ArrayList<Byte>> dfsLabeledEdges(Graph<T> G, T source) {
        HashSet<Object> visited = new HashSet<Object>();
        ArrayList<Tuple<Object, Object>> edges = new ArrayList<Tuple<Object, Object>>();
        ArrayList<Byte> directions = new ArrayList<Byte>();
        edges.add(new Tuple<T, T>(source, source));
        directions.add((byte)1);
        visited.add(source);
        Stack<Tuple<Object, Iterator<T>>> stack = new Stack<Tuple<Object, Iterator<T>>>();
        stack.push(new Tuple<T, Iterator<T>>(source, G.neighbors(source).iterator()));
        while (!stack.empty()) {
            Tuple toVisit = (Tuple)stack.peek();
            if (((Iterator)toVisit.y).hasNext()) {
                Object child = ((Iterator)toVisit.y).next();
                if (visited.contains(child)) {
                    edges.add(new Tuple(toVisit.x, child));
                    directions.add((byte)0);
                    continue;
                }
                edges.add(new Tuple(toVisit.x, child));
                directions.add((byte)1);
                stack.push(new Tuple(child, G.neighbors(child).iterator()));
                visited.add(child);
                continue;
            }
            stack.pop();
            if (stack.empty()) continue;
            Tuple nextVisit = (Tuple)stack.peek();
            edges.add(new Tuple(nextVisit.x, toVisit.x));
            directions.add((byte)-1);
        }
        edges.add(new Tuple<T, T>(source, source));
        directions.add((byte)-1);
        return new Tuple<ArrayList<Tuple<T, T>>, ArrayList<Byte>>(edges, directions);
    }

    public static <T> ArrayList<T> dfsPreorderNodes(Graph<T> G, T source) {
        Tuple<ArrayList<Tuple<T, T>>, ArrayList<Byte>> dfs = GraphUtils.dfsLabeledEdges(G, source);
        ArrayList pre = new ArrayList();
        for (int i = 0; i < ((ArrayList)dfs.x).size(); ++i) {
            if ((Byte)((ArrayList)dfs.y).get(i) != 1) continue;
            pre.add(((Tuple)((ArrayList)dfs.x).get((int)i)).y);
        }
        return pre;
    }

    public static <T> ArrayList<T> dfsPostorderNodes(Graph<T> G, T source) {
        Tuple<ArrayList<Tuple<T, T>>, ArrayList<Byte>> dfs = GraphUtils.dfsLabeledEdges(G, source);
        ArrayList pre = new ArrayList();
        for (int i = 0; i < ((ArrayList)dfs.x).size(); ++i) {
            if ((Byte)((ArrayList)dfs.y).get(i) != -1) continue;
            pre.add(((Tuple)((ArrayList)dfs.x).get((int)i)).y);
        }
        return pre;
    }
}

