/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Tassel5HDF5Constants;

public final class HDF5Utils {
    private HDF5Utils() {
    }

    public static boolean isTASSEL4HDF5Format(IHDF5Reader reader) {
        return reader.exists("SeqRegion");
    }

    public static void createHDF5TaxaModule(IHDF5Writer h5w) {
        h5w.createGroup("Taxa");
        h5w.setBooleanAttribute("Taxa/", "locked", false);
        h5w.createStringArray("Taxa/TaxaOrder", 256, 0L, 1);
    }

    public static void lockHDF5TaxaModule(IHDF5Writer h5w) {
        h5w.setBooleanAttribute("Taxa/", "locked", true);
    }

    public static void unlockHDF5TaxaModule(IHDF5Writer h5w) {
        h5w.setBooleanAttribute("Taxa/", "locked", false);
    }

    public static boolean doesTaxaModuleExist(IHDF5Reader reader) {
        return reader.exists("Taxa");
    }

    public static boolean doTaxonCallsExist(IHDF5Reader reader, String taxonName) {
        return reader.exists(Tassel5HDF5Constants.getGenotypesCallsPath(taxonName));
    }

    public static boolean doTaxonCallsExist(IHDF5Reader reader, Taxon taxon) {
        return reader.exists(Tassel5HDF5Constants.getGenotypesCallsPath(taxon.getName()));
    }

    public static boolean isTaxaLocked(IHDF5Reader reader) {
        return reader.getBooleanAttribute("Taxa/", "locked");
    }

    public static boolean addTaxon(IHDF5Writer h5w, Taxon taxon) {
        String path;
        if (HDF5Utils.isTaxaLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        if (!h5w.exists("Taxa/TaxaOrder")) {
            HDF5Utils.createTaxaOrder(h5w);
        }
        if (h5w.exists(path = Tassel5HDF5Constants.getTaxonPath(taxon.getName()))) {
            return false;
        }
        h5w.createGroup(path);
        SetMultimap<String, String> annoMap = taxon.getAnnotationAsMap();
        for (String keys : annoMap.keys()) {
            String s = Joiner.on((String)",").join((Iterable)annoMap.get((Object)keys));
            h5w.setStringAttribute(path, keys, s);
        }
        long size = h5w.getDataSetInformation("Taxa/TaxaOrder").getNumberOfElements();
        h5w.writeStringArrayBlockWithOffset("Taxa/TaxaOrder", new String[]{taxon.getName()}, 1, size);
        return true;
    }

    private static void createTaxaOrder(IHDF5Writer h5w) {
        List<String> taxaNames = HDF5Utils.getAllTaxaNames((IHDF5Reader)h5w);
        h5w.createStringArray("Taxa/TaxaOrder", 256, 0L, 1);
        for (int i = 0; i < taxaNames.size(); ++i) {
            h5w.writeStringArrayBlockWithOffset("Taxa/TaxaOrder", new String[]{taxaNames.get(i)}, 1, (long)i);
        }
    }

    public static void replaceTaxonAnnotations(IHDF5Writer h5w, Taxon modifiedTaxon) {
        if (HDF5Utils.isTaxaLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        String path = Tassel5HDF5Constants.getTaxonPath(modifiedTaxon.getName());
        if (!h5w.exists(path)) {
            throw new IllegalStateException("Taxon does not already exist to replace annotations of");
        }
        SetMultimap<String, String> annoMap = modifiedTaxon.getAnnotationAsMap();
        for (String keys : annoMap.keys()) {
            String s = Joiner.on((String)",").join((Iterable)annoMap.get((Object)keys));
            h5w.setStringAttribute(path, keys, s);
        }
    }

    public static Taxon getTaxon(IHDF5Reader reader, String taxonName) {
        String taxonPath = Tassel5HDF5Constants.getTaxonPath(taxonName);
        if (!reader.exists(taxonPath)) {
            return null;
        }
        Taxon.Builder tb = new Taxon.Builder(taxonName);
        for (String a : reader.getAllAttributeNames(taxonPath)) {
            for (String s : Splitter.on((String)",").split((CharSequence)reader.getStringAttribute(taxonPath, a))) {
                tb.addAnno(a, s);
            }
        }
        return tb.build();
    }

    public static List<String> getAllTaxaNames(IHDF5Reader reader) {
        ArrayList<String> taxaNames = new ArrayList<String>();
        if (reader.exists("Taxa/TaxaOrder")) {
            for (String s : reader.readStringArray("Taxa/TaxaOrder")) {
                taxaNames.add(s);
            }
        } else {
            List fields = reader.getAllGroupMemberInformation("Taxa", true);
            for (HDF5LinkInformation is : fields) {
                if (!is.isGroup()) continue;
                taxaNames.add(is.getName());
            }
        }
        return taxaNames;
    }

    public static void writeHDF5TaxaNumTaxa(IHDF5Writer h5w, int numTaxa) {
        h5w.setIntAttribute("Taxa/", "numTaxa", numTaxa);
    }

    public static int getHDF5TaxaNumTaxa(IHDF5Reader reader) {
        return reader.getIntAttribute("Taxa/", "numTaxa");
    }

    public static int getHDF5GenotypeTaxaNumber(IHDF5Reader reader) {
        return reader.getIntAttribute("Genotypes/", "numTaxa");
    }

    public static void createHDF5GenotypeModule(IHDF5Writer h5w) {
        if (h5w.exists("Genotypes")) {
            throw new UnsupportedOperationException("Genotypes module already exists in HDF5 file");
        }
        h5w.createGroup("Genotypes");
        h5w.setBooleanAttribute("Genotypes/", "locked", false);
    }

    public static void lockHDF5GenotypeModule(IHDF5Writer h5w) {
        h5w.setBooleanAttribute("Genotypes/", "locked", true);
    }

    public static void unlockHDF5GenotypeModule(IHDF5Writer h5w) {
        h5w.setBooleanAttribute("Genotypes/", "locked", false);
    }

    public static boolean doesGenotypeModuleExist(IHDF5Reader reader) {
        return reader.exists("Genotypes");
    }

    public static boolean isHDF5GenotypeLocked(IHDF5Reader reader) {
        if (!reader.exists("Genotypes/")) {
            return false;
        }
        return reader.getBooleanAttribute("Genotypes/", "locked");
    }

    public static void writeHDF5GenotypesMaxNumAlleles(IHDF5Writer h5w, int maxNumAlleles) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        h5w.setIntAttribute("Genotypes/", "maxNumAlleles", maxNumAlleles);
    }

    public static void writeHDF5GenotypesRetainRareAlleles(IHDF5Writer h5w, boolean retainRareAlleles) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        h5w.setBooleanAttribute("Genotypes/", "retainRareAlleles", retainRareAlleles);
    }

    public static void writeHDF5GenotypesNumTaxa(IHDF5Writer h5w, int numTaxa) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        h5w.setIntAttribute("Genotypes/", "numTaxa", numTaxa);
    }

    public static void writeHDF5GenotypesScoreType(IHDF5Writer h5w, String scoreType) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        h5w.setStringAttribute("Genotypes/", "maxNumAlleles", scoreType);
    }

    public static void writeHDF5GenotypesAlleleStates(IHDF5Writer h5w, String[][] aEncodings) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        int numEncodings = aEncodings.length;
        int numStates = aEncodings[0].length;
        MDArray alleleEncodings = new MDArray(String.class, new int[]{numEncodings, numStates});
        for (int s = 0; s < numEncodings; ++s) {
            for (int x = 0; x < numStates; ++x) {
                alleleEncodings.set((Object)aEncodings[s][x], s, x);
            }
        }
        h5w.createStringMDArray("Genotypes/AlleleStates", 100, new int[]{numEncodings, numStates});
        h5w.writeStringMDArray("Genotypes/AlleleStates", alleleEncodings);
    }

    public static byte[] getHDF5GenotypesCalls(IHDF5Reader reader, String taxon) {
        String callsPath = Tassel5HDF5Constants.getGenotypesCallsPath(taxon);
        return reader.readAsByteArray(callsPath);
    }

    public static void writeHDF5GenotypesCalls(IHDF5Writer h5w, String taxon, byte[] calls) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        String callsPath = Tassel5HDF5Constants.getGenotypesCallsPath(taxon);
        if (h5w.exists(callsPath)) {
            throw new IllegalStateException("Taxa Calls Already Exists:" + taxon);
        }
        h5w.createByteArray(callsPath, (long)calls.length, Math.min(65536, calls.length), Tassel5HDF5Constants.intDeflation);
        HDF5Utils.writeHDF5EntireArray(callsPath, h5w, calls.length, 65536, calls);
    }

    public static void replaceHDF5GenotypesCalls(IHDF5Writer h5w, String taxon, byte[] calls) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        String callsPath = Tassel5HDF5Constants.getGenotypesCallsPath(taxon);
        if (!h5w.exists(callsPath)) {
            throw new IllegalStateException("Taxa Calls Do Not Already Exists to replace");
        }
        HDF5Utils.writeHDF5EntireArray(callsPath, h5w, calls.length, 65536, calls);
    }

    public static void replaceHDF5GenotypesCalls(IHDF5Writer h5w, String taxon, int startSite, byte[] calls) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        String callsPath = Tassel5HDF5Constants.getGenotypesCallsPath(taxon);
        if (!h5w.exists(callsPath)) {
            throw new IllegalStateException("Taxa Calls Do Not Already Exists to replace");
        }
        if (startSite % 65536 != 0) {
            throw new IllegalStateException("Taxa Calls Start Site not a multiple of the block size");
        }
        HDF5Utils.writeHDF5Block(callsPath, h5w, 65536, startSite / 65536, calls);
    }

    public static byte[][] getHDF5GenotypesDepth(IHDF5Reader reader, String taxon) {
        String callsPath = Tassel5HDF5Constants.getGenotypesDepthPath(taxon);
        if (reader.exists(callsPath)) {
            return reader.readByteMatrix(callsPath);
        }
        return null;
    }

    public static boolean doesGenotypeDepthExist(IHDF5Reader reader) {
        List<String> taxaNames = HDF5Utils.getAllTaxaNames(reader);
        boolean depthExist = false;
        for (String taxon : taxaNames) {
            String callsPath = Tassel5HDF5Constants.getGenotypesDepthPath(taxon);
            if (!reader.exists(callsPath)) continue;
            depthExist = true;
            break;
        }
        return depthExist;
    }

    public static void writeHDF5GenotypesDepth(IHDF5Writer h5w, String taxon, byte[][] depth) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        String callsPath = Tassel5HDF5Constants.getGenotypesDepthPath(taxon);
        if (h5w.exists(callsPath)) {
            throw new IllegalStateException("Taxa Depth Already Exists:" + taxon);
        }
        h5w.createByteMatrix(callsPath, (long)depth.length, (long)depth[0].length, 6, Math.min(65536, depth[0].length), Tassel5HDF5Constants.intDeflation);
        HDF5Utils.writeHDF5EntireArray(callsPath, h5w, depth[0].length, 65536, depth);
    }

    public static void replaceHDF5GenotypesDepth(IHDF5Writer h5w, String taxon, byte[][] depth) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)h5w)) {
            throw new UnsupportedOperationException("Trying to write to a locked HDF5 file");
        }
        String callsPath = Tassel5HDF5Constants.getGenotypesDepthPath(taxon);
        if (!h5w.exists(callsPath)) {
            throw new IllegalStateException("Taxa Depth Does Not Already Exists to Replace");
        }
        HDF5Utils.writeHDF5EntireArray(callsPath, h5w, depth[0].length, 65536, depth);
    }

    public static byte[] getHDF5Alleles(IHDF5Reader reader, WHICH_ALLELE allele) {
        return reader.readByteMatrixBlockWithOffset("Genotypes/_Descriptors/AlleleFreqOrder", 1, HDF5Utils.getHDF5PositionNumber(reader), (long)allele.index(), 0L)[0];
    }

    public static byte[] getHDF5GenotypeSiteScores(IHDF5Reader reader, String taxon, String siteScoreType) {
        String path = Tassel5HDF5Constants.getGenotypesSiteScorePath(taxon, siteScoreType);
        if (reader.exists(path)) {
            return reader.readByteArray(path);
        }
        return null;
    }

    public static void writeHDF5GenotypeSiteScores(IHDF5Writer writer, String taxon, String siteScoreType, byte[] values) {
        String path = Tassel5HDF5Constants.getGenotypesSiteScorePath(taxon, siteScoreType);
        if (writer.exists(path)) {
            throw new IllegalStateException("HDF5Utils: writeHDF5GenotypeSiteScores: path already exists: " + path);
        }
        writer.createByteArray(path, (long)values.length, Math.min(65536, values.length), Tassel5HDF5Constants.intDeflation);
        HDF5Utils.writeHDF5EntireArray(path, writer, values.length, 65536, values);
    }

    public static int getHDF5PositionNumber(IHDF5Reader reader) {
        return reader.getIntAttribute("Positions/", "numSites");
    }

    public static void createHDF5PositionModule(IHDF5Writer h5w) {
        h5w.createGroup("Positions");
    }

    public static void writeHDF5PositionNumSite(IHDF5Writer h5w, int numSites) {
        h5w.setIntAttribute("Positions/", "numSites", numSites);
    }

    public static byte[] getHDF5ReferenceAlleles(IHDF5Reader reader) {
        return HDF5Utils.getHDF5Alleles(reader, "Positions/ReferenceAlleles", 0, HDF5Utils.getHDF5PositionNumber(reader));
    }

    public static byte[] getHDF5ReferenceAlleles(IHDF5Reader reader, int startSite, int numSites) {
        return HDF5Utils.getHDF5Alleles(reader, "Positions/ReferenceAlleles", startSite, numSites);
    }

    public static byte[] getHDF5AncestralAlleles(IHDF5Reader reader) {
        return HDF5Utils.getHDF5Alleles(reader, "Positions/AncestralAlleles", 0, HDF5Utils.getHDF5PositionNumber(reader));
    }

    public static byte[] getHDF5AncestralAlleles(IHDF5Reader reader, int startSite, int numSites) {
        return HDF5Utils.getHDF5Alleles(reader, "Positions/AncestralAlleles", startSite, numSites);
    }

    private static byte[] getHDF5Alleles(IHDF5Reader reader, String allelePath, int startSite, int numSites) {
        if (reader.exists(allelePath)) {
            return reader.readByteArrayBlockWithOffset(allelePath, numSites, (long)startSite);
        }
        byte[] unknown = new byte[numSites];
        Arrays.fill(unknown, (byte)15);
        return unknown;
    }

    public static void createHDF5TagModule(IHDF5Writer h5w, int tagLengthInLong) {
        if (h5w.exists("Tags")) {
            throw new UnsupportedOperationException("Tag module already exists in HDF5 file");
        }
        h5w.createGroup("Tags");
        h5w.setBooleanAttribute("Tags/", "locked", false);
        h5w.setIntAttribute("Tags/", "tagLengthLong", tagLengthInLong);
        h5w.setIntAttribute("Tags/", "tagCount", 0);
    }

    public static boolean isHDF5TagLocked(IHDF5Reader reader) {
        if (!reader.exists("Tags//locked")) {
            return false;
        }
        return reader.getBooleanAttribute("Tags/", "locked");
    }

    public static int getHDF5TagCount(IHDF5Reader reader) {
        return reader.getIntAttribute("Tags/", "tagCount");
    }

    public static int getHDF5TagLengthInLong(IHDF5Reader reader) {
        return reader.getIntAttribute("Tags/", "tagLengthLong");
    }

    public static boolean doTagsExist(IHDF5Reader reader) {
        return reader.exists("Tags/Tags");
    }

    public static String getTagPath(Tag tag) {
        return null;
    }

    public static long[][] getTags(IHDF5Reader reader) {
        return reader.readLongMatrix("Tags/Tags");
    }

    public static synchronized void writeTagDistributionBucket(IHDF5Writer h5w, int bucket, long[][] tags, short[] length, int[] encodedTaxaDist, int maxTaxa, int[] tagDistOffset) {
        String path = "Tags/" + bucket + "/";
        h5w.createGroup(path);
        h5w.writeLongMatrix(path + "TagSeq", tags, Tassel5HDF5Constants.intDeflation);
        h5w.writeShortArray(path + "TagLength", length, Tassel5HDF5Constants.intDeflation);
        h5w.createIntArray(path + "TagDist", (long)encodedTaxaDist.length, Math.min(65536, encodedTaxaDist.length), Tassel5HDF5Constants.intDeflation);
        h5w.writeIntArray(path + "TagDist", encodedTaxaDist, Tassel5HDF5Constants.intDeflation);
        h5w.setIntAttribute(path + "TagDist", "MaxTaxa", maxTaxa);
        h5w.createIntArray(path + "TagTaxaDistOffset", tagDistOffset.length, Tassel5HDF5Constants.intDeflation);
        h5w.writeIntArray(path + "TagTaxaDistOffset", tagDistOffset, Tassel5HDF5Constants.intDeflation);
    }

    public static boolean doTagsByTaxaExist(IHDF5Reader reader) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public static void writeHDF5EntireArray(String objectPath, IHDF5Writer myWriter, int objMaxLength, int blockSize, Object val) {
        int blocks = (objMaxLength - 1) / blockSize + 1;
        for (int block = 0; block < blocks; ++block) {
            int j;
            Object sval;
            Object oval;
            int startPos = block * blockSize;
            int length = Math.min(objMaxLength - startPos, blockSize);
            if (val instanceof byte[][]) {
                oval = (byte[][])val;
                sval = new byte[((byte[][])oval).length][length];
                for (j = 0; j < ((byte[][])oval).length; ++j) {
                    sval[j] = Arrays.copyOfRange(oval[j], startPos, startPos + length);
                }
                HDF5Utils.writeHDF5Block(objectPath, myWriter, blockSize, block, sval);
                continue;
            }
            if (val instanceof int[][]) {
                oval = (int[][])val;
                sval = new int[((byte[][])oval).length][length];
                for (j = 0; j < ((byte[][])oval).length; ++j) {
                    sval[j] = (byte[])Arrays.copyOfRange((int[])oval[j], startPos, startPos + length);
                }
                HDF5Utils.writeHDF5Block(objectPath, myWriter, blockSize, block, sval);
                continue;
            }
            if (val instanceof long[][]) {
                oval = (long[][])val;
                sval = new long[((byte[][])oval).length][length];
                for (j = 0; j < ((byte[][])oval).length; ++j) {
                    sval[j] = (byte[])Arrays.copyOfRange((long[])oval[j], startPos, startPos + length);
                }
                HDF5Utils.writeHDF5Block(objectPath, myWriter, blockSize, block, sval);
                continue;
            }
            if (val instanceof byte[]) {
                HDF5Utils.writeHDF5Block(objectPath, myWriter, blockSize, block, Arrays.copyOfRange((byte[])val, startPos, startPos + length));
                continue;
            }
            if (val instanceof float[]) {
                HDF5Utils.writeHDF5Block(objectPath, myWriter, blockSize, block, Arrays.copyOfRange((float[])val, startPos, startPos + length));
                continue;
            }
            if (val instanceof int[]) {
                HDF5Utils.writeHDF5Block(objectPath, myWriter, blockSize, block, Arrays.copyOfRange((int[])val, startPos, startPos + length));
                continue;
            }
            if (!(val instanceof String[])) continue;
            HDF5Utils.writeHDF5Block(objectPath, myWriter, blockSize, block, Arrays.copyOfRange((String[])val, startPos, startPos + length));
        }
    }

    public static void writeHDF5Block(String objectPath, IHDF5Writer myWriter, int blockSize, int block, Object val) {
        int startPos = block * blockSize;
        if (val instanceof byte[][]) {
            byte[][] bval = (byte[][])val;
            myWriter.writeByteMatrixBlockWithOffset(objectPath, bval, bval.length, bval[0].length, 0L, (long)startPos);
        } else if (val instanceof byte[]) {
            byte[] fval = (byte[])val;
            myWriter.writeByteArrayBlockWithOffset(objectPath, fval, fval.length, (long)startPos);
        } else if (val instanceof float[]) {
            float[] fval = (float[])val;
            myWriter.writeFloatArrayBlockWithOffset(objectPath, fval, fval.length, (long)startPos);
        } else if (val instanceof int[]) {
            int[] fval = (int[])val;
            myWriter.writeIntArrayBlockWithOffset(objectPath, fval, fval.length, (long)startPos);
        } else if (val instanceof int[][]) {
            int[][] ival = (int[][])val;
            myWriter.writeIntMatrixBlockWithOffset(objectPath, ival, ival.length, ival[0].length, 0L, (long)startPos);
        } else if (val instanceof long[][]) {
            long[][] lval = (long[][])val;
            myWriter.writeLongMatrixBlockWithOffset(objectPath, lval, lval.length, lval[0].length, 0L, (long)startPos);
        } else if (val instanceof String[]) {
            String[] sval = (String[])val;
            myWriter.writeStringArrayBlockWithOffset(objectPath, sval, sval.length, (long)startPos);
        }
    }
}

