/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Properties;
import net.maizegenetics.prefs.TasselPrefs;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoggingUtils {
    private static final Logger myLogger = Logger.getLogger(LoggingUtils.class);
    private static final PrintStream myOriginalOutputStream = System.out;
    private static final PrintStream myOriginalErrStream = System.err;
    private static PrintStream myPrintStream;

    private LoggingUtils() {
    }

    public static void setupLogging() {
        if (TasselPrefs.getLogDebug()) {
            LoggingUtils.setupDebugLogging();
        } else {
            System.setOut(myOriginalOutputStream);
            System.setErr(myOriginalErrStream);
            LoggingUtils.sendLog4jToStdout();
        }
    }

    public static void setupDebugLogging() {
        System.setOut(myOriginalOutputStream);
        System.setErr(myOriginalErrStream);
        LoggingUtils.sendDebugLog4jToStdout();
    }

    public static void setupLogging(PrintStream stream) {
        if (TasselPrefs.getLogDebug()) {
            LoggingUtils.setupDebugLogging(stream);
        } else {
            System.setOut(stream);
            System.setErr(stream);
            LoggingUtils.sendLog4jToStdout();
        }
    }

    public static void setupDebugLogging(PrintStream stream) {
        System.setOut(stream);
        System.setErr(stream);
        LoggingUtils.sendDebugLog4jToStdout();
    }

    public static void setupLogfile(String logFileName) throws FileNotFoundException {
        if (TasselPrefs.getLogDebug()) {
            LoggingUtils.setupDebugLogfile(logFileName);
        } else {
            File logFile = new File(logFileName);
            myLogger.info((Object)("Log File: " + logFile.getAbsolutePath()));
            myPrintStream = new PrintStream(logFile);
            System.setOut(myPrintStream);
            System.setErr(myPrintStream);
            LoggingUtils.sendLog4jToStdout();
        }
    }

    public static void setupDebugLogfile(String logFileName) throws FileNotFoundException {
        File logFile = new File(logFileName);
        myLogger.info((Object)("Log File: " + logFile.getAbsolutePath()));
        myPrintStream = new PrintStream(logFile);
        System.setOut(myPrintStream);
        System.setErr(myPrintStream);
        LoggingUtils.sendDebugLog4jToStdout();
    }

    public static void closeLogfile() {
        if (myPrintStream != null) {
            myPrintStream.close();
        }
    }

    private static void sendLog4jToStdout() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.net.maizegenetics", "INFO, stdout");
        props.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.stdout.Threshold", "info");
        props.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)props);
    }

    private static void sendDebugLog4jToStdout() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.net.maizegenetics", "DEBUG, stdout");
        props.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.stdout.Threshold", "debug");
        props.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)props);
    }
}

