/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.Serializable;
import net.maizegenetics.util.AbstractTableReport;
import net.maizegenetics.util.TableReport;

public class SimpleTableReport
extends AbstractTableReport
implements Serializable,
TableReport {
    private final Object[][] myData;
    private final Object[] myColumnNames;
    private final String myName;

    public SimpleTableReport(String theName, Object[] columnNames, Object[][] theData) {
        this.myData = theData;
        this.myColumnNames = columnNames;
        this.myName = theName;
    }

    public SimpleTableReport(TableReport tr) {
        int numRows = (int)tr.getRowCount();
        if ((long)numRows != tr.getRowCount()) {
            throw new IllegalArgumentException("SimpleTableReport: init: This implementation can't support more rows than: 2147483647");
        }
        this.myData = new Object[numRows][tr.getColumnCount()];
        for (int i = 0; i < numRows; ++i) {
            System.arraycopy(tr.getRow(i), 0, this.myData[i], 0, numRows);
        }
        this.myColumnNames = tr.getTableColumnNames();
        this.myName = tr.getTableTitle();
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.myColumnNames;
    }

    @Override
    public Object[] getRow(long row) {
        return this.myData[(int)row];
    }

    @Override
    public String getTableTitle() {
        return this.myName;
    }

    @Override
    public long getRowCount() {
        return this.myData.length;
    }

    @Override
    public long getElementCount() {
        return this.getRowCount() * (long)this.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return this.myColumnNames.length;
    }

    @Override
    public Object getValueAt(long row, int col) {
        return this.myData[(int)row][col];
    }
}

