/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.maizegenetics.util.TrieNode;

public class StringTrie {
    private TrieNode root = new TrieNode();

    public void addWord(String word) {
        this.root.addWord(word.toLowerCase());
    }

    public void addAllWords(Collection<String> words) {
        for (String w : words) {
            this.addWord(w);
        }
    }

    public boolean contains(String s) {
        TrieNode currentNode = this.root;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!currentNode.containsKey(c)) {
                return false;
            }
            currentNode = currentNode.getNode(c);
        }
        return true;
    }

    public List getWords(String prefix) {
        TrieNode lastNode = this.root;
        for (int i = 0; i < prefix.length(); ++i) {
            if ((lastNode = lastNode.getNode(prefix.charAt(i))) != null) continue;
            return new ArrayList();
        }
        return lastNode.getWords();
    }

    public String longestPrefix(String input) {
        String result = "";
        int length = input.length();
        TrieNode crawl = this.root;
        int prevMatch = 0;
        for (int level = 0; level < length - 1; ++level) {
            char ch = input.charAt(level);
            TrieNode child = crawl.getNode(ch);
            if (!crawl.containsKey(ch)) break;
            result = result + ch;
            crawl = child;
            if (!crawl.isWord) continue;
            prevMatch = level + 1;
        }
        if (!crawl.isWord) {
            return result.substring(0, prevMatch);
        }
        return result;
    }

    public static void main(String[] args) {
        int ch = 97;
        StringTrie trie = new StringTrie();
        trie.addWord("alpha");
        trie.addWord("beta");
        trie.addWord("altare");
        trie.addWord("altarations");
        trie.addWord("bet");
        trie.addWord("al");
        List info = trie.getWords("al");
        TrieNode t = trie.root;
        List child = t.getWords();
        Object alpha = child.get(0);
        String yaay = "altarationsX";
        String barcode1 = "ACGACAACGACG";
        String barcode2 = "ACCAACGACG";
        String query = "ACGACAACGACGACTGATCGATCGATGTACGATCGATCG";
        String perid = trie.longestPrefix(yaay);
        System.out.println(perid);
    }
}

